/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Misc {
    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static String getStackToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    public static <T> T convertNumber(Object value, Class<?> targetType) {
        if (targetType != value.getClass() && value instanceof Number) {
            Number res;
            Number n = (Number)value;
            if (targetType == Byte.TYPE || targetType == Byte.class) {
                res = n.byteValue();
            } else if (targetType == Short.TYPE || targetType == Short.class) {
                res = n.shortValue();
            } else if (targetType == Integer.TYPE || targetType == Integer.class) {
                res = n.intValue();
            } else if (targetType == Long.TYPE || targetType == Long.class) {
                res = n.longValue();
            } else if (targetType == Float.TYPE || targetType == Float.class) {
                res = Float.valueOf(n.floatValue());
            } else if (targetType == Double.TYPE || targetType == Double.class) {
                res = n.doubleValue();
            } else {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(value.getClass()) + " to type " + String.valueOf(targetType));
            }
            return Misc.cast(res);
        }
        return Misc.cast(value);
    }

    public static Class<?> getClazzGeneric(Class<?> targetClazz, Class<?> sourceClazz, int sourceGenericIdx) {
        record ResOrIdx(Class<?> res, int idx) {
            static ResOrIdx of(Class<?> res) {
                return new ResOrIdx(res, -1);
            }

            static ResOrIdx of(int idx) {
                return new ResOrIdx(null, idx);
            }

            static ResOrIdx calc(Class<?> curr, Class<?> sourceClazz, int sourceIdx) {
                if (curr == Object.class) {
                    return null;
                }
                if (curr == sourceClazz) {
                    return ResOrIdx.of(sourceIdx);
                }
                ArrayList<Type> supers = new ArrayList<Type>();
                supers.add(curr.getGenericSuperclass());
                supers.addAll(List.of(curr.getGenericInterfaces()));
                for (Type sup : supers) {
                    ResOrIdx res;
                    if (sup instanceof ParameterizedType) {
                        ParameterizedType supP = (ParameterizedType)sup;
                        res = ResOrIdx.calc((Class)supP.getRawType(), sourceClazz, sourceIdx);
                        if (res == null) continue;
                        if (res.res != null) {
                            return res;
                        }
                        int idx = res.idx();
                        Type type = supP.getActualTypeArguments()[idx];
                        if (type instanceof Class) {
                            Class clazz = (Class)type;
                            return ResOrIdx.of(clazz);
                        }
                        String name = type.getTypeName();
                        int i = -1;
                        for (TypeVariable<Class<?>> param : curr.getTypeParameters()) {
                            ++i;
                            if (!name.equals(param.getName())) continue;
                            return ResOrIdx.of(i);
                        }
                        throw new RuntimeException("Generic type not match: " + Arrays.toString(curr.getTypeParameters()) + " vs " + Arrays.toString(supP.getActualTypeArguments()));
                    }
                    if (sup instanceof Class) {
                        Class supC = (Class)sup;
                        res = ResOrIdx.calc(supC, sourceClazz, sourceIdx);
                        if (res == null) continue;
                        if (res.res == null) {
                            throw new RuntimeException("Generic should be resolved: " + String.valueOf(curr) + ", " + Arrays.toString(curr.getTypeParameters()));
                        }
                        return res;
                    }
                    throw new RuntimeException("Neither ParameterizedType nor Class: " + String.valueOf(sup == null ? null : sup.getClass()) + ", " + String.valueOf(sup));
                }
                return null;
            }
        }
        ResOrIdx res = ResOrIdx.calc(targetClazz, sourceClazz, sourceGenericIdx);
        if (res == null) {
            throw new RuntimeException(String.valueOf(targetClazz) + " does not extend " + String.valueOf(sourceClazz));
        }
        if (res.res == null) {
            throw new RuntimeException("Cannot obtain the actual type of generic \"" + String.valueOf(sourceClazz.getTypeParameters()[sourceGenericIdx]) + "\" in " + String.valueOf(sourceClazz) + ", which is inherited by " + String.valueOf(targetClazz));
        }
        return res.res;
    }

    public static <T> Collection<T> shuffle(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.shuffle(list);
        return list;
    }

    public static String format3Digits(double num) {
        if (num >= 100.0) {
            return String.valueOf(Math.round(num));
        }
        if (num >= 10.0) {
            return String.format("%.1f", num);
        }
        if (num >= 0.0) {
            return String.format("%.2f", num);
        }
        if (num > -10.0) {
            return String.format("%.1f", num);
        }
        return String.valueOf(Math.round(num));
    }

    public static String format4Digits(double num) {
        if (num >= 1000.0) {
            return String.valueOf(Math.round(num));
        }
        if (num >= 100.0) {
            return String.format("%.1f", num);
        }
        if (num >= 10.0) {
            return String.format("%.2f", num);
        }
        if (num >= 0.0) {
            return String.format("%.3f", num);
        }
        if (num > -10.0) {
            return String.format("%.2f", num);
        }
        if (num > -100.0) {
            return String.format("%.1f", num);
        }
        return String.valueOf(Math.round(num));
    }
}

