/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.util;

import java.util.Objects;

public record Pair<F, S>(F first, S second) {
    public static <F, S> Pair<F, S> of(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public static <F, S> Pair<F, S> ofFirst(F first) {
        return Pair.of(first, null);
    }

    public static <F, S> Pair<F, S> ofSecond(S second) {
        return Pair.of(null, second);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        F first1;
        Object object;
        if (other == this) {
            return true;
        }
        if (!(other instanceof Pair)) return false;
        Pair pair = (Pair)other;
        try {
            first1 = object = pair.first();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object second1 = object = pair.second();
        if (!Objects.equals(this.first, first1)) return false;
        if (!Objects.equals(this.second, second1)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.first.hashCode() * 37 + this.second.hashCode();
    }
}

