/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.common.util;

import java.util.Objects;

public record Result<T>(T get) {
    private static final Result<?> EMPTY = new Result<Object>(null);

    public static <T> Result<T> empty() {
        Result<?> t = EMPTY;
        return t;
    }

    public static <T> Result<T> of(T value) {
        return value == null ? Result.empty() : new Result<T>(value);
    }

    public static boolean failed(Result<?> result) {
        return result == null;
    }

    public static <T> Result<T> merge(T t1, T t2) {
        if (t1 == null) {
            return Result.of(t2);
        }
        if (t2 == null) {
            return Result.of(t1);
        }
        if (Objects.equals(t1, t2)) {
            return Result.of(t1);
        }
        return null;
    }
}

