/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.config;

import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.config.Configs;
import io.github.xienaoban.biologydictionary.config.ConfigsManager;
import io.github.xienaoban.biologydictionary.config.annotation.Config;
import io.github.xienaoban.biologydictionary.config.annotation.ConfigCategory;
import io.github.xienaoban.biologydictionary.config.annotation.ConfigEntry;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.ColorFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ClothConfigScreenProvider {
    private static final Configs DEFAULT_CONFIGS = new Configs();

    public static class_437 provideScreen(class_437 parent) {
        Configs configs = ConfigsManager.getInstance();
        Config configAnnotation = configs.getClass().getAnnotation(Config.class);
        if (configAnnotation == null) {
            throw new IllegalStateException("Configs class must be annotated with @Config");
        }
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)configAnnotation.value())).setSavingRunnable(ConfigsManager::save);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        for (Field categoryField : configs.getClass().getDeclaredFields()) {
            if (!categoryField.isAnnotationPresent(ConfigCategory.class)) continue;
            ConfigCategory categoryAnnotation = categoryField.getAnnotation(ConfigCategory.class);
            String categoryKey = categoryAnnotation.value();
            me.shedaniel.clothconfig2.api.ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)categoryKey));
            try {
                categoryField.setAccessible(true);
                Object categoryObject = categoryField.get(configs);
                for (Field entryField : categoryObject.getClass().getDeclaredFields()) {
                    if (!entryField.isAnnotationPresent(ConfigEntry.class)) continue;
                    ConfigEntry entryAnnotation = entryField.getAnnotation(ConfigEntry.class);
                    ClothConfigScreenProvider.addConfigEntry(category, entryBuilder, entryField, entryAnnotation, categoryObject);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access config category field", e);
            }
        }
        return builder.build();
    }

    private static void addConfigEntry(me.shedaniel.clothconfig2.api.ConfigCategory category, ConfigEntryBuilder entryBuilder, Field field, ConfigEntry annotation, Object categoryObject) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        String entryKey = Configs.getConfigNameTranslationKey(fieldName);
        String tooltipKey = entryKey + ".tooltip";
        class_5250 fieldText = class_2561.method_43471((String)entryKey);
        class_5250 tooltipText = class_2561.method_43471((String)tooltipKey);
        try {
            ColorFieldBuilder builder;
            field.setAccessible(true);
            Object currentValue = field.get(categoryObject);
            Object defaultValue = ClothConfigScreenProvider.getDefaultValue(field);
            if ((fieldType == Integer.TYPE || fieldType == Integer.class) && (fieldName.contains("color") || fieldName.contains("Color"))) {
                builder = entryBuilder.startAlphaColorField((class_2561)fieldText, ((Integer)currentValue).intValue());
            } else if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                builder = entryBuilder.startBooleanToggle((class_2561)fieldText, ((Boolean)currentValue).booleanValue());
            } else if (fieldType.isPrimitive() || Number.class.isAssignableFrom(fieldType)) {
                IntFieldBuilder builderNum;
                if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                    builderNum = entryBuilder.startIntField((class_2561)fieldText, ((Integer)currentValue).intValue());
                } else if (fieldType == Long.TYPE || fieldType == Long.class) {
                    builderNum = entryBuilder.startLongField((class_2561)fieldText, ((Long)currentValue).longValue());
                } else if (fieldType == Float.TYPE || fieldType == Float.class) {
                    builderNum = entryBuilder.startFloatField((class_2561)fieldText, ((Float)currentValue).floatValue());
                } else if (fieldType == Double.TYPE || fieldType == Double.class) {
                    builderNum = entryBuilder.startDoubleField((class_2561)fieldText, ((Double)currentValue).doubleValue());
                } else {
                    throw new RuntimeException("Unsupported field type: " + String.valueOf(fieldType));
                }
                if (annotation.min() != Double.MIN_VALUE) {
                    builderNum.setMin(Misc.convertNumber(annotation.min(), fieldType));
                }
                if (annotation.max() != Double.MAX_VALUE) {
                    builderNum.setMax(Misc.convertNumber(annotation.max(), fieldType));
                }
                builder = builderNum;
            } else if (fieldType == String.class) {
                builder = entryBuilder.startStrField((class_2561)fieldText, (String)currentValue);
            } else if (fieldType.isEnum()) {
                builder = entryBuilder.startEnumSelector((class_2561)fieldText, (Class)Misc.cast(fieldType), (Enum)Misc.cast(currentValue)).setEnumNameProvider(e -> class_2561.method_43471((String)Configs.getEnumValueTranslationKey(e)));
            } else if (List.class.isAssignableFrom(fieldType)) {
                builder = entryBuilder.startStrList((class_2561)fieldText, (List)currentValue);
            } else {
                if (Set.class.isAssignableFrom(fieldType)) {
                    List<String> currentList = ((Set)currentValue).stream().map(String::valueOf).sorted().toList();
                    List<String> defaultList = ((Set)defaultValue).stream().map(String::valueOf).sorted().toList();
                    category.addEntry((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)fieldText, currentList).setDefaultValue(defaultList).setSaveConsumer(strings -> ClothConfigScreenProvider.save(field, categoryObject, Set.copyOf(strings))).setTooltip(new class_2561[]{tooltipText}).build());
                    return;
                }
                throw new RuntimeException("Unsupported field type: " + String.valueOf(fieldType));
            }
            category.addEntry(ClothConfigScreenProvider.setEntryGeneric(builder, defaultValue, ClothConfigScreenProvider.createSaveConsumer(field, categoryObject), (class_2561)tooltipText).build());
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException("Failed to read config field value", e2);
        }
    }

    private static <T> T getDefaultValue(Field field) {
        try {
            Field categoryField = Arrays.stream(DEFAULT_CONFIGS.getClass().getDeclaredFields()).filter(field1 -> field1.getType() == field.getDeclaringClass()).findFirst().orElseThrow(() -> new RuntimeException("No config category class found: " + String.valueOf(field.getDeclaringClass())));
            categoryField.setAccessible(true);
            Object defaultCategoryObject = categoryField.get(DEFAULT_CONFIGS);
            field.setAccessible(true);
            return (T)field.get(defaultCategoryObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Consumer<T> createSaveConsumer(Field field, Object categoryObject) {
        return newValue -> ClothConfigScreenProvider.save(field, categoryObject, newValue);
    }

    private static void save(Field field, Object categoryObject, Object newValue) {
        try {
            field.set(categoryObject, newValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set config value", e);
        }
    }

    private static <T, B extends AbstractFieldBuilder<T, ?, B>> B setEntryGeneric(@NotNull AbstractFieldBuilder<?, ?, ?> builder, Object defaultValue, Consumer<?> saveConsumer, class_2561 tooltip) {
        AbstractFieldBuilder b = (AbstractFieldBuilder)Misc.cast(builder);
        Object d = Misc.cast(defaultValue);
        Consumer s = (Consumer)Misc.cast(saveConsumer);
        ((AbstractFieldBuilder)((AbstractFieldBuilder)b.setDefaultValue(d)).setSaveConsumer(s)).setTooltip(new class_2561[]{tooltip});
        return (B)b;
    }
}

