/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.config;

import io.github.xienaoban.biologydictionary.config.annotation.Config;
import io.github.xienaoban.biologydictionary.config.annotation.ConfigCategory;
import io.github.xienaoban.biologydictionary.config.annotation.ConfigEntry;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@Config(value="config.biologydictionary.title")
public final class Configs {
    @ConfigCategory(value="config.biologydictionary.category.server")
    private final ServerConfigs server = new ServerConfigs();
    @ConfigCategory(value="config.biologydictionary.category.client")
    private final ClientConfigs client = new ClientConfigs();

    public ServerConfigs getServer() {
        return this.server;
    }

    public ClientConfigs getClient() {
        return this.client;
    }

    public static String getConfigNameTranslationKey(String fieldName) {
        return "config.biologydictionary.entry." + fieldName;
    }

    public static String getEnumValueTranslationKey(Enum<?> enumValue) {
        return "enum." + enumValue.getClass().getName().replace('$', '.') + "." + enumValue.name();
    }

    public void forEachConfigEntry(BiConsumer<String, ConfigEntryInfo> categoryConsumer) {
        for (Field categoryField : this.getClass().getDeclaredFields()) {
            if (!categoryField.isAnnotationPresent(ConfigCategory.class)) continue;
            try {
                categoryField.setAccessible(true);
                Object categoryObject = categoryField.get(this);
                for (Field entryField : categoryObject.getClass().getDeclaredFields()) {
                    if (!entryField.isAnnotationPresent(ConfigEntry.class)) continue;
                    ConfigEntry annotation = entryField.getAnnotation(ConfigEntry.class);
                    ConfigEntryInfo info = new ConfigEntryInfo(entryField, annotation, categoryObject);
                    categoryConsumer.accept(categoryField.getName(), info);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access config field", e);
            }
        }
    }

    public static void forEachConfigEntryInCategory(Object categoryObject, Consumer<ConfigEntryInfo> consumer) {
        for (Field entryField : categoryObject.getClass().getDeclaredFields()) {
            if (!entryField.isAnnotationPresent(ConfigEntry.class)) continue;
            ConfigEntry annotation = entryField.getAnnotation(ConfigEntry.class);
            ConfigEntryInfo info = new ConfigEntryInfo(entryField, annotation, categoryObject);
            consumer.accept(info);
        }
    }

    public static class ServerConfigs {
        @ConfigEntry
        boolean bookItemRequired = true;
        @ConfigEntry
        boolean bookItemObtainableFromWanderingTrader = true;
        @ConfigEntry
        Set<String> bannedPlayerSkills = Set.of();

        public boolean isBookItemRequired() {
            return this.bookItemRequired;
        }

        public boolean isBookItemObtainableFromWanderingTrader() {
            return this.bookItemObtainableFromWanderingTrader;
        }

        public Set<String> getBannedPlayerSkills() {
            return this.bannedPlayerSkills;
        }
    }

    public static class ClientConfigs {
        @ConfigEntry
        FirstPersonShoulderEntityPosition firstPersonShoulderEntityPosition = FirstPersonShoulderEntityPosition.BOTTOM;

        public FirstPersonShoulderEntityPosition getFirstPersonShoulderEntityPosition() {
            return this.firstPersonShoulderEntityPosition;
        }

        public static enum FirstPersonShoulderEntityPosition {
            NONE,
            BOTTOM,
            SIDES,
            TOP;

        }
    }

    public record ConfigEntryInfo(Field field, ConfigEntry annotation, Object categoryObject) {
        public String getName() {
            return this.field.getName();
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public Object getValue() {
            return this.getValue(this.categoryObject);
        }

        public Object getValue(Object anotherCategoryObject) {
            try {
                this.field.setAccessible(true);
                return this.field.get(anotherCategoryObject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to read config value", e);
            }
        }
    }
}

