/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.config;

import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.common.util.DevUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.config.Configs;
import io.github.xienaoban.biologydictionary.config.annotation.ConfigCategory;
import io.github.xienaoban.biologydictionary.config.annotation.ConfigEntry;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class ConfigsManager {
    private static final Configs INSTANCE = new Configs();
    private static volatile Configs.ServerConfigs serverConfigs = INSTANCE.getServer();
    private static final Configs.ClientConfigs clientConfigs = INSTANCE.getClient();

    private ConfigsManager() {
    }

    public static Configs getInstance() {
        return INSTANCE;
    }

    public static Configs.ServerConfigs getServer() {
        return serverConfigs;
    }

    @Environment(value=EnvType.CLIENT)
    public static Configs.ClientConfigs getClient() {
        return clientConfigs;
    }

    @Environment(value=EnvType.CLIENT)
    public static void setRemoteServerConfigs(Configs.ServerConfigs remoteConfigs) {
        serverConfigs = remoteConfigs;
        BiologyDictionary.LOGGER.info("Using remote server configs");
    }

    @Environment(value=EnvType.CLIENT)
    public static void setLocalServerConfigs() {
        serverConfigs = INSTANCE.getServer();
        BiologyDictionary.LOGGER.info("Using local server configs");
    }

    private static Path getConfigPath() {
        return DevUtils.getConfigDir().resolve("biologydictionary.yml");
    }

    public static void save() {
        Path configPath = ConfigsManager.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
            for (Field categoryField : INSTANCE.getClass().getDeclaredFields()) {
                if (!categoryField.isAnnotationPresent(ConfigCategory.class)) continue;
                categoryField.setAccessible(true);
                Object categoryObject = categoryField.get(INSTANCE);
                String fieldName = categoryField.getName();
                data.put(fieldName, ConfigsManager.saveConfigCategoryToMap(categoryObject));
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            Yaml yaml = new Yaml(options);
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                yaml.dump(data, (Writer)writer);
            }
            BiologyDictionary.LOGGER.info("Configuration saved to {}", (Object)configPath.toAbsolutePath());
        }
        catch (IOException | IllegalAccessException e) {
            BiologyDictionary.LOGGER.error("Failed to save configuration", (Throwable)e);
        }
    }

    public static void load() {
        Path configPath = ConfigsManager.getConfigPath();
        if (!Files.exists(configPath, new LinkOption[0])) {
            ConfigsManager.save();
            return;
        }
        try (FileInputStream input = new FileInputStream(configPath.toFile());){
            Yaml yaml = new Yaml();
            Map data = (Map)yaml.load((InputStream)input);
            boolean allGood = true;
            if (data != null) {
                for (Field categoryField : INSTANCE.getClass().getDeclaredFields()) {
                    String fieldName;
                    Map categoryData;
                    if (!categoryField.isAnnotationPresent(ConfigCategory.class) || (categoryData = (Map)data.get(fieldName = categoryField.getName())) == null) continue;
                    categoryField.setAccessible(true);
                    Object categoryObject = categoryField.get(INSTANCE);
                    allGood = ConfigsManager.loadConfigCategoryFromMap(categoryData, categoryObject);
                }
            }
            BiologyDictionary.LOGGER.info("Configuration loaded from {}", (Object)configPath);
            if (!allGood) {
                BiologyDictionary.LOGGER.warn("Not all the configuration entries are legal. Refresh the configuration file.");
                ConfigsManager.save();
            }
        }
        catch (IOException | IllegalAccessException e) {
            BiologyDictionary.LOGGER.error("Failed to load configuration", (Throwable)e);
            ConfigsManager.save();
        }
    }

    public static String serializeConfigCategory(Object configObject) {
        String string;
        Map<String, Object> map = ConfigsManager.saveConfigCategoryToMap(configObject);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        StringWriter writer = new StringWriter();
        try {
            yaml.dump(map, (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to serialize config", e);
            }
        }
        writer.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deserializeConfigCategory(String yamlString, Object targetObject) {
        try (StringReader reader = new StringReader(yamlString);){
            Yaml yaml = new Yaml();
            Map dataMap = (Map)yaml.load((Reader)reader);
            if (dataMap == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = ConfigsManager.loadConfigCategoryFromMap(dataMap, targetObject);
            return bl;
        }
        catch (Exception e) {
            BiologyDictionary.LOGGER.error("Failed to deserialize config", (Throwable)e);
            return false;
        }
    }

    private static Map<String, Object> saveConfigCategoryToMap(Object configObject) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Field field : configObject.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigEntry.class)) continue;
            try {
                field.setAccessible(true);
                List value = field.get(configObject);
                if (value instanceof Enum) {
                    Enum e = (Enum)((Object)value);
                    value = e.name();
                } else if (value instanceof Set) {
                    Set s = (Set)((Object)value);
                    value = s.stream().sorted().toList();
                }
                map.put(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    private static boolean loadConfigCategoryFromMap(Map<?, ?> dataMap, Object configObject) {
        boolean allGood = true;
        for (Map.Entry<?, ?> entry : dataMap.entrySet()) {
            try {
                Field field = configObject.getClass().getDeclaredField((String)entry.getKey());
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                Object convertedValue = Misc.convertNumber(entry.getValue(), fieldType);
                if (Enum.class.isAssignableFrom(fieldType)) {
                    convertedValue = Enum.valueOf(fieldType.asSubclass(Enum.class), (String)convertedValue);
                } else if (Set.class.isAssignableFrom(fieldType)) {
                    convertedValue = Set.copyOf((Collection)convertedValue);
                }
                field.set(configObject, convertedValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException | RuntimeException e) {
                allGood = false;
                BiologyDictionary.LOGGER.warn("Bad configuration entry {}: {}", entry.getKey(), entry.getValue());
                BiologyDictionary.LOGGER.warn(Misc.getStackToString(e));
            }
        }
        return allGood;
    }
}

