/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core;

import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.common.util.DevUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.core.EntityOrder;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1432;
import net.minecraft.class_1480;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3732;
import net.minecraft.class_5354;
import net.minecraft.class_5761;
import net.minecraft.class_6880;
import net.minecraft.class_7298;
import net.minecraft.class_7923;
import net.minecraft.class_9866;

public final class EntityManager {
    private static EntityManager instance = null;
    private final Map<Class<? extends class_1297>, EntityTreeNode> tree = new HashMap<Class<? extends class_1297>, EntityTreeNode>();
    private final Map<class_1299<?>, EntityClassInfo> infos = new HashMap();
    private final List<EntityClassInfo> sortedInfos = new ArrayList<EntityClassInfo>();
    private final Map<Class<? extends class_1297>, class_1299<?>> clazzToType = new HashMap();
    private final TagGroup defaultTags = new TagGroup("tag_group.biologydictionary.default", (class_2561)class_2561.method_43471((String)"tag_group.biologydictionary.default.desc"));
    private final TagGroup mcTagTags = new TagGroup("tag_group.biologydictionary.tag", (class_2561)class_2561.method_43471((String)"tag_group.biologydictionary.tag.desc"));
    private final TagGroup namespaceTags = new TagGroup("tag_group.biologydictionary.mod", (class_2561)class_2561.method_43471((String)"tag_group.biologydictionary.mod.desc"));
    private final TagGroup classTags = new TagGroup("tag_group.biologydictionary.class", (class_2561)class_2561.method_43471((String)"tag_group.biologydictionary.class.desc"));
    private final TagGroup interfaceTags = new TagGroup("tag_group.biologydictionary.interface", (class_2561)class_2561.method_43471((String)"tag_group.biologydictionary.interface.desc"));
    private final List<TagGroup> tagGroups = new ArrayList<TagGroup>(Arrays.asList(this.defaultTags, this.mcTagTags, this.namespaceTags, this.classTags, this.interfaceTags));

    public static EntityManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Class<EntityManager> clazz = EntityManager.class;
        synchronized (EntityManager.class) {
            if (instance == null) {
                try {
                    class_1937 level = BiologyDictionary.BD.justGiveMeALevel();
                    if (level != null) {
                        instance = new EntityManager(BiologyDictionary.BD.justGiveMeALevel());
                        BiologyDictionary.LOGGER.info("EntityManager initialized.");
                    } else {
                        BiologyDictionary.LOGGER.info("EntityManager not initialized.");
                    }
                }
                catch (Throwable e) {
                    instance = null;
                    BiologyDictionary.LOGGER.error("Failed to init EntityManager: {}", (Object)Misc.getStackToString(e));
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Class<EntityManager> clazz = EntityManager.class;
        synchronized (EntityManager.class) {
            if (instance != null) {
                instance = null;
                BiologyDictionary.LOGGER.info("EntityManager destroyed.");
            } else {
                BiologyDictionary.LOGGER.info("EntityManager has been destroyed.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Integer getMyPreferredEntityOrder(class_1299<?> clazz) {
        return EntityOrder.map.get(clazz);
    }

    private EntityManager(class_1937 level) {
        EntityOrder.init();
        this.initEntities(level);
        this.initEntitiesSortClassInfo();
        this.initEntitiesSortTreeNode();
        this.initMcTagTagGroups();
        this.initJavaTagGroups();
        this.initDefaultTags();
    }

    private void initEntities(class_1937 level) {
        this.tree.put(class_1297.class, new EntityTreeNode());
        for (class_1299 entityType : class_7923.field_41177) {
            EntityClassInfo entityClassInfo;
            try {
                Optional<EntityClassInfo> o = EntityClassInfo.create(entityType, level);
                if (o.isEmpty()) continue;
                entityClassInfo = o.get();
            }
            catch (Exception e) {
                BiologyDictionary.LOGGER.error("Cannot init EntityClassInfo of\"{}\": {}", (Object)class_1299.method_5890((class_1299)entityType), (Object)e);
                throw e;
            }
            this.infos.put(entityClassInfo.getType(), entityClassInfo);
            this.sortedInfos.add(entityClassInfo);
            this.clazzToType.put(entityClassInfo.getClazz(), entityType);
            this.getOrCreateEntityTreeNode(entityClassInfo.getClazz());
        }
    }

    private void initEntitiesSortClassInfo() {
        this.sortedInfos.sort((a, b) -> {
            int j;
            Integer oa = EntityManager.getMyPreferredEntityOrder(a.getType());
            Integer ob = EntityManager.getMyPreferredEntityOrder(b.getType());
            if (oa != null && ob != null) {
                return oa - ob;
            }
            if (oa != null || ob != null) {
                return oa == null ? 1 : -1;
            }
            class_2960 la = a.getLocation();
            class_2960 lb = b.getLocation();
            int cmp = la.method_12836().compareTo(lb.method_12836());
            if (cmp != 0) {
                if (la.method_12836().equals("minecraft")) {
                    return 1;
                }
                return cmp;
            }
            String pa = la.method_12832();
            String pb = lb.method_12832();
            int i = pa.length() - 1;
            for (j = pb.length() - 1; i >= 0 && j >= 0; --i, --j) {
                cmp = pa.charAt(i) - pb.charAt(j);
                if (cmp == 0) continue;
                return cmp;
            }
            return i - j;
        });
        for (int i = this.sortedInfos.size() - 1; i >= 0; --i) {
            this.sortedInfos.get(i).setSortId(i);
        }
    }

    private void initEntitiesSortTreeNode() {
        for (EntityTreeNode node : this.tree.values()) {
            node.sortSons();
        }
    }

    private void initMcTagTagGroups() {
        TagGroup tags = this.mcTagTags;
        class_7923.field_41177.method_40272().sorted(DevUtils.getResourceLocationComparator(holders -> holders.method_40251().comp_327())).forEach(holders -> {
            String key = holders.method_40251().comp_327().method_42094();
            List<EntityClassInfo> list = holders.method_40239().map(class_6880::method_40230).filter(Optional::isPresent).map(Optional::get).map(EntityUtils::getEntityType).map(this::getEntityClassInfo).filter(Objects::nonNull).sorted(Comparator.comparingInt(EntityClassInfo::getSortId)).toList();
            tags.addTag(new Tag(key, null, (class_2561)class_2561.method_43470((String)holders.method_40251().comp_327().toString())));
            tags.addAllToTag(key, list);
        });
    }

    private void initJavaTagGroups() {
        String rootClazzName = EntityManager.getClassRealName(class_1297.class);
        this.classTags.addTag(new Tag(rootClazzName, null, (class_2561)class_2561.method_43470((String)rootClazzName)));
        this.dfsEntityTree(false, (root, depth) -> {
            if (!Modifier.isAbstract(root.getClazz().getModifiers())) {
                return false;
            }
            Tag father = this.classTags.getTag(EntityManager.getClassRealName(root.getFather().getClazz()));
            String clazzName = EntityManager.getClassRealName(root.getClazz());
            this.classTags.addTag(new Tag(clazzName, father, (class_2561)class_2561.method_43470((String)clazzName)));
            return true;
        });
        for (EntityClassInfo info : this.sortedInfos) {
            String namespace = EntityUtils.getEntityTypeId(info.getType()).method_12836();
            this.namespaceTags.getOrAddTag(namespace, s -> new Tag((String)s, null, (class_2561)class_2561.method_43470((String)s)));
            this.namespaceTags.addToTag(namespace, info);
            for (Class<? extends class_1297> clazz : EntityUtils.bottomUp(info.getClazz())) {
                String realName = EntityManager.getClassRealName(clazz);
                if (this.classTags.containsTag(realName)) {
                    this.classTags.addToTag(realName, info);
                }
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (clazz2.getSimpleName().contains("Mixin")) continue;
                    String interfazeName = EntityManager.getClassRealName(clazz2);
                    this.interfaceTags.getOrAddTag(interfazeName, s -> new Tag((String)s, null, (class_2561)class_2561.method_43470((String)s)));
                    this.interfaceTags.addToTag(interfazeName, info);
                }
            }
        }
        this.interfaceTags.getRootTags().sort(DevUtils.getClassNameComparator(Tag::getName));
    }

    private void initDefaultTags() {
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.friendly"));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.friendly_terrestrial", this.defaultTags.getTag("tag.biologydictionary.default.friendly")));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.friendly_humanoid", this.defaultTags.getTag("tag.biologydictionary.default.friendly_terrestrial")));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.friendly_aquatic", this.defaultTags.getTag("tag.biologydictionary.default.friendly")));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.friendly_bucketable", this.defaultTags.getTag("tag.biologydictionary.default.friendly_aquatic")));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.friendly_flying", this.defaultTags.getTag("tag.biologydictionary.default.friendly")));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.friendly_neutral", this.defaultTags.getTag("tag.biologydictionary.default.friendly")));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.enemy"));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.enemy_humanoid", this.defaultTags.getTag("tag.biologydictionary.default.enemy")));
        this.defaultTags.addTag(new Tag("tag.biologydictionary.default.enemy_patrol", this.defaultTags.getTag("tag.biologydictionary.default.enemy")));
        ArrayList<EntityClassInfo> friendlyList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> terrestrialList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> humanList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> aquaticList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> bucketableList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> flyingList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> neutralList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> enemyList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> humanoidList = new ArrayList<EntityClassInfo>();
        ArrayList<EntityClassInfo> patrolList = new ArrayList<EntityClassInfo>();
        for (EntityClassInfo info : this.sortedInfos) {
            boolean ratio;
            Class<? extends class_1297> entityClazz = info.getClazz();
            class_243 box = info.getBox();
            boolean bl = ratio = box.method_10214() / box.method_10216() >= 2.0;
            if (class_1569.class.isAssignableFrom(entityClazz)) {
                enemyList.add(info);
                if (ratio) {
                    humanoidList.add(info);
                }
                if (!class_3732.class.isAssignableFrom(entityClazz)) continue;
                patrolList.add(info);
                continue;
            }
            friendlyList.add(info);
            if (ratio) {
                humanList.add(info);
            }
            if (class_5354.class.isAssignableFrom(entityClazz)) {
                neutralList.add(info);
            }
            if (class_1480.class.isAssignableFrom(entityClazz) || class_9866.class.isAssignableFrom(entityClazz)) {
                aquaticList.add(info);
            } else if (class_1432.class.isAssignableFrom(entityClazz) || entityClazz == class_1420.class || entityClazz == class_7298.class) {
                flyingList.add(info);
            } else {
                terrestrialList.add(info);
            }
            if (!class_5761.class.isAssignableFrom(entityClazz)) continue;
            bucketableList.add(info);
        }
        humanList.add(this.getEntityClassInfo(class_1299.field_6147));
        aquaticList.add(this.getEntityClassInfo(class_1299.field_6113));
        aquaticList.add(this.getEntityClassInfo(class_1299.field_28315));
        aquaticList.add(this.getEntityClassInfo(class_1299.field_37419));
        humanList.sort(Comparator.comparingInt(EntityClassInfo::getSortId));
        aquaticList.sort(Comparator.comparingInt(EntityClassInfo::getSortId));
        this.defaultTags.addAllToTag("tag.biologydictionary.default.friendly", friendlyList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.friendly_terrestrial", terrestrialList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.friendly_humanoid", humanList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.friendly_aquatic", aquaticList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.friendly_bucketable", bucketableList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.friendly_flying", flyingList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.friendly_neutral", neutralList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.enemy", enemyList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.enemy_humanoid", humanoidList);
        this.defaultTags.addAllToTag("tag.biologydictionary.default.enemy_patrol", patrolList);
    }

    private EntityTreeNode getOrCreateEntityTreeNode(Class<? extends class_1297> clazz) {
        EntityTreeNode node = this.tree.get(clazz);
        if (node == null) {
            node = new EntityTreeNode(clazz, this.getOrCreateEntityTreeNode(clazz.getSuperclass().asSubclass(class_1297.class)));
            this.tree.put(clazz, node);
        }
        return node;
    }

    public List<TagGroup> getTagGroups() {
        return this.tagGroups;
    }

    public class_1299<?> getEntityType(Class<? extends class_1297> entityClazz) {
        return this.clazzToType.get(entityClazz);
    }

    public EntityClassInfo getEntityClassInfo(class_1299<?> entityType) {
        return this.infos.get(entityType);
    }

    public EntityClassInfo getEntityClassInfo(Class<? extends class_1297> entityClazz) {
        return this.getEntityClassInfo(this.getEntityType(entityClazz));
    }

    public List<EntityClassInfo> getEntityClassInfos() {
        return this.sortedInfos;
    }

    public boolean isVanillaEntity(class_1299<?> entityType) {
        return "minecraft".equals(this.getEntityClassInfo(entityType).getLocation().method_12836());
    }

    public static String getClassRealName(Class<?> clazz) {
        String res = EntityUtils.getDeobfuscatedName(clazz);
        if (res == null) {
            res = clazz.getName();
        }
        return res;
    }

    public void dfsEntityTree(boolean includeRoot, TreeNodeExecutor<EntityTreeNode> executor) {
        this.dfsEntityTree(includeRoot, executor, TreeNodeExecutor.empty());
    }

    public void dfsEntityTree(boolean includeRoot, TreeNodeExecutor<EntityTreeNode> frontExecutor, TreeNodeExecutor<EntityTreeNode> rearExecutor) {
        EntityTreeNode root = this.tree.get(class_1297.class);
        if (includeRoot) {
            this.dfsEntityTreePrivate(root, 0, frontExecutor, rearExecutor);
        } else {
            for (EntityTreeNode son : root.getSons()) {
                this.dfsEntityTreePrivate(son, 1, frontExecutor, rearExecutor);
            }
        }
    }

    private void dfsEntityTreePrivate(EntityTreeNode root, int depth, TreeNodeExecutor<EntityTreeNode> frontExecutor, TreeNodeExecutor<EntityTreeNode> rearExecutor) {
        if (frontExecutor.execute(root, depth)) {
            int d2 = depth + 1;
            for (EntityTreeNode son : root.getSons()) {
                this.dfsEntityTreePrivate(son, d2, frontExecutor, rearExecutor);
            }
        }
        rearExecutor.execute(root, depth);
    }

    public static class TagGroup {
        private final String id;
        private final class_2561 name;
        private final class_2561 description;
        private final Map<String, Tag> tags;
        private final List<Tag> rootTags;

        public TagGroup(String tagGroupName, class_2561 description) {
            this.id = tagGroupName;
            this.name = class_2561.method_43471((String)tagGroupName);
            this.description = description;
            this.tags = new HashMap<String, Tag>();
            this.rootTags = new ArrayList<Tag>();
        }

        public String getId() {
            return this.id;
        }

        public class_2561 getName() {
            return this.name;
        }

        public class_2561 getDescription() {
            return this.description;
        }

        public Collection<Tag> getTags() {
            return this.tags.values();
        }

        public List<Tag> getRootTags() {
            return this.rootTags;
        }

        public boolean containsTag(String tagName) {
            return this.tags.containsKey(tagName);
        }

        public Tag getTag(String tagName) {
            Tag tag = this.tags.getOrDefault(tagName, null);
            if (tag == null) {
                throw new RuntimeException("Tag \"" + tagName + "\" doesn't exist.");
            }
            return tag;
        }

        public Tag getOrAddTag(String tagName, Function<String, Tag> func) {
            return this.tags.computeIfAbsent(tagName, s -> {
                Tag tag = (Tag)func.apply((String)s);
                if (tag.getFather() == null) {
                    this.rootTags.add(tag);
                }
                return tag;
            });
        }

        public void addTag(Tag tag) {
            Tag old = this.tags.put(tag.getName(), tag);
            if (tag.getFather() == null) {
                this.rootTags.add(tag);
            }
            if (old != null) {
                throw new RuntimeException("Tag \"" + tag.getName() + "\" already exists.");
            }
        }

        public void addToTag(String tagName, EntityClassInfo entityClassInfo) {
            Tag tag = this.getTag(tagName);
            tag.addEntity(entityClassInfo);
            entityClassInfo.addTag(tag);
        }

        public void addAllToTag(String tagName, Collection<EntityClassInfo> entityInfos) {
            Tag tag = this.getTag(tagName);
            tag.addEntities(entityInfos);
            entityInfos.forEach(entityInfo -> entityInfo.addTag(tag));
        }

        public void removeFromTag(String tagName, EntityClassInfo entityClassInfo) {
            Tag tag = this.getTag(tagName);
            tag.removeEntity(entityClassInfo);
            entityClassInfo.removeTag(tag);
        }

        public void dfsTags(TreeNodeExecutor<Tag> executor) {
            for (Tag root : this.getRootTags()) {
                this.dfsTagsPrivate(root, 0, executor);
            }
        }

        private void dfsTagsPrivate(Tag root, int depth, TreeNodeExecutor<Tag> executor) {
            if (executor.execute(root, depth)) {
                int d2 = depth + 1;
                root.getSons().forEach(son -> this.dfsTagsPrivate((Tag)son, d2, executor));
            }
        }
    }

    public static class EntityTreeNode {
        private final Class<? extends class_1297> clazz;
        private final EntityTreeNode father;
        private final List<EntityTreeNode> sons;

        public EntityTreeNode() {
            this.clazz = class_1297.class;
            this.father = null;
            this.sons = new ArrayList<EntityTreeNode>();
        }

        public EntityTreeNode(Class<? extends class_1297> entityClazz, EntityTreeNode entityFatherNode) {
            this.clazz = entityClazz;
            this.father = entityFatherNode;
            this.sons = new ArrayList<EntityTreeNode>();
            entityFatherNode.addSon(this);
        }

        public Class<? extends class_1297> getClazz() {
            return this.clazz;
        }

        public String getClazzName() {
            return EntityManager.getClassRealName(this.clazz);
        }

        public EntityTreeNode getFather() {
            return this.father;
        }

        public List<EntityTreeNode> getSons() {
            return this.sons;
        }

        protected void addSon(EntityTreeNode son) {
            this.sons.add(son);
        }

        protected void sortSons() {
            this.sons.sort(Comparator.comparing(EntityTreeNode::getClazzName));
        }

        public String toString() {
            return this.clazz.getSimpleName();
        }
    }

    public static class EntityClassInfo
    implements Comparable<EntityClassInfo> {
        private final class_1299<?> type;
        private final Class<? extends class_1297> clazz;
        private final class_243 box;
        private final List<Tag> tags;
        private int sortId;

        public static Optional<EntityClassInfo> create(class_1299<?> entityType, class_1937 level) {
            Object entity = EntityUtils.create(entityType, level);
            if (entity == null) {
                if (entityType == class_1299.field_6097) {
                    return Optional.empty();
                }
                if (!entityType.method_45382(level.method_45162())) {
                    return Optional.empty();
                }
                String name = class_1299.method_5890(entityType).toString();
                throw new NullPointerException("Failed to create \"" + name + "\".");
            }
            if (!(entity instanceof class_1309)) {
                return Optional.empty();
            }
            return Optional.of(new EntityClassInfo(entityType, (class_1297)entity));
        }

        private EntityClassInfo(class_1299<?> entityType, class_1297 entity) {
            this.type = entityType;
            this.clazz = entity.getClass();
            class_238 b = entity.method_5829();
            this.box = new class_243(b.method_17939(), b.method_17940(), b.method_17941());
            this.tags = new ArrayList<Tag>();
        }

        public class_1299<?> getType() {
            return this.type;
        }

        public Class<? extends class_1297> getClazz() {
            return this.clazz;
        }

        public class_243 getBox() {
            return this.box;
        }

        public class_2960 getLocation() {
            return class_1299.method_5890(this.getType());
        }

        public String getStringId() {
            return this.getLocation().toString();
        }

        public List<Tag> getTags() {
            return this.tags;
        }

        protected void addTag(Tag tag) {
            this.tags.add(tag);
        }

        protected void removeTag(Tag tag) {
            this.tags.remove(tag);
        }

        public int getSortId() {
            return this.sortId;
        }

        public void setSortId(int sortId) {
            this.sortId = sortId;
        }

        public String toString() {
            return this.type.toString();
        }

        @Override
        public int compareTo(EntityClassInfo o) {
            return this.sortId - o.sortId;
        }
    }

    public static class Tag
    implements Comparable<Tag> {
        private final String name;
        private final class_2561 text;
        private final class_2561 description;
        private final List<EntityClassInfo> entities;
        private final Tag father;
        private final List<Tag> sons;

        public Tag(String name) {
            this(name, null);
        }

        public Tag(String tagName, Tag fatherTag) {
            this(tagName, fatherTag, null);
        }

        public Tag(String tagName, Tag fatherTag, class_2561 description) {
            this.name = tagName;
            this.text = class_2561.method_43471((String)tagName);
            this.description = description;
            this.entities = new ArrayList<EntityClassInfo>();
            this.father = fatherTag;
            if (this.father != null) {
                this.father.addSon(this);
            }
            this.sons = new ArrayList<Tag>();
        }

        public String getName() {
            return this.name;
        }

        public class_2561 getText() {
            return this.text;
        }

        public class_2561 getDescription() {
            return this.description;
        }

        public List<EntityClassInfo> getEntities() {
            return this.entities;
        }

        protected void addEntity(EntityClassInfo info) {
            this.entities.add(info);
        }

        protected void addEntities(Collection<EntityClassInfo> infoList) {
            this.entities.addAll(infoList);
        }

        protected void removeEntity(EntityClassInfo info) {
            this.entities.remove(info);
        }

        public Tag getFather() {
            return this.father;
        }

        public void addSon(Tag tag) {
            this.sons.add(tag);
        }

        public List<Tag> getSons() {
            return this.sons;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Tag o) {
            String s1 = this.getName().substring(this.getName().lastIndexOf(46) + 1);
            String s2 = o.getName().substring(o.getName().lastIndexOf(46) + 1);
            return s1.compareTo(s2);
        }
    }

    @FunctionalInterface
    public static interface TreeNodeExecutor<E> {
        public static <E> TreeNodeExecutor<E> empty() {
            return (cur, depth) -> true;
        }

        public boolean execute(E var1, int var2);
    }
}

