/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.property;

import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.core.property.EntityProperty;
import io.github.xienaoban.biologydictionary.core.property.ExtraEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.bundle.EntityInventoryPropertyBundle;
import io.github.xienaoban.biologydictionary.core.property.bundle.EntityVariantPropertyBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2487;

public final class EntityProperties<E extends class_1297> {
    private final E entity;
    private final Map<String, EntityProperty<?>> vanillaProperties;
    private final Map<Class<? extends EntityProperty>, EntityProperty<?>> extraProperties;
    private int noUpdateCooldown = 0;
    private E model;

    public static void init() {
        VanillaEntityProperties.init();
        ExtraEntityProperties.init();
        EntityVariantPropertyBundle.init();
        EntityInventoryPropertyBundle.init();
    }

    public EntityProperties(E entity) {
        this.entity = entity;
        Map<Class<? extends class_1297>, VanillaEntityProperties.Creator> vReg = VanillaEntityProperties.registry;
        Map<Class<class_1297>, List<EntityProperty.Factory<?>>> eReg = ExtraEntityProperties.registry;
        HashMap vMap = new HashMap();
        HashMap eMap = new HashMap();
        for (Class<? extends class_1297> clazz : EntityUtils.topDown(entity)) {
            VanillaEntityProperties.Creator vc = vReg.getOrDefault(clazz, null);
            if (vc != null) {
                vc.create(vMap);
            }
            for (EntityProperty.Factory ec : eReg.getOrDefault(clazz, Collections.emptyList())) {
                EntityProperty p = ec.create();
                eMap.put(p.getClass(), p);
            }
        }
        this.vanillaProperties = Collections.unmodifiableMap(vMap);
        this.extraProperties = Collections.unmodifiableMap(eMap);
        this.model = null;
    }

    public E entity() {
        return this.entity;
    }

    public E getModel() {
        return this.model;
    }

    public void setModel(E model) {
        this.model = model;
    }

    public boolean isInNoUpdateCooldown() {
        return this.noUpdateCooldown > 0;
    }

    public boolean isNotInNoUpdateCooldown() {
        return this.noUpdateCooldown <= 0;
    }

    public void setNoUpdateCooldown() {
        this.setNoUpdateCooldown(10);
    }

    public void setNoUpdateCooldown(int noUpdateCooldown) {
        this.noUpdateCooldown = noUpdateCooldown;
    }

    public void tickNoUpdateCooldown() {
        if (this.noUpdateCooldown > 0) {
            --this.noUpdateCooldown;
        }
    }

    public <EP extends EntityProperty<?>> EP getVanilla(String key) {
        return (EP)((EntityProperty)Misc.cast(this.vanillaProperties.getOrDefault(key, null)));
    }

    public <EP extends EntityProperty<?>> EP getExtra(Class<? extends EntityProperty> key) {
        return (EP)((EntityProperty)Misc.cast(this.extraProperties.getOrDefault(key, null)));
    }

    public Collection<EntityProperty<?>> getVanillas() {
        return this.vanillaProperties.values();
    }

    public Collection<EntityProperty<?>> getExtras() {
        return this.extraProperties.values();
    }

    public void update(class_2487 vanillaNbt, class_2487 extraNbt) {
        for (EntityProperty<?> property : this.vanillaProperties.values()) {
            property.readFrom(vanillaNbt);
        }
        for (EntityProperty<?> property : this.extraProperties.values()) {
            property.readFrom(extraNbt);
        }
    }
}

