/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.property.bundle;

import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;

public final class Bundle<H> {
    private final List<Function<class_1297, H>> patterns = new ArrayList<Function<class_1297, H>>();
    private final Map<class_1299<?>, List<H>> cache = new ConcurrentHashMap();

    void register(Function<class_1297, H> pattern) {
        this.patterns.add(pattern);
    }

    @SafeVarargs
    final void register(class_1299<?> entityType, H ... handlers) {
        this.cache.computeIfAbsent(entityType, ignored -> new ArrayList()).addAll(Arrays.asList(handlers));
    }

    List<H> getHandlers(class_1297 entity) {
        return this.cache.computeIfAbsent(EntityUtils.getEntityType(entity), ignored -> {
            ArrayList<H> res = new ArrayList<H>();
            for (Function<class_1297, H> pattern : this.patterns) {
                H handler = pattern.apply(entity);
                if (handler == null) continue;
                res.add(handler);
            }
            return res;
        });
    }
}

