/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.property.bundle;

import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.core.property.bundle.Bundle;
import io.github.xienaoban.biologydictionary.mixin.AbstractHorseMixin;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_6067;

public final class EntityInventoryPropertyBundle {
    public static final Function<class_1297, InventoryHandler<?>> PLAYER_PATTERN = entity -> {
        if (entity instanceof class_1657) {
            return e -> ((class_1657)e).method_31548();
        }
        return null;
    };
    public static final Function<class_1297, InventoryHandler<?>> CARRIER_PATTERN = entity -> {
        if (entity instanceof class_6067) {
            return e -> ((class_6067)e).method_35199();
        }
        return null;
    };
    public static final Function<class_1297, InventoryHandler<?>> ABSTRACT_HORSE_PATTERN = entity -> {
        if (entity instanceof class_1496) {
            return e -> ((AbstractHorseMixin)e).getInventory();
        }
        return null;
    };
    private static final Bundle<InventoryHandler<?>> BUNDLE = new Bundle();

    public static void init() {
        EntityInventoryPropertyBundle.register(PLAYER_PATTERN);
        EntityInventoryPropertyBundle.register(CARRIER_PATTERN);
        EntityInventoryPropertyBundle.register(ABSTRACT_HORSE_PATTERN);
    }

    public static void register(Function<class_1297, InventoryHandler<?>> pattern) {
        BUNDLE.register(pattern);
    }

    public static <E extends class_1297> InventoryHandler<E> getHandler(E entity) {
        List list = (List)Misc.cast(BUNDLE.getHandlers(entity));
        if (list.isEmpty()) {
            return null;
        }
        return (InventoryHandler)list.getFirst();
    }

    public static <E extends class_1297> class_1263 getContainer(E entity) {
        InventoryHandler<E> handler = EntityInventoryPropertyBundle.getHandler(entity);
        if (handler == null) {
            return null;
        }
        return handler.getContainer(entity);
    }

    public static <E extends class_1297> class_1263 getContainerOrEmpty(E entity) {
        class_1263 container = EntityInventoryPropertyBundle.getContainer(entity);
        if (container == null) {
            return new class_1277(0);
        }
        return container;
    }

    public static interface InventoryHandler<E extends class_1297> {
        public class_1263 getContainer(E var1);
    }
}

