/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.property.bundle;

import com.mojang.serialization.Codec;
import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.AbstractProperty;
import io.github.xienaoban.biologydictionary.core.property.builtin.CodecProperty;
import io.github.xienaoban.biologydictionary.core.property.bundle.Bundle;
import io.github.xienaoban.biologydictionary.core.property.vanilla.VariantProperty;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1440;
import net.minecraft.class_1498;
import net.minecraft.class_1646;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3854;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class EntityVariantPropertyBundle {
    private static final Bundle<VariantHandler<?, ?>> BUNDLE = new Bundle();
    static final Function<class_1297, VariantHandler<?, ?>> STANDARD_PATTERN = entity -> {
        Class<?> entityClass = entity.getClass();
        if (!EntityUtils.isVanillaEntity(entityClass)) {
            return null;
        }
        String fullName = EntityUtils.getDeobfuscatedName(entity.getClass());
        String simpleName = fullName.substring(fullName.lastIndexOf(46) + 1);
        for (String variantType : new String[]{"Variant", "Type"}) {
            try {
                AbstractProperty property;
                Class<?> ofEntity = Class.forName(VanillaEntityProperties.class.getName() + "$Of" + simpleName);
                Method creator = ofEntity.getDeclaredMethod("create" + variantType + "Property", new Class[0]);
                if (VariantProperty.class.isAssignableFrom(creator.getReturnType())) {
                    property = (VariantProperty)creator.invoke(null, new Object[0]);
                    class_5321 key = ((VariantProperty)property).getResourceKey();
                    Optional optional = entity.method_56673().method_46759(key);
                    if (!optional.isPresent()) continue;
                    class_2378 registry = (class_2378)optional.get();
                    List<class_6880<Object>> variants = registry.method_42021().stream().map(arg_0 -> ((class_2378)registry).method_46747(arg_0)).map(k -> k).toList();
                    return new StandardVariantHandler(key, variants);
                }
                if (!CodecProperty.class.isAssignableFrom(creator.getReturnType()) || !((CodecProperty)(property = (CodecProperty)creator.invoke(null, new Object[0]))).getClazz().isEnum()) continue;
                return new CodecVariantHandler((CodecProperty<? extends class_1297, ? extends Enum<?>>)property);
            }
            catch (Exception e) {
                BiologyDictionary.LOGGER.debug("Entity `{}` has no variant: {}", (Object)entity.method_5864().toString(), (Object)e.toString());
            }
        }
        return null;
    };

    public static void init() {
        EntityVariantPropertyBundle.register(STANDARD_PATTERN);
        EntityVariantPropertyBundle.register(class_1299.field_6077, new VillagerTypeHandler());
        EntityVariantPropertyBundle.register(class_1299.field_6139, new HorseVariantHandler(), new HorseMarkingsHandler());
        EntityVariantPropertyBundle.register(class_1299.field_6146, new PandaMainGeneHandler(), new PandaHiddenGeneHandler());
        EntityVariantPropertyBundle.register(class_1299.field_17714, new CodecVariantHandler(VanillaEntityProperties.OfLlama.createVariantProperty()));
    }

    public static void register(Function<class_1297, VariantHandler<?, ?>> pattern) {
        BUNDLE.register(pattern);
    }

    public static void register(class_1299<?> entityType, VariantHandler<?, ?> ... variantHandlers) {
        BUNDLE.register(entityType, variantHandlers);
    }

    public static <E extends class_1297, V> List<VariantHandler<E, V>> getHandlers(E entity) {
        return (List)Misc.cast(BUNDLE.getHandlers(entity));
    }

    public static interface VariantHandler<E extends class_1297, V> {
        default public boolean isStandard() {
            return true;
        }

        public List<V> getVariants();

        public V getVariant(E var1);

        public void setVariant(E var1, V var2);

        public class_2520 variantToNbt(V var1);

        public V nbtToVariant(class_2520 var1);

        public String getVariantName(V var1);
    }

    public static final class VillagerTypeHandler
    implements VariantHandler<class_1646, class_6880<class_3854>> {
        @Override
        public boolean isStandard() {
            return false;
        }

        @Override
        public List<class_6880<class_3854>> getVariants() {
            return class_7923.field_41194.method_42017().map(ref -> ref).toList();
        }

        @Override
        public class_6880<class_3854> getVariant(class_1646 entity) {
            return entity.method_7231().comp_3520();
        }

        @Override
        public void setVariant(class_1646 entity, class_6880<class_3854> variant) {
            entity.method_7195(entity.method_7231().method_16922(variant));
        }

        @Override
        public class_2520 variantToNbt(class_6880<class_3854> variant) {
            return new VariantProperty(class_7924.field_41235).withVal(variant).toTag();
        }

        @Override
        public class_6880<class_3854> nbtToVariant(class_2520 nbt) {
            return (class_6880)new VariantProperty(class_7924.field_41235).withTag((class_2487)nbt).getVal();
        }

        @Override
        public String getVariantName(class_6880<class_3854> variant) {
            return variant.method_40230().map(resourceKey -> {
                class_2960 id = resourceKey.method_29177();
                Object res = "minecraft".equals(id.method_12836()) ? id.method_12832() : id.method_12836() + "." + id.method_12832();
                return res;
            }).orElse("unknown");
        }
    }

    public static final class HorseVariantHandler
    implements VariantHandler<class_1498, class_5149> {
        @Override
        public List<class_5149> getVariants() {
            return Arrays.asList(class_5149.values());
        }

        @Override
        public class_5149 getVariant(class_1498 entity) {
            return entity.method_27077();
        }

        @Override
        public void setVariant(class_1498 entity, class_5149 variant) {
            EntityUtils.setVariantAndMarkings(entity, variant, entity.method_27078());
        }

        @Override
        public class_2520 variantToNbt(class_5149 variant) {
            return class_2497.method_23247((int)variant.method_27082());
        }

        @Override
        public class_5149 nbtToVariant(class_2520 nbt) {
            return class_5149.method_27083((int)nbt.method_68602().orElse(0));
        }

        @Override
        public String getVariantName(class_5149 variant) {
            return variant.method_15434();
        }
    }

    public static final class HorseMarkingsHandler
    implements VariantHandler<class_1498, class_5148> {
        @Override
        public List<class_5148> getVariants() {
            return Arrays.asList(class_5148.values());
        }

        @Override
        public class_5148 getVariant(class_1498 entity) {
            return entity.method_27078();
        }

        @Override
        public void setVariant(class_1498 entity, class_5148 variant) {
            EntityUtils.setVariantAndMarkings(entity, entity.method_27077(), variant);
        }

        @Override
        public class_2520 variantToNbt(class_5148 variant) {
            return class_2497.method_23247((int)variant.method_27079());
        }

        @Override
        public class_5148 nbtToVariant(class_2520 nbt) {
            return class_5148.method_27080((int)nbt.method_68602().orElse(0));
        }

        @Override
        public String getVariantName(class_5148 variant) {
            return "markings." + variant.name().toLowerCase();
        }
    }

    public static sealed class PandaMainGeneHandler
    implements VariantHandler<class_1440, class_1440.class_1443>
    permits PandaHiddenGeneHandler {
        @Override
        public boolean isStandard() {
            return false;
        }

        @Override
        public List<class_1440.class_1443> getVariants() {
            return Arrays.asList(class_1440.class_1443.values());
        }

        @Override
        public class_1440.class_1443 getVariant(class_1440 entity) {
            return entity.method_6525();
        }

        @Override
        public void setVariant(class_1440 entity, class_1440.class_1443 variant) {
            entity.method_6529(variant);
        }

        @Override
        public class_2520 variantToNbt(class_1440.class_1443 variant) {
            return VanillaEntityProperties.OfPanda.createMainGeneProperty().withVal(variant).toTag();
        }

        @Override
        public class_1440.class_1443 nbtToVariant(class_2520 nbt) {
            return (class_1440.class_1443)VanillaEntityProperties.OfPanda.createMainGeneProperty().withTag((class_2487)nbt).getVal();
        }

        @Override
        public String getVariantName(class_1440.class_1443 variant) {
            return variant.method_15434();
        }
    }

    public static final class PandaHiddenGeneHandler
    extends PandaMainGeneHandler {
        @Override
        public class_1440.class_1443 getVariant(class_1440 entity) {
            return entity.method_6508();
        }

        @Override
        public void setVariant(class_1440 entity, class_1440.class_1443 variant) {
            entity.method_6547(variant);
        }

        @Override
        public class_2520 variantToNbt(class_1440.class_1443 variant) {
            return VanillaEntityProperties.OfPanda.createHiddenGeneProperty().withVal(variant).toTag();
        }

        @Override
        public class_1440.class_1443 nbtToVariant(class_2520 nbt) {
            return (class_1440.class_1443)VanillaEntityProperties.OfPanda.createHiddenGeneProperty().withTag((class_2487)nbt).getVal();
        }
    }

    public record CodecVariantHandler(String propertyName, Class<Enum<?>> variantClazz, Codec<Enum<?>> codec) implements PropertyVariantHandler<class_1297, Enum<?>>
    {
        public CodecVariantHandler(CodecProperty<? extends class_1297, ? extends Enum<?>> property) {
            this(property.name(), (Class)Misc.cast(property.getClazz()), (Codec)Misc.cast(property.getCodec()));
        }

        @Override
        public AbstractProperty<? super class_1297, Enum<?>> createProperty() {
            return new CodecProperty(this.propertyName, this.variantClazz, this.codec);
        }

        @Override
        public List<Enum<?>> getVariants() {
            return Arrays.asList(this.variantClazz.getEnumConstants());
        }

        @Override
        public String getVariantName(Enum<?> variant) {
            if (variant instanceof class_3542) {
                class_3542 sr = (class_3542)variant;
                return sr.method_15434();
            }
            return variant.name().toLowerCase();
        }
    }

    public record StandardVariantHandler(class_5321<class_2378<Object>> key, List<class_6880<Object>> variants) implements PropertyVariantHandler<class_1297, class_6880<Object>>
    {
        @Override
        public AbstractProperty<class_1297, class_6880<Object>> createProperty() {
            return new VariantProperty<class_1297, Object>(this.key);
        }

        @Override
        public List<class_6880<Object>> getVariants() {
            return this.variants;
        }

        @Override
        public String getVariantName(class_6880<Object> variant) {
            return variant.method_40230().map(resourceKey -> {
                class_2960 id = resourceKey.method_29177();
                Object res = "minecraft".equals(id.method_12836()) ? id.method_12832() : id.method_12836() + "." + id.method_12832();
                return res;
            }).orElse("unknown");
        }
    }

    public static interface PropertyVariantHandler<E extends class_1297, V>
    extends VariantHandler<E, V> {
        public AbstractProperty<? super E, V> createProperty();

        @Override
        default public V getVariant(E entity) {
            return this.createProperty().withEntity(entity).getVal();
        }

        @Override
        default public void setVariant(E entity, V variant) {
            this.createProperty().withVal(variant).setTo(entity);
        }

        @Override
        default public class_2520 variantToNbt(V variant) {
            return this.createProperty().withVal(variant).toTag();
        }

        @Override
        default public V nbtToVariant(class_2520 nbt) {
            return this.createProperty().withTag((class_2487)nbt).getVal();
        }
    }
}

