/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.property.extra;

import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperty;
import io.github.xienaoban.biologydictionary.core.property.vanilla.ItemStackListProperty;
import io.github.xienaoban.biologydictionary.mixin.TemptGoalIMixin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_1391;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public final class MobTemptProperty
extends ItemStackListProperty<class_1308> {
    public static final EntityProperty.Factory<class_1308> FACTORY = MobTemptProperty::new;

    public MobTemptProperty() {
        super(MobTemptProperty.class.getSimpleName());
    }

    @Override
    public void getFrom(class_1308 entity) {
        List<Predicate<class_1799>> predicates = MobTemptProperty.getPredicates(entity);
        if (predicates.isEmpty()) {
            this.setVal(Collections.emptyList());
        } else {
            ArrayList<class_1799> res = new ArrayList<class_1799>();
            block0: for (class_1792 item : class_7923.field_41178) {
                class_1799 itemStack = new class_1799((class_1935)item);
                for (Predicate<class_1799> predicate : predicates) {
                    if (!predicate.test(itemStack)) continue;
                    res.add(itemStack);
                    continue block0;
                }
            }
            res.sort(Comparator.comparingInt(o -> class_7923.field_41178.method_10206((Object)o.method_7909())));
            this.setVal(res);
        }
    }

    @Override
    public void setTo(class_1308 entity) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static List<Predicate<class_1799>> getPredicates(class_1308 entity) {
        ArrayList<Predicate<class_1799>> predicates = new ArrayList<Predicate<class_1799>>();
        for (class_1391 temptGoal : EntityUtils.getGoals(entity, class_1391.class)) {
            Predicate<class_1799> items = ((TemptGoalIMixin)temptGoal).getItems();
            predicates.add(items);
        }
        return predicates;
    }
}

