/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.skill;

import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.InventoryUtils;
import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.config.ConfigsManager;
import io.github.xienaoban.biologydictionary.core.skill.NoPermissionException;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_4135;

public final class Permissions {
    public static void checkSkillNotBanned(String skillClassName) {
        if (ConfigsManager.getServer().getBannedPlayerSkills().contains(skillClassName)) {
            throw new NoPermissionException(class_2561.method_43469((String)"text.biologydictionary.skill_banned", (Object[])new Object[]{skillClassName}), "Skill is banned by server config: " + skillClassName);
        }
    }

    public static <T> void checkLegalArg(T actual, T expect) {
        if (!Objects.equals(actual, expect)) {
            throw new IllegalArgumentException("Bad arg: expect={" + String.valueOf(expect) + "}, actual={" + String.valueOf(actual) + "}");
        }
    }

    public static void checkPlayerCreative(class_1657 player) {
        if (PlayerUtils.isCreative(player)) {
            return;
        }
        throw new NoPermissionException(class_2561.method_43471((String)"text.biologydictionary.only_in_creative_mode"), "Not in creative mode");
    }

    public static void checkPlayerCreativeOrExperiencePoints(class_1657 player, int experience) {
        if (PlayerUtils.isCreative(player)) {
            return;
        }
        int exp = PlayerUtils.getExperiencePoints(player);
        if (exp >= experience) {
            return;
        }
        throw new NoPermissionException(class_2561.method_43469((String)"text.biologydictionary.not_enough_experience_points", (Object[])new Object[]{experience}), "No enough experience points: " + exp + " < " + experience);
    }

    public static void checkPlayerCreativeOrExperienceLevel(class_1657 player, int level) {
        if (PlayerUtils.isCreative(player)) {
            return;
        }
        int lvl = PlayerUtils.getExperienceLevels(player);
        if (lvl >= level) {
            return;
        }
        throw new NoPermissionException(class_2561.method_43469((String)"text.biologydictionary.not_enough_experience_levels", (Object[])new Object[]{level}), "No enough experience levels: " + lvl + " < " + level);
    }

    public static void checkTargetPlayerLowerGameMode(class_1657 player, class_1657 target) {
        if (Objects.equals(player, target)) {
            return;
        }
        boolean sourceMode = PlayerUtils.isCreative(player);
        boolean targetMode = PlayerUtils.isCreative(target);
        if (targetMode || !sourceMode) {
            throw new NoPermissionException(class_2561.method_43471((String)"text.biologydictionary.no_permission_to_modify_this_player"), "No permission to modify this player's data: source_mode=\"" + PlayerUtils.gameMode(player).method_8381() + "\", target_mode=\"" + PlayerUtils.gameMode(target).method_8381() + "\"");
        }
    }

    public static void checkPlayerInventoryItems(class_1657 player, class_1799 itemStack) {
        if (!InventoryUtils.hasEnoughItems(PlayerUtils.getInventory(player), itemStack)) {
            throw new NoPermissionException(class_2561.method_43469((String)"text.biologydictionary.not_enough_items", (Object[])new Object[]{itemStack.method_7947(), itemStack.method_7909().method_63680()}), "Not enough items in inventory: item=\"" + String.valueOf(itemStack.method_7909()) + "\"");
        }
    }

    public static void checkPlayerCreativeOrInventoryItems(class_1657 player, class_1799 itemStack) {
        if (PlayerUtils.isCreative(player)) {
            return;
        }
        Permissions.checkPlayerInventoryItems(player, itemStack);
    }

    public static void checkConsumePlayerInventoryItems(class_1657 player, class_1799 itemStack) {
        if (!InventoryUtils.consumeItems(PlayerUtils.getInventory(player), itemStack)) {
            throw new NoPermissionException(class_2561.method_43469((String)"text.biologydictionary.not_enough_items", (Object[])new Object[]{itemStack.method_7947(), itemStack.method_7909().method_63680()}), "Not enough items in inventory: item=\"" + String.valueOf(itemStack.method_7909()) + "\"");
        }
    }

    public static void checkPlayerCreativeOrConsumeInventoryItems(class_1657 player, class_1799 itemStack) {
        if (PlayerUtils.isCreative(player)) {
            return;
        }
        Permissions.checkConsumePlayerInventoryItems(player, itemStack);
    }

    public static void checkTargetPlayerLowerGameMode(class_1657 player, class_1297 maybePlayer) {
        if (maybePlayer instanceof class_1657) {
            class_1657 target = (class_1657)maybePlayer;
            Permissions.checkTargetPlayerLowerGameMode(player, target);
        }
    }

    public static void checkMobHasGoalAndStart(class_1308 entity, Class<? extends class_1352> goalClass) {
        class_4135 goal = EntityUtils.getWrappedGoal(entity, goalClass);
        if (goal == null) {
            throw new NoPermissionException(class_2561.method_43469((String)"text.biologydictionary.target_entity_no_ability", (Object[])new Object[]{goalClass.getSimpleName()}), "There's no goal \"" + String.valueOf(goalClass) + "\" in entity \"" + String.valueOf(entity) + "\"");
        }
        goal.method_6269();
    }
}

