/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.skill;

import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.BiologyDictionaryClient;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.core.skill.EntityTargetedSkill;
import io.github.xienaoban.biologydictionary.core.skill.GeneralSkill;
import io.github.xienaoban.biologydictionary.core.skill.NoPermissionException;
import io.github.xienaoban.biologydictionary.core.skill.entity.AgeableMobSetForcedAgeSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.BeeClearHiveSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntityGiftPetSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntitySetInvulnerableSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntitySetPortalCooldownSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntitySetSoundSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntitySetVariantSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.LivingEntityStealInventorySkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.MobForcePersistentSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.MobSetNoAiSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.SheepForceEatGrassSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.VillagerForceRestockSkill;
import io.github.xienaoban.biologydictionary.core.skill.entity.WanderingTraderRetainSkill;
import io.github.xienaoban.biologydictionary.core.skill.general.GetSpawnEggSkill;
import io.github.xienaoban.biologydictionary.core.skill.general.HighlightEntitiesSkill;
import io.github.xienaoban.biologydictionary.net.ClientNetManager;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public final class PlayerSkills {
    private static final Map<String, GeneralSkill> commonSkills = new HashMap<String, GeneralSkill>();
    private static final Map<String, EntityTargetedSkill<?>> entityTargetedSkills = new HashMap();

    public static void registerBuiltIn(Registrar registrar) {
        registrar.register(new HighlightEntitiesSkill());
        registrar.register(new GetSpawnEggSkill());
        registrar.register(new EntitySetVariantSkill());
        registrar.register(new EntitySetInvulnerableSkill());
        registrar.register(new EntitySetSoundSkill());
        registrar.register(new EntitySetPortalCooldownSkill());
        registrar.register(new MobSetNoAiSkill());
        registrar.register(new MobForcePersistentSkill());
        registrar.register(new LivingEntityStealInventorySkill());
        registrar.register(new SheepForceEatGrassSkill());
        registrar.register(new AgeableMobSetForcedAgeSkill());
        registrar.register(new BeeClearHiveSkill());
        registrar.register(new EntityGiftPetSkill());
        registrar.register(new VillagerForceRestockSkill());
        registrar.register(new WanderingTraderRetainSkill());
    }

    public static void init() {
        Registrar registrar = new Registrar(){

            @Override
            public void register(GeneralSkill skill) {
                PlayerSkills.register0(skill);
            }

            @Override
            public void register(EntityTargetedSkill<?> skill) {
                PlayerSkills.register0(skill);
            }
        };
        PlayerSkills.registerBuiltIn(registrar);
    }

    private static void register0(GeneralSkill skill) {
        if (commonSkills.putIfAbsent(PlayerSkills.key(skill), skill) != null) {
            throw new RuntimeException("Duplicate skill registered: " + PlayerSkills.key(skill));
        }
    }

    private static void register0(EntityTargetedSkill<?> skill) {
        if (entityTargetedSkills.putIfAbsent(PlayerSkills.key(skill), skill) != null) {
            throw new RuntimeException("Duplicate skill registered: " + PlayerSkills.key(skill));
        }
    }

    public static GeneralSkill getCommonSkill(String key) {
        GeneralSkill res = commonSkills.get(key);
        if (res == null) {
            throw new RuntimeException("No such key: " + key);
        }
        return res;
    }

    public static EntityTargetedSkill<? extends class_1297> getEntityTargetedSkill(String key) {
        EntityTargetedSkill<?> res = entityTargetedSkills.get(key);
        if (res == null) {
            throw new RuntimeException("No such key: " + key);
        }
        return res;
    }

    public static String key(Object skill) {
        return skill.getClass().getName();
    }

    public static String key(Class<?> skillClass) {
        return skillClass.getName();
    }

    public static void giveExperiencePointsIfNotCreative(class_3222 player, int experience) {
        if (PlayerUtils.isCreative((class_1657)player)) {
            return;
        }
        PlayerUtils.giveExperiencePoints((class_1657)player, experience);
        PlayerUtils.playLocalSound((class_1657)player, class_3417.field_14627, 0.5f, 0.01f);
    }

    public static void giveExperienceLevelsIfNotCreative(class_3222 player, int experience) {
        if (PlayerUtils.isCreative((class_1657)player)) {
            return;
        }
        PlayerUtils.giveExperienceLevels((class_1657)player, experience);
        PlayerUtils.playLocalSound((class_1657)player, class_3417.field_14627, 0.5f, 0.01f);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean sendCommonSkill(Object ... args) {
        try {
            String skillKey = StackWalker.getInstance().walk(stream -> ((StackWalker.StackFrame)stream.skip(1L).findFirst().orElseThrow()).getClassName());
            GeneralSkill skill = PlayerSkills.getCommonSkill(skillKey);
            class_2520 nbtArgs = skill.clientSend(ClientUtils.getClientPlayer(), args);
            ClientNetManager.sendCommonSkill(skillKey, nbtArgs);
            return true;
        }
        catch (NoPermissionException e) {
            BiologyDictionaryClient.sendCenteredWarning(e.getGameMessage());
        }
        catch (Exception e) {
            BiologyDictionary.LOGGER.warn(Misc.getStackToString(e));
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean sendEntityTargetedSkill(class_1297 entity, Object ... args) {
        try {
            String skillKey = StackWalker.getInstance().walk(stream -> ((StackWalker.StackFrame)stream.skip(1L).findFirst().orElseThrow()).getClassName());
            EntityTargetedSkill<? extends class_1297> skill = PlayerSkills.getEntityTargetedSkill(skillKey);
            class_2520 nbtArgs = skill.clientSend(ClientUtils.getClientPlayer(), (class_1297)((class_1297)Misc.cast(entity)), args);
            ClientNetManager.sendEntityTargetedSkill(skillKey, entity, nbtArgs);
            return true;
        }
        catch (NoPermissionException e) {
            BiologyDictionaryClient.sendCenteredWarning(e.getGameMessage());
        }
        catch (Exception e) {
            BiologyDictionary.LOGGER.warn(Misc.getStackToString(e));
        }
        return false;
    }

    public static interface Registrar {
        public void register(GeneralSkill var1);

        public void register(EntityTargetedSkill<?> var1);
    }
}

