/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.skill.entity;

import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.skill.EntityTargetedSkill;
import io.github.xienaoban.biologydictionary.core.skill.NoPermissionException;
import io.github.xienaoban.biologydictionary.core.skill.PlayerSkills;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_2481;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class MobForcePersistentSkill
implements EntityTargetedSkill<class_1308> {
    private static void check(class_1308 entity, boolean newPersistenceValue) {
        if (entity.method_16914() && !newPersistenceValue) {
            throw new NoPermissionException(class_2561.method_43471((String)"text.biologydictionary.custom_name_force_persistent"), "Entities with custom name should be forced persistent");
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean activate(class_1308 entity, boolean persistent) {
        return PlayerSkills.sendEntityTargetedSkill((class_1297)entity, persistent);
    }

    @Override
    public class_2520 clientSend(class_746 player, class_1308 entity, Object ... args) {
        boolean persistent = (Boolean)args[0];
        MobForcePersistentSkill.check(entity, persistent);
        return class_2481.method_23234((boolean)persistent);
    }

    @Override
    public void serverReceive(MinecraftServer server, class_3222 player, class_1308 entity, class_2520 args) {
        boolean persistent = (Boolean)args.method_68606().orElseThrow();
        MobForcePersistentSkill.check(entity, persistent);
        VanillaEntityProperties.OfMob.createPersistenceRequiredProperty().withVal(persistent).setTo(entity);
    }
}

