/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.skill.entity;

import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.skill.EntityTargetedSkill;
import io.github.xienaoban.biologydictionary.core.skill.Permissions;
import io.github.xienaoban.biologydictionary.core.skill.PlayerSkills;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5354;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class MobSetNoAiSkill
implements EntityTargetedSkill<class_1308> {
    private static final int FRIENDLY_EXP_LVL_REQUIRED = 0;
    private static final int FRIENDLY_EXP_LVL_COST = 1;
    private static final int NEUTRAL_EXP_LVL_REQUIRED = 10;
    private static final int NEUTRAL_EXP_LVL_COST = 3;
    private static final int ENEMY_EXP_LVL_REQUIRED = 20;
    private static final int ENEMY_EXP_LVL_COST_MIN = 5;
    private static final float ENEMY_EXP_LVL_COST_FACTOR = 0.25f;

    public static int experienceLevelsRequired(class_1308 entity) {
        if (entity instanceof class_1569) {
            return 20;
        }
        if (entity instanceof class_5354) {
            return 10;
        }
        return 0;
    }

    public static int experienceLevelsCost(class_1308 entity) {
        if (entity instanceof class_1569) {
            return Math.max(5, (int)(0.25f * entity.method_6063()));
        }
        if (entity instanceof class_5354) {
            return 3;
        }
        return 1;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean activate(class_1308 entity, boolean noAi) {
        return PlayerSkills.sendEntityTargetedSkill((class_1297)entity, noAi);
    }

    private static void check(class_1657 player, class_1308 entity) {
        int lvlRequired = MobSetNoAiSkill.experienceLevelsRequired(entity);
        int lvlCost = MobSetNoAiSkill.experienceLevelsCost(entity);
        Permissions.checkPlayerCreativeOrExperienceLevel(player, Math.max(lvlRequired, lvlCost));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2520 clientSend(class_746 player, class_1308 entity, Object ... args) {
        boolean noAi = (Boolean)args[0];
        MobSetNoAiSkill.check((class_1657)player, entity);
        return class_2481.method_23234((boolean)noAi);
    }

    @Override
    public void serverReceive(MinecraftServer server, class_3222 player, class_1308 entity, class_2520 args) {
        boolean noAi = (Boolean)args.method_68606().orElseThrow();
        MobSetNoAiSkill.check((class_1657)player, entity);
        class_2487 nbt = VanillaEntityProperties.OfMob.createNoAiProperty().withVal(noAi).toTag();
        if (noAi) {
            VanillaEntityProperties.OfMob.createPersistenceRequiredProperty().withVal(true).writeTo(nbt);
        } else {
            VanillaEntityProperties.OfEntity.createMotionProperty().withVal(class_243.field_1353).writeTo(nbt);
        }
        if (!PlayerUtils.isCreative((class_1657)player)) {
            VanillaEntityProperties.OfEntity.createInvulnerableProperty().withVal(noAi).writeTo(nbt);
        }
        PlayerSkills.giveExperienceLevelsIfNotCreative(player, -MobSetNoAiSkill.experienceLevelsCost(entity));
        EntityUtils.mergeNbt((class_1297)entity, nbt);
    }
}

