/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.skill.entity;

import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.IntProperty;
import io.github.xienaoban.biologydictionary.core.property.extra.VillagerJobSiteProperty;
import io.github.xienaoban.biologydictionary.core.skill.EntityTargetedSkill;
import io.github.xienaoban.biologydictionary.core.skill.NoPermissionException;
import io.github.xienaoban.biologydictionary.core.skill.Permissions;
import io.github.xienaoban.biologydictionary.core.skill.PlayerSkills;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2374;
import net.minecraft.class_2481;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class VillagerForceRestockSkill
implements EntityTargetedSkill<class_1646> {
    public static int emeraldsNeeded(int restocksToday) {
        return Math.max(0, restocksToday - 3 + 1) * 2;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean activate(class_1646 entity, Integer restocksToday, class_4208 jobSite) {
        return PlayerSkills.sendEntityTargetedSkill((class_1297)entity, restocksToday, jobSite);
    }

    private static boolean isCloseEnoughToJobSite(class_1646 entity, class_4208 jobSite) {
        return jobSite.comp_2207() == EntityUtils.getLevel((class_1297)entity).method_27983() && jobSite.comp_2208().method_19769((class_2374)entity.method_73189(), 1.73);
    }

    private static void checkVillagerHasJobSite(Integer restocksToday, class_4208 jobSite) {
        if (restocksToday == null || jobSite == null) {
            throw new NoPermissionException(class_2561.method_43471((String)"text.biologydictionary.villager_no_job_site"), "No job site");
        }
    }

    private static void checkVillagerCloseToJobSite(class_1646 entity, class_4208 jobSite) {
        if (!VillagerForceRestockSkill.isCloseEnoughToJobSite(entity, jobSite)) {
            throw new NoPermissionException(class_2561.method_43471((String)"text.biologydictionary.villager_too_far_from_job_site"), "Too far away from the job site");
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2520 clientSend(class_746 player, class_1646 entity, Object ... args) {
        Integer restocksToday = (Integer)args[0];
        class_4208 jobSite = (class_4208)args[1];
        VillagerForceRestockSkill.checkVillagerHasJobSite(restocksToday, jobSite);
        VillagerForceRestockSkill.checkVillagerCloseToJobSite(entity, jobSite);
        int emeralds = VillagerForceRestockSkill.emeraldsNeeded(restocksToday);
        Permissions.checkPlayerCreativeOrInventoryItems((class_1657)player, new class_1799((class_1935)class_1802.field_8687, emeralds));
        return class_2481.method_23234((boolean)true);
    }

    @Override
    public void serverReceive(MinecraftServer server, class_3222 player, class_1646 entity, class_2520 args) {
        Permissions.checkLegalArg((Boolean)args.method_68606().orElseThrow(), true);
        IntProperty<class_1646> restocksTodayProperty = VanillaEntityProperties.OfVillager.createRestocksTodayProperty();
        VillagerJobSiteProperty jobSiteProperty = new VillagerJobSiteProperty();
        restocksTodayProperty.readFrom(EntityUtils.getNbt((class_1297)entity));
        jobSiteProperty.getFrom(entity);
        Integer restocksToday = (Integer)restocksTodayProperty.getVal();
        class_4208 jobSite = (class_4208)jobSiteProperty.getVal();
        VillagerForceRestockSkill.checkVillagerHasJobSite(restocksToday, jobSite);
        VillagerForceRestockSkill.checkVillagerCloseToJobSite(entity, jobSite);
        int emeralds = VillagerForceRestockSkill.emeraldsNeeded((Integer)restocksTodayProperty.getVal());
        Permissions.checkPlayerCreativeOrInventoryItems((class_1657)player, new class_1799((class_1935)class_1802.field_8687, emeralds));
        Permissions.checkPlayerCreativeOrConsumeInventoryItems((class_1657)player, new class_1799((class_1935)class_1802.field_8687, emeralds));
        entity.method_19183();
        entity.method_19182();
    }
}

