/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.skill.general;

import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.core.skill.GeneralSkill;
import io.github.xienaoban.biologydictionary.core.skill.PlayerSkills;
import io.github.xienaoban.biologydictionary.net.ServerNetManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class HighlightEntitiesSkill
implements GeneralSkill {
    public static final int TICKS = 240;
    public static final int NEAR_RADIUS = 20;
    public static final int NEAR_EXPERIENCE_POINTS_COST = 1;
    public static final int FAR_RADIUS = 100;
    public static final int FAR_EXPERIENCE_POINTS_COST = 16;
    public static final int BLINDNESS_TICKS = 40;
    public static final int BLOCK_TICKS = 120;

    @Environment(value=EnvType.CLIENT)
    public static boolean activate(class_1299<?> entityType, float radius) {
        return PlayerSkills.sendCommonSkill(entityType, Float.valueOf(radius));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2520 clientSend(class_746 player, Object ... args) {
        class_1299 entityType = (class_1299)args[0];
        float radius = ((Float)args[1]).floatValue();
        class_2499 res = new class_2499();
        if (entityType == null) {
            res.add((Object)class_2519.method_23256((String)""));
        } else {
            res.add((Object)class_2519.method_23256((String)EntityUtils.getEntityTypeIdString(entityType)));
        }
        res.add((Object)class_2494.method_23244((float)radius));
        return res;
    }

    @Override
    public void serverReceive(MinecraftServer server, class_3222 player, class_2520 args) {
        boolean allowed;
        class_2499 argList = (class_2499)args.method_68592().orElseThrow();
        String entityTypeId = (String)argList.method_10608(0).orElseThrow();
        class_1299 entityType = EntityUtils.getEntityType(entityTypeId);
        float radius = ((Float)argList.method_10604(1).orElseThrow()).floatValue();
        if (entityType == null) {
            allowed = false;
            PlayerUtils.showClientCenteredMessage((class_1657)player, (class_2561)class_2561.method_43469((String)"text.biologydictionary.failed_to_highlight", (Object[])new Object[]{class_2561.method_43471((String)"text.biologydictionary.unknown_entity_type")}));
        } else if (PlayerUtils.isCreative((class_1657)player) || PlayerUtils.isSpectator((class_1657)player)) {
            allowed = true;
        } else if (entityType == class_1299.field_6097) {
            allowed = false;
            PlayerUtils.showClientCenteredMessage((class_1657)player, (class_2561)class_2561.method_43469((String)"text.biologydictionary.failed_to_highlight", (Object[])new Object[]{class_2561.method_43471((String)"text.biologydictionary.not_allowed_to_highlight_players")}));
        } else {
            int experience = radius <= 20.0f ? 1 : (radius <= 100.0f ? 16 : Integer.MAX_VALUE);
            if (PlayerUtils.getExperiencePoints((class_1657)player) < experience) {
                allowed = false;
                PlayerUtils.showClientCenteredMessage((class_1657)player, (class_2561)class_2561.method_43469((String)"text.biologydictionary.failed_to_highlight", (Object[])new Object[]{class_2561.method_43469((String)"text.biologydictionary.not_enough_experience_levels", (Object[])new Object[]{experience})}));
            } else {
                allowed = true;
                PlayerSkills.giveExperiencePointsIfNotCreative(player, -experience);
            }
        }
        if (allowed) {
            player.method_6092(new class_1293(class_1294.field_5919, 40));
        }
        ServerNetManager.replyHighlightEntitiesSkill(player, allowed, entityType, radius);
    }
}

