/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget;

import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.widget.TurnPageTriggerWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.AgeableMobBreedingCooldownWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.AgeableMobGrowthWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.AnimalFoodWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.AnimalInLoveWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.EntityAirWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.EntityBoundingBoxWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.EntityDisplayWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.EntityInvulnerableWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.EntityLeashableWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.EntityOwnerWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.EntityPortalCooldownWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.EntitySoundWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.LivingEntityActiveEffectsWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.LivingEntityHealthWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.LivingEntityInventoryWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.LivingEntityJumpStrengthWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.LivingEntityMovementSpeedWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.MobAiWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.MobPersistenceWidget;
import io.github.xienaoban.biologydictionary.core.widget.branch.MobTemptWidget;
import io.github.xienaoban.biologydictionary.core.widget.leaf.BeeHivePropertyWidget;
import io.github.xienaoban.biologydictionary.core.widget.leaf.DolphinMoistnessWidget;
import io.github.xienaoban.biologydictionary.core.widget.leaf.GoatScreamingWidget;
import io.github.xienaoban.biologydictionary.core.widget.leaf.SheepEatGrassWidget;
import io.github.xienaoban.biologydictionary.core.widget.leaf.VillagerJobSiteWidget;
import io.github.xienaoban.biologydictionary.core.widget.leaf.VillagerRestocksTodayWidget;
import io.github.xienaoban.biologydictionary.core.widget.leaf.VillagerScheduleWidget;
import io.github.xienaoban.biologydictionary.core.widget.leaf.WanderingTraderDespawnDelayWidget;
import io.github.xienaoban.biologydictionary.core.widget.variant.EntityStandardVariantWidget;
import io.github.xienaoban.biologydictionary.core.widget.variant.HorseMarkingsWidget;
import io.github.xienaoban.biologydictionary.core.widget.variant.PandaHiddenGeneWidget;
import io.github.xienaoban.biologydictionary.core.widget.variant.PandaMainGeneWidget;
import io.github.xienaoban.biologydictionary.core.widget.variant.VillagerTypeWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;

@Environment(value=EnvType.CLIENT)
public final class EntityPropertyWidgets {
    private static final Map<Class<? extends class_1297>, List<Entry>> registry = new HashMap<Class<? extends class_1297>, List<Entry>>();

    public static void registerBuiltIn(Registrar registrar) {
        registrar.register(EntityDisplayWidget.class, EntityDisplayWidget.FACTORY);
        registrar.register(LivingEntityHealthWidget.class, LivingEntityHealthWidget.FACTORY);
        registrar.register(EntityAirWidget.class, EntityAirWidget.FACTORY);
        registrar.register(DolphinMoistnessWidget.class, DolphinMoistnessWidget.FACTORY);
        registrar.register(LivingEntityActiveEffectsWidget.class, LivingEntityActiveEffectsWidget.FACTORY);
        registrar.register(AnimalFoodWidget.class, AnimalFoodWidget.FACTORY);
        registrar.register(MobTemptWidget.class, MobTemptWidget.FACTORY);
        registrar.register(LivingEntityMovementSpeedWidget.class, LivingEntityMovementSpeedWidget.FACTORY);
        registrar.register(LivingEntityJumpStrengthWidget.class, LivingEntityJumpStrengthWidget.FACTORY);
        registrar.register(EntityLeashableWidget.class, EntityLeashableWidget.FACTORY);
        registrar.register(GoatScreamingWidget.class, GoatScreamingWidget.FACTORY);
        registrar.register(EntityBoundingBoxWidget.class, EntityBoundingBoxWidget.FACTORY);
        registrar.register(TurnPageTriggerWidget.class, TurnPageTriggerWidget.FACTORY);
        registrar.register(EntityStandardVariantWidget.class, EntityStandardVariantWidget.FACTORY);
        registrar.register(HorseMarkingsWidget.class, HorseMarkingsWidget.FACTORY);
        registrar.register(PandaMainGeneWidget.class, PandaMainGeneWidget.FACTORY);
        registrar.register(PandaHiddenGeneWidget.class, PandaHiddenGeneWidget.FACTORY);
        registrar.register(VillagerTypeWidget.class, VillagerTypeWidget.FACTORY);
        registrar.register(VillagerScheduleWidget.class, VillagerScheduleWidget.FACTORY);
        registrar.register(MobAiWidget.class, MobAiWidget.FACTORY);
        registrar.register(EntityInvulnerableWidget.class, EntityInvulnerableWidget.FACTORY);
        registrar.register(EntitySoundWidget.class, EntitySoundWidget.FACTORY);
        registrar.register(MobPersistenceWidget.class, MobPersistenceWidget.FACTORY);
        registrar.register(SheepEatGrassWidget.class, SheepEatGrassWidget.FACTORY);
        registrar.register(AgeableMobGrowthWidget.class, AgeableMobGrowthWidget.FACTORY);
        registrar.register(AgeableMobBreedingCooldownWidget.class, AgeableMobBreedingCooldownWidget.FACTORY);
        registrar.register(AnimalInLoveWidget.class, AnimalInLoveWidget.FACTORY);
        registrar.register(EntityPortalCooldownWidget.class, EntityPortalCooldownWidget.FACTORY);
        registrar.register(EntityOwnerWidget.class, EntityOwnerWidget.FACTORY);
        registrar.register(LivingEntityInventoryWidget.class, LivingEntityInventoryWidget.FACTORY);
        registrar.register(VillagerJobSiteWidget.class, VillagerJobSiteWidget.FACTORY);
        registrar.register(VillagerRestocksTodayWidget.class, VillagerRestocksTodayWidget.FACTORY);
        registrar.register(BeeHivePropertyWidget.class, BeeHivePropertyWidget.FACTORY);
        registrar.register(WanderingTraderDespawnDelayWidget.class, WanderingTraderDespawnDelayWidget.FACTORY);
    }

    public static void init() {
        Registrar registrar = new Registrar(){
            private int orderIndex = 0;
            private final Set<Class<?>> visited = new HashSet();

            @Override
            public <E extends class_1297> void register(Class<? extends EntityPropertyWidget<E>> widgetClazz, EntityPropertyWidget.Factory<E> widgetFactory) {
                EntityPropertyWidgets.register0(widgetClazz, widgetFactory, ++this.orderIndex, this.visited);
            }
        };
        EntityPropertyWidgets.registerBuiltIn(registrar);
    }

    public static List<EntityPropertyWidget<?>> getWidgets(EntityProperties<?> properties) {
        ArrayList<Entry> entries = new ArrayList<Entry>(16);
        for (Class<? extends class_1297> clazz : EntityUtils.topDown(properties.entity())) {
            entries.addAll(EntityPropertyWidgets.getEntries(clazz));
        }
        entries.sort(Entry.CMP);
        ArrayList res = new ArrayList(entries.size());
        for (Entry entry : entries) {
            EntityPropertyWidget<?> widget = entry.create(properties);
            if (widget == null) continue;
            res.add(entry.create(properties));
        }
        return res;
    }

    private static <E extends class_1297> void register0(Class<? extends EntityPropertyWidget<E>> widgetClazz, EntityPropertyWidget.Factory<?> widgetFactory, int orderIndex, Set<Class<?>> visited) {
        if (!visited.add(widgetClazz)) {
            throw new IllegalStateException(String.valueOf(widgetClazz) + " is already registered!");
        }
        Class<?> tmp = Misc.getClazzGeneric(widgetClazz, EntityPropertyWidget.class, 0);
        Class entityClazz = (Class)Misc.cast(tmp.asSubclass(class_1297.class));
        Entry entry = new Entry(orderIndex, widgetClazz, widgetFactory);
        registry.computeIfAbsent(entityClazz, clazz -> new ArrayList()).add(entry);
    }

    private static List<Entry> getEntries(Class<? extends class_1297> clazz) {
        return registry.getOrDefault(clazz, Collections.emptyList());
    }

    @FunctionalInterface
    public static interface Registrar {
        public <E extends class_1297> void register(Class<? extends EntityPropertyWidget<E>> var1, EntityPropertyWidget.Factory<E> var2);
    }

    private record Entry(int order, Class<? extends EntityPropertyWidget<?>> clazz, EntityPropertyWidget.Factory<?> factory) {
        public static final Comparator<Entry> CMP = Comparator.comparingInt(Entry::order);

        public EntityPropertyWidget<?> create(EntityProperties<?> properties) {
            return this.factory.create((EntityProperties)Misc.cast(properties));
        }
    }
}

