/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.IntProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.AgeableMobSetForcedAgeSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import io.github.xienaoban.biologydictionary.mixin.AnimalIMixin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1296;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class AgeableMobBreedingCooldownWidget
extends EntityPropertyStandardWidget<class_1296> {
    public static final EntityPropertyWidget.Factory<class_1296> FACTORY = AgeableMobBreedingCooldownWidget::new;
    private static final int L = 6;
    private static final int T = 4;
    private static final int BREED_COOLDOWN_MAX = AnimalIMixin.getParentAgeAfterBreeding();
    private static final int BREED_COOLDOWN_OFF = 0;
    private final IntProperty<class_1296> ageProperty = VanillaEntityProperties.OfAgeableMob.getAgeProperty(this.p());
    private final IntProperty<class_1296> forcedAgeProperty = VanillaEntityProperties.OfAgeableMob.getForcedAgeProperty(this.p());

    public AgeableMobBreedingCooldownWidget(EntityProperties<class_1296> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 60.0f, 40.0f));
        this.setElementBar(new BreedingBar());
        this.addElementButton(new LockNeverBreedButton());
    }

    private boolean isAdultClient() {
        return !EntityUtils.isBaby((class_1296)this.e());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        Integer ageOpt = (Integer)this.ageProperty.getVal();
        if (ageOpt == null) {
            return;
        }
        int age = ageOpt;
        if (age > 0) {
            this.ageProperty.setVal(age - 1);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, AgeableMobBreedingCooldownWidget.tooltipTitle("property_widget.biologydictionary.breeding_cooldown"), AgeableMobBreedingCooldownWidget.tooltipDescription("property_widget.biologydictionary.breeding_cooldown.desc"));
        return true;
    }

    private final class BreedingBar
    extends EntityPropertyProgressBar {
        public BreedingBar() {
            super(Textures.ICONS, 70.0f, 40.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer ageOpt = (Integer)AgeableMobBreedingCooldownWidget.this.ageProperty.getVal();
            Integer forcedAgeOpt = (Integer)AgeableMobBreedingCooldownWidget.this.forcedAgeProperty.getVal();
            if (ageOpt == null || forcedAgeOpt == null) {
                this.updatePercent(0.0f);
                super.onRender(ctx);
                if (ctx.isDebug()) {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
                } else if (AgeableMobBreedingCooldownWidget.this.isAdultClient()) {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
                } else {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.baby"));
                }
                return;
            }
            int age = ageOpt;
            int forcedAge = forcedAgeOpt;
            this.updatePercent(forcedAge > 0 ? 1.0f : (float)age / (float)BREED_COOLDOWN_MAX);
            super.onRender(ctx);
            if (ctx.isDebug()) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(age + "t/" + BREED_COOLDOWN_MAX + "t")));
            } else if (AgeableMobBreedingCooldownWidget.this.isAdultClient()) {
                if (forcedAge > 0) {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.never_breed"));
                } else {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(age / 20 + "s/" + BREED_COOLDOWN_MAX / 20 / 60 + "m")));
                }
            } else {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.baby"));
            }
        }
    }

    private final class LockNeverBreedButton
    extends EntityPropertyButton {
        public LockNeverBreedButton() {
            super(Textures.ICONS, 230.0f, 20.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            Integer forcedAgeOpt = (Integer)AgeableMobBreedingCooldownWidget.this.forcedAgeProperty.getVal();
            if (forcedAgeOpt == null) {
                return true;
            }
            if (!AgeableMobBreedingCooldownWidget.this.isAdultClient()) {
                return true;
            }
            int forcedAge = forcedAgeOpt;
            if (LockNeverBreedButton.isMouseLeft(code)) {
                int newForcedAge = forcedAge == 0 ? BREED_COOLDOWN_MAX : 0;
                if (AgeableMobSetForcedAgeSkill.activate((class_1296)AgeableMobBreedingCooldownWidget.this.e(), newForcedAge, BREED_COOLDOWN_MAX)) {
                    AgeableMobBreedingCooldownWidget.this.forcedAgeProperty.setVal(newForcedAge);
                    AgeableMobBreedingCooldownWidget.this.ageProperty.setVal(BREED_COOLDOWN_MAX);
                }
            }
            return super.onMouseDown(x, y, code);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            if (!AgeableMobBreedingCooldownWidget.this.isAdultClient()) {
                this.setTextureLeftOffset(10.0f);
            } else {
                Integer forcedAge = (Integer)AgeableMobBreedingCooldownWidget.this.forcedAgeProperty.getVal();
                if (forcedAge != null && forcedAge > 0) {
                    this.setTextureLeftOffset(10.0f);
                } else {
                    this.setTextureLeftOffset(0.0f);
                }
            }
            super.onRender(ctx);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            AgeableMobBreedingCooldownWidget.this.renderTooltip(ctx, new class_2561[]{LockNeverBreedButton.tooltipTitle("property_widget.biologydictionary.breeding_cooldown.lock"), LockNeverBreedButton.tooltipDescription("property_widget.biologydictionary.breeding_cooldown.lock.desc"), LockNeverBreedButton.tooltipEmpty(), LockNeverBreedButton.tooltipBody("text.biologydictionary.experience_points_cost", 8)});
            return true;
        }
    }
}

