/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.IntProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.AgeableMobSetForcedAgeSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1296;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class AgeableMobGrowthWidget
extends EntityPropertyStandardWidget<class_1296> {
    public static final EntityPropertyWidget.Factory<class_1296> FACTORY = AgeableMobGrowthWidget::new;
    private static final int L = 1;
    private static final int T = 4;
    private static final int BABY_MIN_AGE = -24000;
    private static final int ADULT_MIN_AGE = 0;
    private final IntProperty<class_1296> ageProperty = VanillaEntityProperties.OfAgeableMob.getAgeProperty(this.p());
    private final IntProperty<class_1296> forcedAgeProperty = VanillaEntityProperties.OfAgeableMob.getForcedAgeProperty(this.p());

    public AgeableMobGrowthWidget(EntityProperties<class_1296> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 10.0f, 40.0f));
        this.setElementBar(new GrowthBar());
        this.addElementButton(new LockInBabyButton());
    }

    private boolean isAdultClient() {
        return !EntityUtils.isBaby((class_1296)this.e());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        Integer ageOpt = (Integer)this.ageProperty.getVal();
        if (ageOpt == null) {
            return;
        }
        int age = ageOpt;
        if (age < 0) {
            this.ageProperty.setVal(age + 1);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, AgeableMobGrowthWidget.tooltipTitle("property_widget.biologydictionary.growth"), AgeableMobGrowthWidget.tooltipDescription("property_widget.biologydictionary.growth.desc"));
        return true;
    }

    private final class GrowthBar
    extends EntityPropertyProgressBar {
        public GrowthBar() {
            super(Textures.ICONS, 20.0f, 40.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer ageOpt = (Integer)AgeableMobGrowthWidget.this.ageProperty.getVal();
            Integer forcedAgeOpt = (Integer)AgeableMobGrowthWidget.this.forcedAgeProperty.getVal();
            if (ageOpt == null || forcedAgeOpt == null) {
                if (AgeableMobGrowthWidget.this.isAdultClient()) {
                    this.updatePercent(1.0f);
                } else {
                    this.updatePercent(0.0f);
                }
                super.onRender(ctx);
                if (ctx.isDebug()) {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
                } else if (AgeableMobGrowthWidget.this.isAdultClient()) {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.adult"));
                } else {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
                }
                return;
            }
            int age = ageOpt;
            int forcedAge = forcedAgeOpt;
            this.updatePercent(forcedAge < 0 ? 0.0f : 1.0f - (float)age / -24000.0f);
            super.onRender(ctx);
            if (ctx.isDebug()) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(age + "t/0t")));
            } else if (!AgeableMobGrowthWidget.this.isAdultClient()) {
                if (forcedAge < 0) {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.always_baby"));
                } else {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)((age - -24000) / 20 + "s/20m")));
                }
            } else {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.adult"));
            }
        }
    }

    private final class LockInBabyButton
    extends EntityPropertyButton {
        public LockInBabyButton() {
            super(Textures.ICONS, 230.0f, 20.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            Integer forcedAgeOpt = (Integer)AgeableMobGrowthWidget.this.forcedAgeProperty.getVal();
            if (forcedAgeOpt == null) {
                return true;
            }
            if (AgeableMobGrowthWidget.this.isAdultClient()) {
                return true;
            }
            int forcedAge = forcedAgeOpt;
            if (LockInBabyButton.isMouseLeft(code)) {
                int newForcedAge = forcedAge == 0 ? -24000 : 0;
                if (AgeableMobSetForcedAgeSkill.activate((class_1296)AgeableMobGrowthWidget.this.e(), newForcedAge, -24000)) {
                    AgeableMobGrowthWidget.this.forcedAgeProperty.setVal(newForcedAge);
                    AgeableMobGrowthWidget.this.ageProperty.setVal(-24000);
                }
            }
            return super.onMouseDown(x, y, code);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            if (AgeableMobGrowthWidget.this.isAdultClient()) {
                this.setTextureLeftOffset(10.0f);
            } else {
                Integer forcedAge = (Integer)AgeableMobGrowthWidget.this.forcedAgeProperty.getVal();
                if (forcedAge != null && forcedAge < 0) {
                    this.setTextureLeftOffset(10.0f);
                } else {
                    this.setTextureLeftOffset(0.0f);
                }
            }
            super.onRender(ctx);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            AgeableMobGrowthWidget.this.renderTooltip(ctx, new class_2561[]{LockInBabyButton.tooltipTitle("property_widget.biologydictionary.growth.lock"), LockInBabyButton.tooltipDescription("property_widget.biologydictionary.growth.lock.desc"), LockInBabyButton.tooltipEmpty(), LockInBabyButton.tooltipBody("text.biologydictionary.experience_points_cost", 8)});
            return true;
        }
    }
}

