/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyBar;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.util.Comparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public final class AnimalFoodWidget
extends EntityPropertyStandardWidget<class_1429> {
    public static final EntityPropertyWidget.Factory<class_1429> FACTORY = AnimalFoodWidget::new;
    private static final int L = 11;
    private static final int T = 2;
    private final class_1799[] foods = this.getFoodItems();

    public AnimalFoodWidget(EntityProperties<class_1429> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 110.0f, 20.0f));
        this.setElementBar(new FoodBar());
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, AnimalFoodWidget.tooltipTitle("property_widget.biologydictionary.food"), AnimalFoodWidget.tooltipDescription("property_widget.biologydictionary.food.desc"));
        return true;
    }

    private class_1799[] getFoodItems() {
        return (class_1799[])class_7923.field_41178.method_10220().map(class_1799::new).filter(itemStack -> ((class_1429)this.e()).method_6481(itemStack)).sorted(Comparator.comparingInt(o -> class_7923.field_41178.method_10206((Object)o.method_7909()))).toArray(class_1799[]::new);
    }

    private final class FoodBar
    extends EntityPropertyBar {
        private float gap;

        public FoodBar() {
            super(Textures.ICONS, 120.0f, 20.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            int i;
            super.onRender(ctx);
            this.renderFullBar(ctx);
            if (AnimalFoodWidget.this.foods.length == 0) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.empty_with_brackets"), -2012147439);
                return;
            }
            for (i = AnimalFoodWidget.this.foods.length - 1; i >= 0; --i) {
                ctx.renderTexture(Textures.ICONS, 210.0f, 20.0f, ctx.getZ(), this.getBox().getLeft() - 1.0f + (float)i * this.gap, this.getBox().getTop() - 1.0f, 10.0f, 10.0f);
            }
            for (i = AnimalFoodWidget.this.foods.length - 1; i >= 0; --i) {
                ctx.renderItem(AnimalFoodWidget.this.foods[i], 0.5f, this.getBox().getLeft() + (float)i * this.gap, this.getBox().getTop());
            }
        }

        @Override
        protected void onResize(int width, int height) {
            super.onResize(width, height);
            this.gap = Math.min(10.0f, (this.getBox().getWidth() - 8.0f) / (float)Math.max(1, AnimalFoodWidget.this.foods.length - 1));
        }
    }
}

