/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.IntProperty;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1296;
import net.minecraft.class_1429;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class AnimalInLoveWidget
extends EntityPropertyStandardWidget<class_1429> {
    public static final EntityPropertyWidget.Factory<class_1429> FACTORY = AnimalInLoveWidget::new;
    private static final int L = 6;
    private static final int T = 3;
    private static final int IN_LOVE_MAX_TIME = 600;
    private final IntProperty<class_1429> inLoveProperty = VanillaEntityProperties.OfAnimal.getInLoveProperty(this.p());

    public AnimalInLoveWidget(EntityProperties<class_1429> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 60.0f, 30.0f));
        this.setElementBar(new InLoveBar());
    }

    private boolean isBabyClient() {
        return EntityUtils.isBaby((class_1296)this.e());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        Integer inLoveOpt = (Integer)this.inLoveProperty.getVal();
        if (inLoveOpt == null) {
            return;
        }
        int age = inLoveOpt;
        if (age > 0) {
            this.inLoveProperty.setVal(age - 1);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, AnimalInLoveWidget.tooltipTitle("property_widget.biologydictionary.in_love"), AnimalInLoveWidget.tooltipDescription("property_widget.biologydictionary.in_love.desc"));
        return true;
    }

    private final class InLoveBar
    extends EntityPropertyProgressBar {
        public InLoveBar() {
            super(Textures.ICONS, 70.0f, 30.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer inLoveOpt = (Integer)AnimalInLoveWidget.this.inLoveProperty.getVal();
            if (inLoveOpt == null) {
                this.updatePercent(0.0f);
                super.onRender(ctx);
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
                return;
            }
            int inLoveTime = inLoveOpt;
            int inLoveMaxTime = 600;
            this.updatePercent((float)inLoveTime / (float)inLoveMaxTime);
            super.onRender(ctx);
            if (ctx.isDebug()) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(inLoveTime + "t/" + inLoveMaxTime + "t")));
            } else if (AnimalInLoveWidget.this.isBabyClient()) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.baby"));
            } else {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(inLoveTime / 20 + "s/" + inLoveMaxTime / 20 + "s")));
            }
        }
    }
}

