/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import com.mojang.authlib.GameProfile;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1480;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_638;
import net.minecraft.class_745;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class EntityDisplayWidget
extends EntityPropertyWidget<class_1297> {
    public static final EntityPropertyWidget.Factory<class_1297> FACTORY = EntityDisplayWidget::new;
    private final class_1297 model;
    private final ScreenRenderingContext.EntityRenderingCache entityRenderingCache = new ScreenRenderingContext.EntityRenderingCache();

    private static EntityPropertyWidget.RC calculateRowsAndColumns(class_1297 entity) {
        double y;
        class_238 box = entity.method_5829();
        double x = box.method_17939();
        if (x > (y = box.method_17940())) {
            return new EntityPropertyWidget.RC(3, 6);
        }
        return new EntityPropertyWidget.RC(5, 4);
    }

    private static class_1297 createModelEntity(class_1297 entity) {
        Object model = EntityUtils.create(EntityUtils.getEntityType(entity), EntityUtils.getLevel(entity));
        if (model == null) {
            if (entity instanceof class_746) {
                class_746 me = (class_746)entity;
                GameProfile profile = me.method_7334();
                model = new class_745((class_638)me.method_73183(), new GameProfile(profile.id(), profile.name()));
                class_243 pos = model.method_73189();
                model.method_5814(pos.method_10216(), pos.method_10214() - 4097.0, pos.method_10215());
            } else {
                model = EntityUtils.create(class_1299.field_6131, EntityUtils.getLevel(entity));
            }
        }
        EntityDisplayWidget.updateCompoundTag(entity, model);
        return model;
    }

    private static void updateCompoundTag(class_1297 from, class_1297 to) {
        EntityUtils.setNbt(to, EntityUtils.getNbtToDisplay(from));
        if (to instanceof class_1480) {
            class_1480 waterAnimal = (class_1480)to;
            EntityUtils.setInWater((class_1297)waterAnimal, true);
        }
    }

    public EntityDisplayWidget(EntityProperties<class_1297> properties) {
        this(properties, EntityDisplayWidget.createModelEntity(properties.entity()));
    }

    private EntityDisplayWidget(EntityProperties<class_1297> properties, class_1297 model) {
        super(properties, EntityDisplayWidget.calculateRowsAndColumns(model));
        this.model = model;
        this.p().setModel(model);
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        if (ticks % ClientUtils.getClientTickCountPerSecond() == 15 && this.p().isNotInNoUpdateCooldown()) {
            EntityDisplayWidget.updateCompoundTag(this.e(), this.model);
        }
    }

    @Override
    protected void onRender(ScreenRenderingContext ctx) {
        super.onRender(ctx);
        ctx.renderEntityCentered(this.model, this.entityRenderingCache, this.getBox().getLeft(), this.getBox().getTop(), this.getBox().getRight(), this.getBox().getBottom(), (float)Math.atan(ctx.getMouseX() / 40.0f) / 10.0f, (float)Math.atan(ctx.getMouseY() / 40.0f) / 20.0f);
    }
}

