/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.BooleanProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntitySetInvulnerableSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class EntityInvulnerableWidget
extends EntityPropertyStandardWidget<class_1297> {
    public static final EntityPropertyWidget.Factory<class_1297> FACTORY = EntityInvulnerableWidget::new;
    private static final int L = 19;
    private static final int T = 1;
    private final BooleanProperty<class_1297> invulnerableProperty = VanillaEntityProperties.OfEntity.getInvulnerableProperty(this.p());

    public EntityInvulnerableWidget(EntityProperties<class_1297> properties) {
        super(properties, 2);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 190.0f, 10.0f));
        this.addElementButton(new InvulnerableButton());
    }

    private boolean isInvulnerable() {
        Boolean inv = (Boolean)this.invulnerableProperty.getVal();
        return inv != null && inv != false;
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, EntityInvulnerableWidget.tooltipTitle("property_widget.biologydictionary.invulnerable"), EntityInvulnerableWidget.tooltipDescription("property_widget.biologydictionary.invulnerable.desc"));
        return true;
    }

    private final class InvulnerableButton
    extends EntityPropertyButton {
        public InvulnerableButton() {
            super(Textures.ICONS, 210.0f, 10.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (InvulnerableButton.isMouseLeft(code)) {
                boolean newInv;
                boolean bl = newInv = !EntityInvulnerableWidget.this.isInvulnerable();
                if (EntitySetInvulnerableSkill.activate(EntityInvulnerableWidget.this.e(), newInv)) {
                    EntityInvulnerableWidget.this.invulnerableProperty.setVal(newInv);
                }
            }
            return true;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            this.setTextureLeftOffset((EntityInvulnerableWidget.this.isInvulnerable() ? 0 : 1) * 10);
            super.onRender(ctx);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            EntityInvulnerableWidget.this.renderTooltip(ctx, new class_2561[]{InvulnerableButton.tooltipTitle("property_widget.biologydictionary.invulnerable.switch"), InvulnerableButton.tooltipDescription("property_widget.biologydictionary.invulnerable.switch.desc"), InvulnerableButton.tooltipEmpty(), InvulnerableButton.tooltipBody("text.biologydictionary.only_in_creative_mode")});
            return true;
        }
    }
}

