/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.vanilla.EntityReferenceProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntityGiftPetSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyTextBar;
import io.github.xienaoban.biologydictionary.gui.screen.AbstractBiologyDictionaryScreen;
import io.github.xienaoban.biologydictionary.gui.screen.misc.PlayerSelectorScreen;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_10583;
import net.minecraft.class_1297;
import net.minecraft.class_1496;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_6025;

public class EntityOwnerWidget
extends EntityPropertyStandardWidget<class_1297> {
    public static final EntityPropertyWidget.Factory<class_1297> FACTORY = properties -> {
        if (properties.entity() instanceof class_6025) {
            return new EntityOwnerWidget(properties);
        }
        return null;
    };
    private static final int L = 11;
    private static final int T = 5;
    private static final int L_GIFT = 22;
    private static final int T_GIFT = 4;
    private static final String OWNER_KEY = VanillaEntityProperties.OfTamableAnimal.createOwnerProperty().name();
    private final EntityReferenceProperty<class_1496> ownerProperty = (EntityReferenceProperty)this.p().getVanilla(OWNER_KEY);
    private UUID lastUuid = null;
    private class_1297 lastEntity = null;

    public EntityOwnerWidget(EntityProperties<class_1297> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 110.0f, 50.0f));
        this.setElementBar(new OwnerBar());
        this.addElementButton(new GiftButton());
    }

    private void updateOwnerRef() {
        class_10583 ref = (class_10583)this.ownerProperty.getVal();
        if (ref == null) {
            if (this.lastUuid != null) {
                this.lastUuid = null;
                this.lastEntity = null;
            }
        } else {
            UUID uuid = ref.method_66263();
            if (!Objects.equals(uuid, this.lastUuid)) {
                this.lastUuid = uuid;
                this.lastEntity = (class_1297)ref.method_73298((class_1937)ClientUtils.getClientLevel(), class_1297.class);
            }
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add(EntityOwnerWidget.tooltipTitle("property_widget.biologydictionary.owner"));
        list.add(EntityOwnerWidget.tooltipDescription("property_widget.biologydictionary.owner.desc"));
        list.add(EntityOwnerWidget.tooltipEmpty());
        if (this.lastUuid == null) {
            list.add(EntityOwnerWidget.tooltipBody("property_widget.biologydictionary.owner.none"));
        } else {
            list.add(EntityOwnerWidget.tooltipBody("property_widget.biologydictionary.owner.uuid", this.lastUuid.toString()));
            if (this.lastEntity == null) {
                list.add(EntityOwnerWidget.tooltipBody("property_widget.biologydictionary.owner.not_online"));
            } else {
                list.add(EntityOwnerWidget.tooltipBody("property_widget.biologydictionary.owner.name", this.lastEntity.method_5477()));
            }
        }
        this.renderTooltip(ctx, list);
        return true;
    }

    private final class OwnerBar
    extends EntityPropertyTextBar {
        public OwnerBar() {
            super(Textures.ICONS, 120.0f, 50.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            EntityOwnerWidget.this.updateOwnerRef();
            if (EntityOwnerWidget.this.lastUuid == null) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.none_with_brackets"), -1140850689);
            } else if (EntityOwnerWidget.this.lastEntity == null) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)EntityOwnerWidget.this.lastUuid.toString()), -1140850689);
            } else {
                this.renderInnerText(ctx, EntityOwnerWidget.this.lastEntity.method_5477(), -1140850689);
            }
        }
    }

    public final class GiftButton
    extends EntityPropertyButton {
        public GiftButton() {
            super(Textures.ICONS, 220.0f, 40.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (GiftButton.isMouseLeft(code)) {
                if (EntityOwnerWidget.this.lastEntity != ClientUtils.getClientPlayer()) {
                    AbstractBiologyDictionaryScreen.current().sendScreenMessage((class_2561)class_2561.method_43471((String)"text.biologydictionary.not_owner_no_permission_to_gift"));
                    return true;
                }
                ClientUtils.setScreen(new PlayerSelectorScreen((AbstractBiologyDictionaryScreen)((Object)ClientUtils.getCurrentScreen()), targetPlayer -> {
                    AbstractBiologyDictionaryScreen.current().sendScreenMessage(null);
                    EntityGiftPetSkill.activate(EntityOwnerWidget.this.e(), targetPlayer);
                    EntityOwnerWidget.this.ownerProperty.setVal(class_10583.method_73300((UUID)targetPlayer.method_5667()));
                }));
            }
            return true;
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            EntityOwnerWidget.this.renderTooltip(ctx, new class_2561[]{GiftButton.tooltipTitle("property_widget.biologydictionary.owner.gift"), GiftButton.tooltipDescription("property_widget.biologydictionary.owner.gift.desc")});
            return true;
        }
    }
}

