/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.IntProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntitySetPortalCooldownSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

@Environment(value=EnvType.CLIENT)
public final class EntityPortalCooldownWidget
extends EntityPropertyStandardWidget<class_1297> {
    public static final EntityPropertyWidget.Factory<class_1297> FACTORY = EntityPortalCooldownWidget::new;
    private static final int L = 1;
    private static final int T = 3;
    private final IntProperty<class_1297> portalCooldownProperty = VanillaEntityProperties.OfEntity.getPortalCooldownProperty(this.p());
    private int inPortalRecheck = 0;

    public EntityPortalCooldownWidget(EntityProperties<class_1297> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 10.0f, 30.0f));
        this.setElementBar(new PortalCooldownBar());
        this.addElementButton(new LockPortalCooldownButton());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        Integer cooldownOpt = (Integer)this.portalCooldownProperty.getVal();
        if (cooldownOpt == null) {
            return;
        }
        int cooldown = cooldownOpt;
        if (cooldown != 303) {
            if (this.isClientEntityInNetherPortal()) {
                this.portalCooldownProperty.setVal(this.e().method_5806());
            } else {
                this.portalCooldownProperty.setVal(Math.max(0, cooldown - 1));
            }
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, EntityPortalCooldownWidget.tooltipTitle("property_widget.biologydictionary.portal_cooldown"), EntityPortalCooldownWidget.tooltipDescription("property_widget.biologydictionary.portal_cooldown.desc"));
        return true;
    }

    private boolean isClientEntityInNetherPortal() {
        class_2338[] blockPoses;
        Object entity = this.e();
        class_1937 level = EntityUtils.getLevel(entity);
        class_2338 pos = entity.method_24515();
        class_238 box = entity.method_5829();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        for (class_2338 bp : blockPoses = new class_2338[]{pos, new class_2338(x + 1, y, z), new class_2338(x - 1, y, z), new class_2338(x, y, z + 1), new class_2338(x, y, z - 1)}) {
            class_2680 bs = level.method_8320(bp);
            if (bs.method_26215() || bs.method_26204() != class_2246.field_10316 || !box.method_64032(class_243.field_1353, List.of(new class_238(bp).method_1011(0.01)))) continue;
            return --this.inPortalRecheck <= 0;
        }
        this.inPortalRecheck = 2;
        return false;
    }

    private final class PortalCooldownBar
    extends EntityPropertyProgressBar {
        public PortalCooldownBar() {
            super(Textures.ICONS, 20.0f, 30.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer cooldownOpt = (Integer)EntityPortalCooldownWidget.this.portalCooldownProperty.getVal();
            if (cooldownOpt == null) {
                this.updatePercent(0.0f);
                super.onRender(ctx);
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
                return;
            }
            int maxCooldown = EntityPortalCooldownWidget.this.e().method_5806();
            int cooldown = cooldownOpt;
            this.updatePercent((float)cooldown / (float)maxCooldown);
            super.onRender(ctx);
            if (cooldown == 303) {
                if (ctx.isDebug()) {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.infinity"));
                } else {
                    this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.infinity_character"));
                }
            } else if (ctx.isDebug()) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(cooldown + "t/" + maxCooldown + "t")));
            } else {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(cooldown / ClientUtils.getClientTickCountPerSecond() + "s/" + maxCooldown / ClientUtils.getClientTickCountPerSecond() + "s")));
            }
        }
    }

    private final class LockPortalCooldownButton
    extends EntityPropertyButton {
        public LockPortalCooldownButton() {
            super(Textures.ICONS, 230.0f, 20.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            Integer cooldownOpt = (Integer)EntityPortalCooldownWidget.this.portalCooldownProperty.getVal();
            if (cooldownOpt == null) {
                return true;
            }
            int cooldown = cooldownOpt;
            if (LockPortalCooldownButton.isMouseLeft(code)) {
                int newCooldown = cooldown == 303 ? 0 : 303;
                if (EntitySetPortalCooldownSkill.activate(EntityPortalCooldownWidget.this.e(), newCooldown)) {
                    EntityPortalCooldownWidget.this.portalCooldownProperty.setVal(newCooldown);
                }
            }
            return super.onMouseDown(x, y, code);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer cooldown = (Integer)EntityPortalCooldownWidget.this.portalCooldownProperty.getVal();
            if (cooldown != null && cooldown == 303) {
                this.setTextureLeftOffset(10.0f);
            } else {
                this.setTextureLeftOffset(0.0f);
            }
            super.onRender(ctx);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            EntityPortalCooldownWidget.this.renderTooltip(ctx, new class_2561[]{LockPortalCooldownButton.tooltipTitle("property_widget.biologydictionary.portal_cooldown.lock"), LockPortalCooldownButton.tooltipDescription("property_widget.biologydictionary.portal_cooldown.lock_desc")});
            return true;
        }
    }
}

