/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.BooleanProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.EntitySetSoundSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class EntitySoundWidget
extends EntityPropertyStandardWidget<class_1297> {
    public static final EntityPropertyWidget.Factory<class_1297> FACTORY = EntitySoundWidget::new;
    private static final int L = 20;
    private static final int T = 1;
    private final BooleanProperty<class_1297> silentProperty = VanillaEntityProperties.OfEntity.getSilentProperty(this.p());

    public EntitySoundWidget(EntityProperties<class_1297> properties) {
        super(properties, 2);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 200.0f, 10.0f));
        this.addElementButton(new SoundButton());
    }

    private boolean isSilent() {
        Boolean silent = (Boolean)this.silentProperty.getVal();
        return silent != null && silent != false;
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, EntitySoundWidget.tooltipTitle("property_widget.biologydictionary.sound"), EntitySoundWidget.tooltipDescription("property_widget.biologydictionary.sound.desc"));
        return true;
    }

    private final class SoundButton
    extends EntityPropertyButton {
        public SoundButton() {
            super(Textures.ICONS, 210.0f, 10.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (SoundButton.isMouseLeft(code)) {
                boolean newSilent;
                boolean bl = newSilent = !EntitySoundWidget.this.isSilent();
                if (EntitySetSoundSkill.activate(EntitySoundWidget.this.e(), newSilent)) {
                    EntitySoundWidget.this.silentProperty.setVal(newSilent);
                }
            }
            return true;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            this.setTextureLeftOffset((EntitySoundWidget.this.isSilent() ? 1 : 0) * 10);
            super.onRender(ctx);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            EntitySoundWidget.this.renderTooltip(ctx, new class_2561[]{SoundButton.tooltipTitle("property_widget.biologydictionary.sound.switch"), SoundButton.tooltipDescription("property_widget.biologydictionary.sound.switch.desc"), SoundButton.tooltipEmpty(), SoundButton.tooltipBody("text.biologydictionary.experience_points_cost", EntitySetSoundSkill.experiencePointsCost(EntitySoundWidget.this.e()))});
            return true;
        }
    }
}

