/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.CodecProperty;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import io.github.xienaoban.biologydictionary.mixin.MobEffectInstanceIMixin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public final class LivingEntityActiveEffectsWidget
extends EntityPropertyStandardWidget<class_1309> {
    public static final EntityPropertyWidget.Factory<class_1309> FACTORY = LivingEntityActiveEffectsWidget::new;
    private static final int L = 11;
    private static final int T = 3;
    private final CodecProperty<class_1309, List<class_1293>> activeEffectsProperty = VanillaEntityProperties.OfLivingEntity.getActiveEffectsProperty(this.p());

    public LivingEntityActiveEffectsWidget(EntityProperties<class_1309> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 110.0f, 30.0f));
        this.setElementBar(new ActiveEffectsBar());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        List effects = (List)this.activeEffectsProperty.getVal();
        if (effects == null || effects.isEmpty()) {
            return;
        }
        for (class_1293 effect : effects) {
            int duration = effect.method_5584();
            if (duration <= 0) continue;
            ((MobEffectInstanceIMixin)effect).setDuration(duration - 1);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add(LivingEntityActiveEffectsWidget.tooltipTitle("property_widget.biologydictionary.effects"));
        list.add(LivingEntityActiveEffectsWidget.tooltipDescription("property_widget.biologydictionary.effects.desc"));
        list.add((class_2561)class_2561.method_43473());
        List effects = (List)this.activeEffectsProperty.getVal();
        if (effects == null || effects.isEmpty()) {
            list.add(LivingEntityActiveEffectsWidget.tooltipBody("text.biologydictionary.empty_with_brackets"));
        } else {
            class_2561 name;
            int maxW = -1;
            for (class_1293 effect : effects) {
                name = ((class_1291)effect.method_5579().comp_349()).method_5560();
                maxW = Math.max(maxW, ctx.calcTextWidth(name));
            }
            for (class_1293 effect : effects) {
                name = class_2564.method_37112(Arrays.asList(((class_1291)effect.method_5579().comp_349()).method_5560(), class_2561.method_43470((String)String.valueOf(effect.method_5578() + 1))), (class_2561)class_2561.method_43473());
                int duration = effect.method_5584();
                class_5250 time = ctx.isDebug() ? class_2561.method_43470((String)(duration + "t")).method_27692(class_124.field_1080) : (duration == -1 ? class_2561.method_43471((String)"text.biologydictionary.infinity_character").method_27692(class_124.field_1080) : class_2561.method_43470((String)(effect.method_5584() / 20 + "s")).method_27692(class_124.field_1080));
                int w = ctx.calcTextWidth(name) + ctx.calcTextWidth((class_2561)time);
                class_5250 dot = class_2561.method_43470((String)".".repeat(Math.max(0, (maxW + 40 - w) / 2))).method_27692(class_124.field_1063);
                list.add(class_2564.method_37112(Arrays.asList(name, dot, time), (class_2561)class_2561.method_43470((String)" ")));
            }
        }
        this.renderTooltip(ctx, list);
        return true;
    }

    private final class ActiveEffectsBar
    extends EntityPropertyProgressBar {
        private float gap;
        private int lastSize;

        public ActiveEffectsBar() {
            super(Textures.ICONS, 120.0f, 30.0f);
            this.lastSize = 0;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            int i;
            class_5250 text = null;
            List effects = (List)LivingEntityActiveEffectsWidget.this.activeEffectsProperty.getVal();
            if (effects == null) {
                text = class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets");
            } else if (effects.isEmpty()) {
                text = class_2561.method_43471((String)"text.biologydictionary.empty_with_brackets");
            }
            this.updatePercent(text != null ? 0.0f : 1.0f);
            super.onRender(ctx);
            if (text != null) {
                this.renderInnerText(ctx, (class_2561)text, -2012147439);
                return;
            }
            if (this.lastSize != effects.size()) {
                this.lastSize = effects.size();
                this.updateGap(this.lastSize);
            }
            for (i = effects.size() - 1; i >= 0; --i) {
                ctx.renderTexture(Textures.ICONS, 210.0f, 30.0f, ctx.getZ(), this.getBox().getLeft() - 1.0f + (float)i * this.gap, this.getBox().getTop() - 1.0f, 10.0f, 10.0f);
            }
            i = -1;
            for (class_1293 effect : effects) {
                ctx.renderEffect((class_6880<class_1291>)effect.method_5579(), 0.444444f, this.getBox().getLeft() + 0.05f + (float)(++i) * this.gap, this.getBox().getTop());
            }
        }

        @Override
        protected void onResize(int width, int height) {
            super.onResize(width, height);
            List effects = (List)LivingEntityActiveEffectsWidget.this.activeEffectsProperty.getVal();
            int size = effects == null ? 0 : effects.size();
            this.updateGap(size);
        }

        private void updateGap(float size) {
            this.gap = Math.min(9.0f, (this.getBox().getWidth() - 8.0f) / Math.max(1.0f, size - 1.0f));
        }
    }
}

