/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.BiologyDictionaryClient;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.extra.EntityInventorySizeProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.LivingEntityStealInventorySkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyTextBar;
import io.github.xienaoban.biologydictionary.gui.screen.misc.InventoryStealingScreen;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;

public class LivingEntityInventoryWidget
extends EntityPropertyStandardWidget<class_1309> {
    public static final EntityPropertyWidget.Factory<class_1309> FACTORY = LivingEntityInventoryWidget::new;
    private static final int L = 11;
    private static final int T = 6;
    private static final int L_STEAL = 21;
    private static final int T_STEAL = 5;
    private final EntityInventorySizeProperty inventorySize = (EntityInventorySizeProperty)this.p().getExtra(EntityInventorySizeProperty.class);

    public LivingEntityInventoryWidget(EntityProperties<class_1309> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 110.0f, 60.0f));
        this.setElementBar(new InventorySizeBar());
        this.addElementButton(new StealButton());
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, LivingEntityInventoryWidget.tooltipTitle("property_widget.biologydictionary.inventory"), LivingEntityInventoryWidget.tooltipDescription("property_widget.biologydictionary.inventory.desc1"), LivingEntityInventoryWidget.tooltipDescription("property_widget.biologydictionary.inventory.desc2"));
        return true;
    }

    private final class InventorySizeBar
    extends EntityPropertyTextBar {
        public InventorySizeBar() {
            super(Textures.ICONS, 120.0f, 60.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            Integer size = (Integer)LivingEntityInventoryWidget.this.inventorySize.getVal();
            if (size == null) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
            } else {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)String.valueOf(LivingEntityInventoryWidget.this.inventorySize.getVal())));
            }
        }
    }

    private final class StealButton
    extends EntityPropertyButton {
        public StealButton() {
            super(Textures.ICONS, 210.0f, 50.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (StealButton.isMouseLeft(code)) {
                if (InventoryStealingScreen.isPlayerCaughtByEntity((class_1309)LivingEntityInventoryWidget.this.e(), (class_1657)ClientUtils.getClientPlayer())) {
                    BiologyDictionaryClient.sendCenteredWarning(class_2561.method_43471((String)"text.biologydictionary.entity_looking_at_you"));
                    return true;
                }
                LivingEntityStealInventorySkill.activate(LivingEntityInventoryWidget.this.e());
            }
            return true;
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            boolean isCreative = PlayerUtils.isCreative((class_1657)ClientUtils.getClientPlayer());
            LivingEntityInventoryWidget.this.renderTooltip(ctx, new class_2561[]{StealButton.tooltipTitle("property_widget.biologydictionary.inventory.steal"), StealButton.tooltipDescription("property_widget.biologydictionary.inventory.steal.desc1"), StealButton.tooltipDescription("property_widget.biologydictionary.inventory.steal.desc2"), StealButton.tooltipEmpty(), StealButton.tooltipBody(isCreative ? "property_widget.biologydictionary.inventory.steal.creative" : "property_widget.biologydictionary.inventory.steal.survival")});
            return true;
        }
    }
}

