/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.Lang;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.BooleanProperty;
import io.github.xienaoban.biologydictionary.core.property.extra.MobNaturalPersistenceProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.MobForcePersistentSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class MobPersistenceWidget
extends EntityPropertyStandardWidget<class_1308> {
    public static final EntityPropertyWidget.Factory<class_1308> FACTORY = MobPersistenceWidget::new;
    private static final int L = 6;
    private static final int T = 6;
    private final BooleanProperty<class_1308> persistenceRequiredProperty = VanillaEntityProperties.OfMob.getPersistenceRequiredProperty(this.p());
    private final MobNaturalPersistenceProperty naturalPersistenceProperty = (MobNaturalPersistenceProperty)this.p().getExtra(MobNaturalPersistenceProperty.class);

    public MobPersistenceWidget(EntityProperties<class_1308> properties) {
        super(properties, 4);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 60.0f, 60.0f));
        this.addElementButton(new ForcedPersistentButton());
        this.addElementButton(new PersistentButton());
    }

    private boolean isForcedPersistent() {
        Boolean persistent = (Boolean)this.persistenceRequiredProperty.getVal();
        return persistent != null && persistent != false;
    }

    private boolean isNaturalPersistent() {
        Boolean persistent = (Boolean)this.naturalPersistenceProperty.getVal();
        return persistent != null && persistent != false;
    }

    private boolean isPersistent() {
        return this.isForcedPersistent() || this.isNaturalPersistent();
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, MobPersistenceWidget.tooltipTitle("property_widget.biologydictionary.persistence"), MobPersistenceWidget.tooltipDescription("property_widget.biologydictionary.persistence.desc"));
        return true;
    }

    private final class ForcedPersistentButton
    extends EntityPropertyButton {
        public ForcedPersistentButton() {
            super(Textures.ICONS, 210.0f, 10.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (ForcedPersistentButton.isMouseLeft(code)) {
                boolean persistent;
                boolean bl = persistent = !MobPersistenceWidget.this.isForcedPersistent();
                if (MobForcePersistentSkill.activate((class_1308)MobPersistenceWidget.this.e(), persistent)) {
                    MobPersistenceWidget.this.persistenceRequiredProperty.setVal(persistent);
                }
            }
            return true;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            this.setTextureLeftOffset((MobPersistenceWidget.this.isForcedPersistent() ? 0 : 1) * 10);
            super.onRender(ctx);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            MobPersistenceWidget.this.renderTooltip(ctx, new class_2561[]{ForcedPersistentButton.tooltipTitle("property_widget.biologydictionary.persistence.forced"), ForcedPersistentButton.tooltipDescription("property_widget.biologydictionary.persistence.forced.desc")});
            return true;
        }
    }

    private final class PersistentButton
    extends EntityPropertyButton {
        public PersistentButton() {
            super(Textures.ICONS, 230.0f, 10.0f);
            this.setSelectable(false);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            this.setTextureLeftOffset((MobPersistenceWidget.this.isPersistent() ? 0 : 1) * 10);
            super.onRender(ctx);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            MobPersistenceWidget.this.renderTooltip(ctx, new class_2561[]{PersistentButton.tooltipTitle("property_widget.biologydictionary.persistence.final"), PersistentButton.tooltipDescription("property_widget.biologydictionary.persistence.final.desc"), PersistentButton.tooltipEmpty(), PersistentButton.tooltipBody("property_widget.biologydictionary.persistence.final.forced", Lang.textYesOrNo(MobPersistenceWidget.this.isForcedPersistent())), PersistentButton.tooltipBody("property_widget.biologydictionary.persistence.final.natural", Lang.textYesOrNo(MobPersistenceWidget.this.isNaturalPersistent()))});
            return true;
        }
    }
}

