/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.branch;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.extra.MobTemptProperty;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyBar;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public final class MobTemptWidget
extends EntityPropertyStandardWidget<class_1308> {
    public static final EntityPropertyWidget.Factory<class_1308> FACTORY = MobTemptWidget::new;
    private static final int L = 14;
    private static final int T = 2;
    private final MobTemptProperty temptProperty = (MobTemptProperty)this.p().getExtra(MobTemptProperty.class);

    public MobTemptWidget(EntityProperties<class_1308> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 140.0f, 20.0f));
        this.setElementBar(new TemptBar());
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, MobTemptWidget.tooltipTitle("property_widget.biologydictionary.tempt"), MobTemptWidget.tooltipDescription("property_widget.biologydictionary.tempt.desc"));
        return true;
    }

    private final class TemptBar
    extends EntityPropertyBar {
        private float gap;
        private int lastSize;

        public TemptBar() {
            super(Textures.ICONS, 150.0f, 20.0f);
            this.lastSize = 0;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            int i;
            super.onRender(ctx);
            this.renderFullBar(ctx);
            class_5250 text = null;
            List tempts = (List)MobTemptWidget.this.temptProperty.getVal();
            if (tempts == null) {
                text = class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets");
            } else if (tempts.isEmpty()) {
                text = class_2561.method_43471((String)"text.biologydictionary.empty_with_brackets");
            }
            if (text != null) {
                this.renderInnerText(ctx, (class_2561)text, -2012147439);
                return;
            }
            if (this.lastSize != tempts.size()) {
                this.lastSize = tempts.size();
                this.updateGap(this.lastSize);
            }
            for (i = tempts.size() - 1; i >= 0; --i) {
                ctx.renderTexture(Textures.ICONS, 220.0f, 20.0f, ctx.getZ(), this.getBox().getLeft() - 1.0f + (float)i * this.gap, this.getBox().getTop() - 1.0f, 10.0f, 10.0f);
            }
            for (i = tempts.size() - 1; i >= 0; --i) {
                ctx.renderItem((class_1799)tempts.get(i), 0.5f, this.getBox().getLeft() + (float)i * this.gap, this.getBox().getTop());
            }
        }

        @Override
        protected void onResize(int width, int height) {
            super.onResize(width, height);
            List tempts = (List)MobTemptWidget.this.temptProperty.getVal();
            int size = tempts == null ? 0 : tempts.size();
            this.updateGap(size);
        }

        private void updateGap(float size) {
            this.gap = Math.min(9.0f, (this.getBox().getWidth() - 8.0f) / Math.max(1.0f, size - 1.0f));
        }
    }
}

