/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.leaf;

import io.github.xienaoban.biologydictionary.client.HighlightManager;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.CodecProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.BeeClearHiveSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.screen.AbstractBiologyDictionaryScreen;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_4466;

public class BeeHivePropertyWidget
extends EntityPropertyStandardWidget<class_4466> {
    public static final EntityPropertyWidget.Factory<class_4466> FACTORY = BeeHivePropertyWidget::new;
    private static final int L = 1;
    private static final int T = 6;
    private static final float NO_DIS = Float.MIN_VALUE;
    private static final float MAX_DIS = 48.0f;
    private static final float MAX_DIS_LOG = (float)Math.log(48.0);
    private final CodecProperty<class_4466, class_2338> hivePosProperty = VanillaEntityProperties.OfBee.getHivePosProperty(this.p());
    private class_2338 lastHivePos = null;
    private float cachedDistanceToHive = Float.MIN_VALUE;
    private float cachedDisLog = Float.MIN_VALUE;

    public BeeHivePropertyWidget(EntityProperties<class_4466> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 10.0f, 60.0f));
        this.setElementBar(new HiveDistanceBar());
        this.addElementButton(new LocateHiveButton());
        this.addElementButton(new ClearHiveButton());
    }

    private float calcDistToHive() {
        class_2338 hivePos = (class_2338)this.hivePosProperty.getVal();
        if (hivePos == null) {
            return Float.MIN_VALUE;
        }
        class_243 entityPos = ((class_4466)this.e()).method_73189();
        return (float)entityPos.method_1022(hivePos.method_46558());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        if (ticks % ClientUtils.getClientTickCountPerSecond() == 11) {
            this.cachedDistanceToHive = this.calcDistToHive();
            this.cachedDisLog = (float)Math.log(this.cachedDistanceToHive);
        }
    }

    @Override
    protected void onRender(ScreenRenderingContext ctx) {
        super.onRender(ctx);
        class_2338 currHivePos = (class_2338)this.hivePosProperty.getVal();
        if (currHivePos != this.lastHivePos) {
            this.lastHivePos = currHivePos;
            this.cachedDistanceToHive = this.calcDistToHive();
            this.cachedDisLog = (float)Math.log(this.cachedDistanceToHive);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, BeeHivePropertyWidget.tooltipTitle("property_widget.biologydictionary.bee_hive"), BeeHivePropertyWidget.tooltipDescription("property_widget.biologydictionary.bee_hive.desc"));
        return true;
    }

    private final class HiveDistanceBar
    extends EntityPropertyProgressBar {
        public HiveDistanceBar() {
            super(Textures.ICONS, 20.0f, 60.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            if (BeeHivePropertyWidget.this.cachedDistanceToHive == Float.MIN_VALUE) {
                this.updatePercent(0.0f);
                super.onRender(ctx);
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.none_with_brackets"));
                return;
            }
            this.updatePercent(BeeHivePropertyWidget.this.cachedDisLog / MAX_DIS_LOG);
            super.onRender(ctx);
            this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(Misc.format4Digits(BeeHivePropertyWidget.this.cachedDistanceToHive) + "m")));
        }
    }

    private final class LocateHiveButton
    extends EntityPropertyButton {
        public LocateHiveButton() {
            super(Textures.ICONS, 230.0f, 40.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (LocateHiveButton.isMouseLeft(code)) {
                class_2338 currHivePos = (class_2338)BeeHivePropertyWidget.this.hivePosProperty.getVal();
                if (currHivePos == null) {
                    AbstractBiologyDictionaryScreen.current().sendScreenMessage((class_2561)class_2561.method_43471((String)"text.biologydictionary.no_block_to_locate"));
                    return true;
                }
                HighlightManager.highlightBlock(currHivePos, 120);
                ClientUtils.setScreen(null);
            }
            return true;
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            BeeHivePropertyWidget.this.renderTooltip(ctx, new class_2561[]{LocateHiveButton.tooltipTitle("property_widget.biologydictionary.bee_hive.locate"), LocateHiveButton.tooltipDescription("property_widget.biologydictionary.bee_hive.locate.desc")});
            return true;
        }
    }

    private final class ClearHiveButton
    extends EntityPropertyButton {
        public ClearHiveButton() {
            super(Textures.ICONS, 240.0f, 40.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (ClearHiveButton.isMouseLeft(code)) {
                class_2338 currHivePos = (class_2338)BeeHivePropertyWidget.this.hivePosProperty.getVal();
                if (currHivePos == null) {
                    AbstractBiologyDictionaryScreen.current().sendScreenMessage((class_2561)class_2561.method_43471((String)"text.biologydictionary.no_block_to_clear"));
                    return true;
                }
                if (BeeClearHiveSkill.activate((class_4466)BeeHivePropertyWidget.this.e())) {
                    BeeHivePropertyWidget.this.hivePosProperty.setVal(null);
                }
            }
            return true;
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            BeeHivePropertyWidget.this.renderTooltip(ctx, new class_2561[]{ClearHiveButton.tooltipTitle("property_widget.biologydictionary.bee_hive.clear"), ClearHiveButton.tooltipDescription("property_widget.biologydictionary.bee_hive.clear.desc"), ClearHiveButton.tooltipEmpty(), ClearHiveButton.tooltipBody("text.biologydictionary.experience_points_cost", 1)});
            return true;
        }
    }
}

