/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.leaf;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.IntProperty;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.minecraft.class_1433;
import net.minecraft.class_2561;

public class DolphinMoistnessWidget
extends EntityPropertyStandardWidget<class_1433> {
    public static final EntityPropertyWidget.Factory<class_1433> FACTORY = DolphinMoistnessWidget::new;
    private static final int L = 6;
    private static final int T = 2;
    private static final int TOTAL_MOISTNESS_LEVEL = 2400;
    private final IntProperty<class_1433> moistnessProperty = VanillaEntityProperties.OfDolphin.getMoistnessProperty(this.p());

    public DolphinMoistnessWidget(EntityProperties<class_1433> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 60.0f, 20.0f));
        this.setElementBar(new MoistnessBar());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        Integer mL = (Integer)this.moistnessProperty.getVal();
        if (mL == null) {
            return;
        }
        int m = mL;
        if (m > 0 && !((class_1433)this.e()).method_5721() && !((class_1433)this.e()).method_5987()) {
            this.moistnessProperty.setVal(m - 1);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, DolphinMoistnessWidget.tooltipTitle("property_widget.biologydictionary.moistness"), DolphinMoistnessWidget.tooltipDescription("property_widget.biologydictionary.moistness.desc"));
        return true;
    }

    private final class MoistnessBar
    extends EntityPropertyProgressBar {
        public MoistnessBar() {
            super(Textures.ICONS, 70.0f, 20.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer mL = (Integer)DolphinMoistnessWidget.this.moistnessProperty.getVal();
            if (mL == null) {
                this.updatePercent(0.0f);
                super.onRender(ctx);
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
                return;
            }
            int m = mL;
            int mMax = 2400;
            this.updatePercent((float)m / (float)mMax);
            super.onRender(ctx);
            if (ctx.isDebug()) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(m + "t/" + mMax + "t")));
            } else {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(m / 20 + "s/" + mMax / 20 + "s")));
            }
        }
    }
}

