/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.leaf;

import io.github.xienaoban.biologydictionary.client.HighlightManager;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.extra.VillagerJobSiteProperty;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.screen.AbstractBiologyDictionaryScreen;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.minecraft.class_1646;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_4208;

public class VillagerJobSiteWidget
extends EntityPropertyStandardWidget<class_1646> {
    public static final EntityPropertyWidget.Factory<class_1646> FACTORY = VillagerJobSiteWidget::new;
    private static final int L = 1;
    private static final int T = 5;
    private static final float NO_DIS = Float.MIN_VALUE;
    private static final float MAX_DIS = 16.0f;
    private static final float MAX_DIS_LOG = (float)Math.log(16.0);
    private final VillagerJobSiteProperty jobSiteProperty = (VillagerJobSiteProperty)this.p().getExtra(VillagerJobSiteProperty.class);
    private class_4208 lastJobSitePos = null;
    private float cachedDistanceToJobSite = Float.MIN_VALUE;
    private float cachedDisLog = Float.MIN_VALUE;

    public VillagerJobSiteWidget(EntityProperties<class_1646> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 10.0f, 50.0f));
        this.setElementBar(new JobSiteDistanceBar());
        this.addElementButton(new LocateJobSiteButton());
    }

    private float calcDistToJobSite() {
        class_4208 jobSitePos = (class_4208)this.jobSiteProperty.getVal();
        if (jobSitePos == null) {
            return Float.MIN_VALUE;
        }
        if (jobSitePos.comp_2207() != ((class_1646)this.e()).method_73183().method_27983()) {
            return Float.MIN_VALUE;
        }
        class_243 entityPos = ((class_1646)this.e()).method_73189();
        return (float)entityPos.method_1022(jobSitePos.comp_2208().method_46558());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        if (ticks % ClientUtils.getClientTickCountPerSecond() == 11) {
            this.cachedDistanceToJobSite = this.calcDistToJobSite();
            this.cachedDisLog = (float)Math.log(this.cachedDistanceToJobSite);
        }
    }

    @Override
    protected void onRender(ScreenRenderingContext ctx) {
        super.onRender(ctx);
        class_4208 currJobSitePos = (class_4208)this.jobSiteProperty.getVal();
        if (currJobSitePos != this.lastJobSitePos) {
            this.lastJobSitePos = currJobSitePos;
            this.cachedDistanceToJobSite = this.calcDistToJobSite();
            this.cachedDisLog = (float)Math.log(this.cachedDistanceToJobSite);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, VillagerJobSiteWidget.tooltipTitle("property_widget.biologydictionary.job_site"), VillagerJobSiteWidget.tooltipDescription("property_widget.biologydictionary.job_site.desc"));
        return true;
    }

    private final class JobSiteDistanceBar
    extends EntityPropertyProgressBar {
        public JobSiteDistanceBar() {
            super(Textures.ICONS, 20.0f, 50.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            if (VillagerJobSiteWidget.this.cachedDistanceToJobSite == Float.MIN_VALUE) {
                this.updatePercent(0.0f);
                super.onRender(ctx);
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.none_with_brackets"));
                return;
            }
            this.updatePercent(VillagerJobSiteWidget.this.cachedDisLog / MAX_DIS_LOG);
            super.onRender(ctx);
            this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(Misc.format4Digits(VillagerJobSiteWidget.this.cachedDistanceToJobSite) + "m")));
        }
    }

    private final class LocateJobSiteButton
    extends EntityPropertyButton {
        public LocateJobSiteButton() {
            super(Textures.ICONS, 230.0f, 40.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (LocateJobSiteButton.isMouseLeft(code)) {
                class_4208 currJobSitePos = (class_4208)VillagerJobSiteWidget.this.jobSiteProperty.getVal();
                if (currJobSitePos == null) {
                    AbstractBiologyDictionaryScreen.current().sendScreenMessage((class_2561)class_2561.method_43471((String)"text.biologydictionary.no_block_to_locate"));
                    return true;
                }
                HighlightManager.highlightBlock(currJobSitePos.comp_2208(), 120);
                ClientUtils.setScreen(null);
            }
            return true;
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            VillagerJobSiteWidget.this.renderTooltip(ctx, new class_2561[]{LocateJobSiteButton.tooltipTitle("property_widget.biologydictionary.job_site.locate"), LocateJobSiteButton.tooltipDescription("property_widget.biologydictionary.job_site.locate.desc")});
            return true;
        }
    }
}

