/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.leaf;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.IntProperty;
import io.github.xienaoban.biologydictionary.core.property.extra.VillagerJobSiteProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.VillagerForceRestockSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_4208;

public class VillagerRestocksTodayWidget
extends EntityPropertyStandardWidget<class_1646> {
    public static final EntityPropertyWidget.Factory<class_1646> FACTORY = VillagerRestocksTodayWidget::new;
    private static final int L = 6;
    private static final int T = 5;
    private static final int MAX_RESTOCK_TODAY = 2;
    private final IntProperty<class_1646> restocksTodayProperty = VanillaEntityProperties.OfVillager.getRestocksTodayProperty(this.p());

    public VillagerRestocksTodayWidget(EntityProperties<class_1646> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 60.0f, 50.0f));
        this.setElementBar(new RestocksTodayBar());
        this.addElementButton(new RestockNowButton());
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, VillagerRestocksTodayWidget.tooltipTitle("property_widget.biologydictionary.restocks_today"), VillagerRestocksTodayWidget.tooltipDescription("property_widget.biologydictionary.restocks_today.desc"));
        return true;
    }

    private final class RestocksTodayBar
    extends EntityPropertyProgressBar {
        public RestocksTodayBar() {
            super(Textures.ICONS, 70.0f, 50.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer numI = (Integer)VillagerRestocksTodayWidget.this.restocksTodayProperty.getVal();
            if (numI == null) {
                this.updatePercent(0.0f);
                super.onRender(ctx);
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.no_data_with_brackets"));
                return;
            }
            int num = numI;
            this.updatePercent((float)num / 2.0f);
            super.onRender(ctx);
            this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)String.valueOf(num)));
        }
    }

    private final class RestockNowButton
    extends EntityPropertyButton {
        private final class_1799 emerald;

        public RestockNowButton() {
            super(null, -1.0f, -1.0f);
            this.emerald = new class_1799((class_1935)class_1802.field_8687);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (RestockNowButton.isMouseLeft(code)) {
                VillagerJobSiteProperty jboSiteProperty = (VillagerJobSiteProperty)VillagerRestocksTodayWidget.this.p().getExtra(VillagerJobSiteProperty.class);
                Integer r = (Integer)VillagerRestocksTodayWidget.this.restocksTodayProperty.getVal();
                class_4208 j = (class_4208)jboSiteProperty.getVal();
                if (VillagerForceRestockSkill.activate((class_1646)VillagerRestocksTodayWidget.this.e(), r, j)) {
                    VillagerRestocksTodayWidget.this.restocksTodayProperty.setVal(r + 1);
                }
            }
            return true;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer numI = (Integer)VillagerRestocksTodayWidget.this.restocksTodayProperty.getVal();
            Integer price = numI == null ? null : Integer.valueOf(Math.max(0, numI - 3 + 1) * 2);
            this.renderItem(ctx, this.emerald, price);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            VillagerRestocksTodayWidget.this.renderTooltip(ctx, new class_2561[]{RestockNowButton.tooltipTitle("property_widget.biologydictionary.restocks_today.restock"), RestockNowButton.tooltipDescription("property_widget.biologydictionary.restocks_today.restock.desc")});
            return true;
        }
    }
}

