/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.leaf;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyBar;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1646;
import net.minecraft.class_2561;
import net.minecraft.class_3852;
import net.minecraft.class_4168;
import net.minecraft.class_5250;

public final class VillagerScheduleWidget
extends EntityPropertyStandardWidget<class_1646> {
    public static final EntityPropertyWidget.Factory<class_1646> FACTORY = VillagerScheduleWidget::new;
    private static final int L = 11;
    private static final int T = 4;
    private static final int AW = 4;
    private static final int MAX_TIME = 24000;
    private static final int ZERO_TIME = 18000;
    private static final TimelineEntry[] EMPTY = new TimelineEntry[]{new TimelineEntry(0, class_4168.field_18595)};
    private static final TimelineEntry[] SIMPLE = new TimelineEntry[]{new TimelineEntry(5000, class_4168.field_18596), new TimelineEntry(11000, class_4168.field_18597)};
    private static final TimelineEntry[] BABY = new TimelineEntry[]{new TimelineEntry(10, class_4168.field_18595), new TimelineEntry(3000, class_4168.field_18885), new TimelineEntry(6000, class_4168.field_18595), new TimelineEntry(10000, class_4168.field_18885), new TimelineEntry(12000, class_4168.field_18597)};
    private static final TimelineEntry[] ADULT_WITH_JOB = new TimelineEntry[]{new TimelineEntry(10, class_4168.field_18595), new TimelineEntry(2000, class_4168.field_18596), new TimelineEntry(9000, class_4168.field_18598), new TimelineEntry(11000, class_4168.field_18595), new TimelineEntry(12000, class_4168.field_18597)};
    private static final TimelineEntry[] ADULT_WITHOUT_JOB = new TimelineEntry[]{new TimelineEntry(10, class_4168.field_18595), new TimelineEntry(2000, class_4168.field_18595), new TimelineEntry(9000, class_4168.field_18598), new TimelineEntry(11000, class_4168.field_18595), new TimelineEntry(12000, class_4168.field_18597)};
    private static final TimelineEntry[] EMPTY_ZERO = VillagerScheduleWidget.convertZero(EMPTY);
    private static final TimelineEntry[] SIMPLE_ZERO = VillagerScheduleWidget.convertZero(SIMPLE);
    private static final TimelineEntry[] BABY_ZERO = VillagerScheduleWidget.convertZero(BABY);
    private static final TimelineEntry[] ADULT_WITH_JOB_ZERO = VillagerScheduleWidget.convertZero(ADULT_WITH_JOB);
    private static final TimelineEntry[] ADULT_WITHOUT_JOB_ZERO = VillagerScheduleWidget.convertZero(ADULT_WITHOUT_JOB);
    private static final HashMap<class_4168, Integer> textureOffsets = new HashMap();

    private static TimelineEntry[] convertZero(TimelineEntry[] source) {
        return (TimelineEntry[])Arrays.stream(source).map(e -> new TimelineEntry((e.time() + 24000 - 18000) % 24000, e.activity())).sorted(Comparator.comparingInt(TimelineEntry::time)).toArray(TimelineEntry[]::new);
    }

    private static int getTextureOffset(class_4168 activity) {
        return textureOffsets.getOrDefault(activity, 1);
    }

    private static String tickToTime(long ticks) {
        int currTicks = ((int)ticks + 24000 - 18000) % 24000;
        int hour = currTicks / 1000;
        int minute = currTicks % 1000 * 60 / 1000;
        return String.format("%02d:%02d", hour, minute);
    }

    private static String tickZeroToTime(long ticks) {
        int currTicks = (int)ticks;
        int hour = currTicks / 1000;
        int minute = currTicks % 1000 * 60 / 1000;
        return String.format("%02d:%02d", hour, minute);
    }

    public VillagerScheduleWidget(EntityProperties<class_1646> properties) {
        super(properties, 8);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 110.0f, 40.0f));
        this.setElementBar(new ScheduleBar());
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, VillagerScheduleWidget.tooltipTitle("property_widget.biologydictionary.schedule"), VillagerScheduleWidget.tooltipDescription("property_widget.biologydictionary.schedule.desc"));
        return true;
    }

    private TimelineEntry[] getTimelineEntries() {
        TimelineEntry[] timeline = ((class_1646)this.e()).method_6109() ? BABY_ZERO : (Objects.equals(class_3852.field_17051, ((class_1646)this.e()).method_7231().comp_3521().method_40230().orElse(class_3852.field_17051)) ? ADULT_WITHOUT_JOB_ZERO : ADULT_WITH_JOB_ZERO);
        return timeline;
    }

    static {
        textureOffsets.put(class_4168.field_18595, 0);
        textureOffsets.put(class_4168.field_18596, 4);
        textureOffsets.put(class_4168.field_18885, 8);
        textureOffsets.put(class_4168.field_18598, 12);
        textureOffsets.put(class_4168.field_18597, 16);
    }

    private record TimelineEntry(int time, class_4168 activity) {
    }

    private final class ScheduleBar
    extends EntityPropertyBar {
        public ScheduleBar() {
            super(Textures.ICONS, 120.0f, 40.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            float currTime = Objects.requireNonNull(ctx.getClient().field_1687).method_8532();
            float currTimeZero = (currTime + 24000.0f - 18000.0f) % 24000.0f;
            TimelineEntry[] timeline = VillagerScheduleWidget.this.getTimelineEntries();
            float scale = (this.getBox().getWidth() - 2.0f) / 24000.0f;
            int t = 0;
            class_4168 activity = timeline[timeline.length - 1].activity();
            ctx.renderTexture(this.getTexture(), this.getTextureLeft() + (float)VillagerScheduleWidget.getTextureOffset(activity), this.getTextureTop() + 1.0f, ctx.getZ(), this.getBox().getLeft(), this.getBox().getTop() + 1.0f, 1.0f, this.getBox().getHeight() - 2.0f);
            float hoveredTextLeft = -1.0f;
            int hoveredIdxNext = -1;
            int currTimeIdxCurr = timeline.length - 1;
            for (int i = 0; i < timeline.length; ++i) {
                float tl;
                TimelineEntry entry = timeline[i];
                if (currTimeZero >= (float)entry.time()) {
                    currTimeIdxCurr = i;
                }
                if ((tl = this.renderTimelineEntry(ctx, (float)t * scale, (float)(entry.time() - t) * scale, activity)) > 0.0f) {
                    hoveredTextLeft = tl;
                    hoveredIdxNext = i;
                }
                t = entry.time();
                activity = entry.activity();
            }
            float tl = this.renderTimelineEntry(ctx, (float)t * scale, (float)(24000 - t) * scale, activity);
            if (tl > 0.0f) {
                hoveredTextLeft = tl;
                hoveredIdxNext = 0;
            }
            ctx.renderTexture(this.getTexture(), this.getTextureLeft() + (float)VillagerScheduleWidget.getTextureOffset(activity) + 4.0f - 1.0f, this.getTextureTop() + 1.0f, ctx.getZ(), this.getBox().getRight() - 1.0f, this.getBox().getTop() + 1.0f, 1.0f, this.getBox().getHeight() - 2.0f);
            ctx.renderTexture(this.getTexture(), 220.0f, 30.0f, ctx.getZ(), this.getBox().getLeft() + 1.0f + (currTime + 24000.0f - 18000.0f) % 24000.0f * scale - 5.0f + 1.0f, this.getBox().getTop() - 1.0f, 10.0f, 10.0f);
            if (hoveredIdxNext < 0) {
                this.renderText(ctx, timeline, (currTimeIdxCurr + 1) % timeline.length, this.getBox().getLeft() + 1.0f);
            } else {
                this.renderText(ctx, timeline, hoveredIdxNext, hoveredTextLeft);
            }
        }

        private float renderTimelineEntry(ScreenRenderingContext ctx, float left, float width, class_4168 activity) {
            float textureOffset = VillagerScheduleWidget.getTextureOffset(activity);
            float textureLeft = this.getTextureLeft() + textureOffset;
            float offset = this.getBox().getLeft() + 1.0f;
            float top = this.getBox().getTop() - 1.0f;
            float height = this.getBox().getHeight() + 2.0f;
            float right = left + width;
            float currLeft = offset + left;
            float leftMod = left % 4.0f;
            if (leftMod > 0.0f) {
                float w = Math.min(width, 4.0f - leftMod);
                ctx.renderTexture(this.getTexture(), textureLeft + leftMod, this.getTextureTop(), ctx.getZ(), currLeft, top, w, height);
                currLeft += w;
            }
            float rightMod = right % 4.0f;
            float rightNoMod = offset + right - rightMod;
            while (currLeft < rightNoMod) {
                ctx.renderTexture(this.getTexture(), textureLeft, this.getTextureTop(), ctx.getZ(), currLeft, top, 4.0f, height);
                currLeft += 4.0f;
            }
            if (rightMod > 0.0f) {
                ctx.renderTexture(this.getTexture(), textureLeft, this.getTextureTop(), ctx.getZ(), currLeft, top, rightMod, height);
            }
            if (ctx.getMouseX() >= offset + left && ctx.getMouseX() < offset + right && ctx.getMouseY() >= top && ctx.getMouseY() <= top + height) {
                return offset + left;
            }
            return -1.0f;
        }

        private void renderText(ScreenRenderingContext ctx, TimelineEntry[] timeline, int idx, float left) {
            int last = (idx + timeline.length - 1) % timeline.length;
            class_5250 txt1 = class_2561.method_43471((String)("activity.minecraft." + timeline[last].activity().method_19634()));
            int w1 = ctx.calcTextWidth((class_2561)txt1) / 2;
            String str2 = ctx.isDebug() ? (timeline[last].time() + 18000) % 24000 + "-" + (timeline[idx].time() + 18000) % 24000 : VillagerScheduleWidget.tickZeroToTime(timeline[last].time()) + "-" + VillagerScheduleWidget.tickZeroToTime(timeline[idx].time());
            class_5250 txt2 = class_2561.method_43470((String)str2);
            int w2 = ctx.calcTextWidth((class_2561)txt2) / 2;
            int w = w1 + w2 + 1;
            float l1 = left + 1.0f;
            float l2 = this.getBox().getRight() - 2.0f - (float)w;
            if (l1 < l2) {
                ctx.renderText((class_2561)txt1, -1157627904, 0.5f, ctx.getZ(), l1, this.getBox().getTop() + 2.25f);
                ctx.renderText((class_2561)txt2, -1157627904, 0.5f, ctx.getZ(), l1 + (float)w1 + 1.0f, this.getBox().getTop() + 2.5f);
            } else {
                ctx.renderText((class_2561)txt1, -1157627904, 0.5f, ctx.getZ(), l2, this.getBox().getTop() + 2.25f);
                ctx.renderText((class_2561)txt2, -1157627904, 0.5f, ctx.getZ(), l2 + (float)w1 + 1.0f, this.getBox().getTop() + 2.5f);
            }
        }
    }
}

