/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.leaf;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.core.property.VanillaEntityProperties;
import io.github.xienaoban.biologydictionary.core.property.builtin.IntProperty;
import io.github.xienaoban.biologydictionary.core.skill.entity.WanderingTraderRetainSkill;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyStandardWidget;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyButton;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyIcon;
import io.github.xienaoban.biologydictionary.gui.component.control.EntityPropertyProgressBar;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3989;

public class WanderingTraderDespawnDelayWidget
extends EntityPropertyStandardWidget<class_3989> {
    public static final EntityPropertyWidget.Factory<class_3989> FACTORY = WanderingTraderDespawnDelayWidget::new;
    private static final int L = 6;
    private static final int T = 6;
    private static final int MAX_DESPAWN_DELAY = 48000;
    private final IntProperty<class_3989> despawnDelayProperty = VanillaEntityProperties.OfWanderingTrader.getDespawnDelayProperty(this.p());

    public WanderingTraderDespawnDelayWidget(EntityProperties<class_3989> properties) {
        super(properties);
        this.setElementIcon(new EntityPropertyIcon(Textures.ICONS, 60.0f, 60.0f));
        this.setElementBar(new DespawnDelayBar());
        this.addElementButton(new RetainButton());
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        Integer delayI = (Integer)this.despawnDelayProperty.getVal();
        if (delayI == null) {
            return;
        }
        int delay = delayI;
        if (delay > 0) {
            this.despawnDelayProperty.setVal(delay - 1);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, WanderingTraderDespawnDelayWidget.tooltipTitle("property_widget.biologydictionary.despawn_delay"), WanderingTraderDespawnDelayWidget.tooltipDescription("property_widget.biologydictionary.despawn_delay.desc"));
        return true;
    }

    private final class DespawnDelayBar
    extends EntityPropertyProgressBar {
        public DespawnDelayBar() {
            super(Textures.ICONS, 70.0f, 60.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            Integer delayI = (Integer)WanderingTraderDespawnDelayWidget.this.despawnDelayProperty.getVal();
            if (delayI == null) {
                this.updatePercent(0.0f);
                super.onRender(ctx);
                this.renderInnerText(ctx, (class_2561)class_2561.method_43471((String)"text.biologydictionary.empty_with_brackets"), -2012147439);
                return;
            }
            int delay = delayI;
            this.updatePercent((float)delay / 48000.0f);
            super.onRender(ctx);
            if (ctx.isDebug()) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(delay + "t/48000t")));
            } else if (delay == 0) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)"\u221e/40min"));
            } else if (delay < 3600) {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(delay / 20 + "s/40min")));
            } else {
                this.renderInnerText(ctx, (class_2561)class_2561.method_43470((String)(delay / 20 / 60 + "min/40min")));
            }
        }
    }

    private final class RetainButton
    extends EntityPropertyButton {
        private final class_1799 waterBucket;

        public RetainButton() {
            super(null, -1.0f, -1.0f);
            this.waterBucket = new class_1799((class_1935)class_1802.field_8705);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (RetainButton.isMouseLeft(code) && WanderingTraderRetainSkill.activate(WanderingTraderDespawnDelayWidget.this.e())) {
                WanderingTraderDespawnDelayWidget.this.despawnDelayProperty.setVal((Integer)WanderingTraderDespawnDelayWidget.this.despawnDelayProperty.getVal() + 2400);
            }
            return true;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            this.renderItem(ctx, this.waterBucket, 1);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            WanderingTraderDespawnDelayWidget.this.renderTooltip(ctx, new class_2561[]{RetainButton.tooltipTitle("property_widget.biologydictionary.despawn_delay.retain"), RetainButton.tooltipDescription("property_widget.biologydictionary.despawn_delay.retain.desc")});
            return true;
        }
    }
}

