/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.core.widget.variant;

import io.github.xienaoban.biologydictionary.common.gui.TextureInfo;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElement;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElementBox;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.core.property.EntityProperties;
import io.github.xienaoban.biologydictionary.gui.component.EntityPropertyWidget;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractEntityVariantWidget<E extends class_1297, V>
extends EntityPropertyWidget<E> {
    protected static final int BG_BAR1_LEFT = 11;
    protected static final int BG_BAR1_TOP = 24;
    protected static final int BG_BAR2_LEFT = 13;
    protected static final int BG_BAR2_TOP = 24;
    private final int size;
    private final List<VariantElement> variantElements;
    private final int[] displayCntPerRow;
    private final float variantWidth;
    private final float variantHeight;
    private int chosenIndex;
    private final List<BackgroundBar> backgroundBars = new ArrayList<BackgroundBar>();
    private final class_746 player = Objects.requireNonNull(ClientUtils.getClientPlayer());

    private static EntityPropertyWidget.RC calcRowsAndColumns(int variantCnt, int maxDisplayCntPerLine, int rowsPerVariant) {
        int rows = rowsPerVariant * ((variantCnt + maxDisplayCntPerLine - 1) / maxDisplayCntPerLine);
        int cols = variantCnt <= maxDisplayCntPerLine / 2 ? 4 : 8;
        return new EntityPropertyWidget.RC(rows, cols);
    }

    public AbstractEntityVariantWidget(EntityProperties<E> properties, int variantCnt) {
        this(properties, variantCnt, 7, 2);
    }

    public AbstractEntityVariantWidget(EntityProperties<E> properties, int variantCnt, int maxDisplayCntPerLine, int rowsPerVariant) {
        super(properties, AbstractEntityVariantWidget.calcRowsAndColumns(variantCnt, maxDisplayCntPerLine, rowsPerVariant));
        this.size = variantCnt;
        List<V> variants = this.getAllVariants();
        if (variantCnt != variants.size()) {
            throw new RuntimeException("mismatch");
        }
        int lines = (variantCnt + maxDisplayCntPerLine - 1) / maxDisplayCntPerLine;
        int minCnt = variantCnt / lines;
        int mod = variantCnt % lines;
        this.displayCntPerRow = new int[lines];
        int i = 0;
        while (i < lines) {
            this.displayCntPerRow[i] = minCnt + (mod > 0 ? 1 : 0);
            ++i;
            --mod;
        }
        this.variantWidth = this.getBox().getWidth() / (float)this.displayCntPerRow[0] - 1.0f;
        this.variantHeight = this.getBox().getHeight() / (float)lines - 1.0f;
        this.variantElements = new ArrayList<VariantElement>(this.size());
        for (i = 0; i < this.size(); ++i) {
            VariantElement e = new VariantElement(i, variants.get(i));
            e.setParent(this);
            this.variantElements.add(e);
        }
        this.chosenIndex = 0;
        this.checkChosenVariant();
    }

    protected abstract List<V> getAllVariants();

    protected abstract V getVariantClient(E var1);

    protected abstract void setVariantClient(E var1, V var2);

    protected abstract class_2561 getVariantName(V var1);

    protected abstract boolean activeSkill(V var1);

    protected boolean isAllowedToChoose() {
        return this.player.method_68878();
    }

    protected boolean equals(V v1, V v2) {
        return Objects.equals(v1, v2);
    }

    public final int size() {
        return this.size;
    }

    public final int getChosenIndex() {
        return this.chosenIndex;
    }

    public final V getChosenVariant() {
        return this.variantElements.get((int)this.chosenIndex).variant;
    }

    public final boolean isChosen(int variantIndex) {
        return variantIndex == this.getChosenIndex();
    }

    public final boolean isChosen(V variant) {
        return this.equals(variant, this.getChosenVariant());
    }

    public final String getVariantNameKeyPrefix() {
        class_2960 id = EntityUtils.getEntityTypeId(this.e());
        return "variant." + id.method_12836() + "." + id.method_12832() + ".";
    }

    protected final void setVariantElementWidthFix(float widthFix) {
        for (VariantElement ve : this.variantElements) {
            ve.setWidthFix(widthFix);
        }
    }

    protected final void setVariantElementHeightFix(float heightFix) {
        for (VariantElement ve : this.variantElements) {
            ve.setHeightFix(heightFix);
        }
    }

    protected final void setBackgroundBars(TextureInfo texture, int textureLeft, int textureTop) {
        for (BackgroundBar bar : this.backgroundBars) {
            bar.setParent(null);
        }
        this.backgroundBars.clear();
        for (int i = 0; i < this.displayCntPerRow.length; ++i) {
            BackgroundBar bar;
            bar = new BackgroundBar(texture, textureLeft, textureTop);
            bar.getBox().setSize(this.getBox().getWidth(), 10.0f);
            bar.setPriority(-1.0f);
            bar.setParent(this);
            this.backgroundBars.add(bar);
        }
    }

    private void checkChosenVariant() {
        V last;
        V curr = this.getVariantClient(this.e());
        if (this.equals(curr, last = this.getChosenVariant())) {
            return;
        }
        this.chosenIndex = this.getVariantIndex(curr);
    }

    private int getVariantIndex(V variant) {
        int idx = 0;
        boolean hit = false;
        for (int i = 0; i < this.size; ++i) {
            if (!this.equals(variant, this.variantElements.get((int)i).variant)) continue;
            if (hit) {
                throw new RuntimeException("Multiple hit variants!");
            }
            hit = true;
            idx = i;
        }
        return idx;
    }

    @Override
    protected void onTick(int ticks) {
        super.onTick(ticks);
        if (ticks % 10 == 5) {
            this.checkChosenVariant();
        }
    }

    @Override
    protected void onResize(int width, int height) {
        super.onResize(width, height);
        float wWidth = this.getBox().getWidth();
        float wHeight = this.getBox().getHeight();
        float wLeft = this.getBox().getLeft();
        float wTop = this.getBox().getTop();
        int lines = this.displayCntPerRow.length;
        float mHeight = wHeight / (float)lines;
        int vIdx = 0;
        for (int i = 0; i < lines; ++i) {
            float top = wTop + (float)i * mHeight + mHeight / 2.0f - this.variantHeight / 2.0f;
            int cnt = this.displayCntPerRow[i];
            float mWidth = wWidth / (float)cnt;
            for (int j = 0; j < cnt; ++j) {
                float left = wLeft + (float)j * mWidth + mWidth / 2.0f - this.variantWidth / 2.0f;
                this.variantElements.get(vIdx).getBox().setPosition(left, top);
                ++vIdx;
            }
            if (i >= this.backgroundBars.size()) continue;
            BackgroundBar bar = this.backgroundBars.get(i);
            ScreenElementBox box = bar.getBox();
            box.setPosition(wLeft, top + 3.0f);
        }
    }

    @Override
    protected boolean onRenderHovered(ScreenRenderingContext ctx) {
        this.renderTooltip(ctx, AbstractEntityVariantWidget.tooltipTitle("property_widget.biologydictionary.variant"), AbstractEntityVariantWidget.tooltipDescription("property_widget.biologydictionary.variant.desc"));
        return true;
    }

    public final class VariantElement
    extends ScreenElement {
        private static final float FONT_SIZE = 0.5f;
        private final int index;
        private final V variant;
        private final E model;
        private final class_2561 name;
        private float nameWidth = -1.0f;
        private float widthFix;
        private float heightFix;
        private final ScreenRenderingContext.EntityRenderingCache entityRenderingCache = new ScreenRenderingContext.EntityRenderingCache();

        public VariantElement(int index, V variant) {
            this.index = index;
            this.variant = variant;
            this.model = EntityUtils.create(EntityUtils.getEntityType(AbstractEntityVariantWidget.this.e()), AbstractEntityVariantWidget.this.e().method_73183());
            this.model.method_36456(0.0f);
            this.model.method_5847(0.0f);
            this.model.method_5636(0.0f);
            AbstractEntityVariantWidget.this.setVariantClient(this.model, variant);
            this.name = AbstractEntityVariantWidget.this.getVariantName(variant);
            this.getBox().setSize(AbstractEntityVariantWidget.this.variantWidth, AbstractEntityVariantWidget.this.variantHeight);
        }

        public int getIndex() {
            return this.index;
        }

        public V getVariant() {
            return this.variant;
        }

        public E getModel() {
            return this.model;
        }

        public void setWidthFix(float widthFix) {
            this.widthFix = widthFix;
        }

        public void setHeightFix(float heightFix) {
            this.heightFix = heightFix;
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (VariantElement.isMouseLeft(code) && AbstractEntityVariantWidget.this.isAllowedToChoose() && AbstractEntityVariantWidget.this.activeSkill(this.getVariant())) {
                AbstractEntityVariantWidget.this.chosenIndex = this.index;
                Object m = AbstractEntityVariantWidget.this.p().getModel();
                if (m != null) {
                    AbstractEntityVariantWidget.this.p().setNoUpdateCooldown();
                    AbstractEntityVariantWidget.this.setVariantClient(m, AbstractEntityVariantWidget.this.getChosenVariant());
                }
            }
            return super.onMouseDown(x, y, code);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            if (this.nameWidth == -1.0f) {
                this.nameWidth = (float)ctx.calcTextWidth(this.name) * 0.5f;
            }
            this.renderEntity(ctx);
            if (AbstractEntityVariantWidget.this.isChosen(this.index)) {
                this.renderCheckMark(ctx, true);
                if (this.isInBox(ctx.getElementScreen().getHoveredElement())) {
                    this.renderVariantName(ctx);
                } else {
                    this.renderVariantNameAuto(ctx);
                }
            } else if (this.isInBox(ctx.getElementScreen().getHoveredElement())) {
                if (AbstractEntityVariantWidget.this.isAllowedToChoose()) {
                    this.renderCheckMark(ctx, false);
                }
                this.renderVariantName(ctx);
            } else {
                this.renderVariantNameAuto(ctx);
            }
        }

        private void renderCheckMark(ScreenRenderingContext ctx, boolean chosenTrueHoveredFalse) {
            int textureLeft = chosenTrueHoveredFalse ? 23 : 24;
            ctx.renderTexture(Textures.ICONS, textureLeft * 10, 30.0f, ctx.getZ() + 100.0f, (this.getBox().getLeft() + this.getBox().getRight() - 10.0f) / 2.0f, this.getBox().getBottom() - 7.0f - 10.0f, 10.0f, 10.0f);
        }

        private void renderVariantNameAuto(ScreenRenderingContext ctx) {
            if (this.nameWidth > this.getBox().getWidth()) {
                this.renderEllipsis(ctx);
            } else {
                this.renderVariantName(ctx);
            }
        }

        private void renderVariantName(ScreenRenderingContext ctx) {
            this.renderTheText(ctx, this.name);
        }

        private void renderEllipsis(ScreenRenderingContext ctx) {
            this.renderTheText(ctx, (class_2561)class_2561.method_43470((String)"..."));
        }

        private void renderTheText(ScreenRenderingContext ctx, class_2561 text) {
            ctx.renderCenteredText(text, -1157627904, 0.5f, ctx.getZ(), (this.getBox().getLeft() + this.getBox().getRight()) / 2.0f, this.getBox().getBottom() - 5.0f);
        }

        private void renderEntity(ScreenRenderingContext ctx) {
            ctx.renderEntityCentered((class_1297)this.model, this.entityRenderingCache, this.getBox().getLeft() - 1.0f - this.widthFix / 2.0f, this.getBox().getTop() + 1.0f - this.heightFix, this.getBox().getRight() + 1.0f + this.widthFix / 2.0f, this.getBox().getBottom() - 6.0f, 0.0f, 0.3f, 1.0f);
        }
    }

    private static class BackgroundBar
    extends ScreenElement {
        private final TextureInfo texture;
        private final int textureLeft;
        private final int textureTop;

        public BackgroundBar(TextureInfo texture, int textureLeft, int textureTop) {
            super(false, false);
            this.texture = texture;
            this.textureLeft = textureLeft;
            this.textureTop = textureTop;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            float widthMid;
            super.onRender(ctx);
            float currPos = 0.0f;
            float widthLeft = 5.0f;
            ctx.renderTexture(this.texture, this.textureLeft, this.textureTop, ctx.getZ(), this.getBox().getLeft(), this.getBox().getTop(), widthLeft, this.getBox().getHeight());
            currPos += widthLeft;
            for (widthMid = this.getBox().getWidth() - 10.0f; widthMid > 10.0f; widthMid -= 10.0f) {
                ctx.renderTexture(this.texture, this.textureLeft + 5, this.textureTop, ctx.getZ(), this.getBox().getLeft() + currPos, this.getBox().getTop(), 10.0f, this.getBox().getHeight());
                currPos += 10.0f;
            }
            ctx.renderTexture(this.texture, this.textureLeft + 5, this.textureTop, ctx.getZ(), this.getBox().getLeft() + currPos, this.getBox().getTop(), widthMid, this.getBox().getHeight());
            float widthRight = 5.0f;
            ctx.renderTexture(this.texture, this.textureLeft + 15, this.textureTop, ctx.getZ(), this.getBox().getLeft() + (currPos += widthMid), this.getBox().getTop(), widthRight, this.getBox().getHeight());
        }
    }
}

