/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.component;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElement;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import net.minecraft.class_2561;

public class CenteredMessage
extends ScreenElement {
    private class_2561 text = null;
    private int colorNoAlpha = 0;
    private long endTime = -1L;

    private static int alpha(long curr, long end) {
        long beginFade = end - 2000L;
        if (curr <= beginFade) {
            return 255;
        }
        return 255 * (int)(end - curr) / 2000;
    }

    public CenteredMessage() {
        this.setHoverable(true);
        this.setSelectable(false);
    }

    public void setText(class_2561 text) {
        this.setText(text, 0xFFFF00);
    }

    public void setText(class_2561 text, int color) {
        this.text = text;
        this.colorNoAlpha = color;
        this.endTime = System.currentTimeMillis() + 5000L;
    }

    @Override
    protected void onRender(ScreenRenderingContext ctx) {
        super.onRender(ctx);
        if (this.text == null) {
            return;
        }
        long currTime = System.currentTimeMillis();
        if (currTime > this.endTime) {
            this.text = null;
            return;
        }
        if (this.isHovered(ctx.getMouseX(), ctx.getMouseY())) {
            this.endTime = Math.max(this.endTime, currTime + 3000L);
        }
        int color = this.colorNoAlpha | CenteredMessage.alpha(currTime, this.endTime) << 24;
        ctx.renderCenteredText(this.text, color, ctx.getZ(), (this.getBox().getLeft() + this.getBox().getRight()) / 2.0f, (this.getBox().getTop() + this.getBox().getBottom()) / 2.0f - 5.0f);
    }

    @Override
    protected void onResize(int width, int height) {
        super.onResize(width, height);
    }
}

