/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.component;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElement;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.gui.component.Widget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class Page
extends ScreenElement {
    public static final int ROWS = 9;
    public static final int COLUMNS = 8;
    public static final int PAGE_WIDTH = Widget.calcWidth(8);
    public static final int PAGE_HEIGHT = Widget.calcHeight(9);
    private final Widget[][] widgetLayout = new Widget[9][8];

    public Page() {
        super(false);
        this.getBox().setSize(PAGE_WIDTH, PAGE_HEIGHT);
    }

    @Override
    protected void onRender(ScreenRenderingContext ctx) {
    }

    @Override
    protected void onResize(int width, int height) {
        super.onResize(width, height);
        for (int r = 0; r < 9; ++r) {
            for (int c = 0; c < 8; ++c) {
                Widget widget = this.widgetLayout[r][c];
                if (widget == null || widget instanceof WidgetPlaceholder) continue;
                float left = this.getBox().getLeft() + (float)(14 * c);
                float top = this.getBox().getTop() + (float)(16 * r);
                widget.getBox().setPosition(left, top);
            }
        }
    }

    public boolean hasWidget(int row, int col) {
        return this.widgetLayout[row][col] != null;
    }

    public Widget getWidget(int row, int col) {
        if (!this.hasWidget(row, col)) {
            return null;
        }
        Widget widget = this.widgetLayout[row][col];
        if (widget instanceof WidgetPlaceholder) {
            WidgetPlaceholder placeholder = (WidgetPlaceholder)widget;
            widget = this.widgetLayout[placeholder.getHolderRow()][placeholder.getHolderCol()];
        }
        return widget;
    }

    public boolean addWidget(Widget widget) {
        for (int r = 0; r < 9; ++r) {
            for (int c = 0; c < 8; c += widget.getColumns()) {
                if (this.hasWidget(r, c) || !this.setWidget(widget, r, c)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean setWidget(Widget widget, int row, int col) {
        int rowEnd = row + widget.getRows();
        int colEnd = col + widget.getColumns();
        if (rowEnd > 9 || colEnd > 8) {
            return false;
        }
        for (int r = row; r < rowEnd; ++r) {
            for (int c = col; c < colEnd; ++c) {
                if (!this.hasWidget(r, c)) continue;
                return false;
            }
        }
        if (widget.getRows() * widget.getColumns() > 1) {
            WidgetPlaceholder placeholder = new WidgetPlaceholder(row, col);
            for (int r = row; r < rowEnd; ++r) {
                for (int c = col; c < colEnd; ++c) {
                    this.widgetLayout[r][c] = placeholder;
                }
            }
        }
        this.widgetLayout[row][col] = widget;
        widget.setParent(this);
        return true;
    }

    private static final class WidgetPlaceholder
    extends Widget {
        private final int holderRow;
        private final int holderCol;

        public WidgetPlaceholder(int holderRow, int holderCol) {
            super(1, 1);
            this.holderRow = holderRow;
            this.holderCol = holderCol;
            this.setSelectable(false);
        }

        public int getHolderRow() {
            return this.holderRow;
        }

        public int getHolderCol() {
            return this.holderCol;
        }
    }
}

