/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.component.control;

import io.github.xienaoban.biologydictionary.common.gui.TextureInfo;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElement;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import net.minecraft.class_2561;

public class EntityPropertyBar
extends ScreenElement {
    private final TextureInfo texture;
    private final float textureLeft;
    private final float textureTop;

    public EntityPropertyBar(TextureInfo texture, float textureLeft, float textureTop) {
        this.texture = texture;
        this.textureLeft = textureLeft;
        this.textureTop = textureTop;
        this.getBox().setSize(20.0f, 8.0f);
        this.setSelectable(false);
    }

    public TextureInfo getTexture() {
        return this.texture;
    }

    public float getTextureLeft() {
        return this.textureLeft;
    }

    public float getTextureTop() {
        return this.textureTop;
    }

    @Override
    protected void onResize(int width, int height) {
        super.onResize(width, height);
    }

    protected void renderFullBar(ScreenRenderingContext ctx) {
        float widthMid;
        float currPos = 0.0f;
        float widthLeft = 5.0f;
        float top = this.getBox().getTop() - 1.0f;
        float height = this.getBox().getHeight() + 2.0f;
        ctx.renderTexture(this.texture, this.textureLeft, this.textureTop, ctx.getZ(), this.getBox().getLeft() - 1.0f, top, widthLeft + 1.0f, height);
        currPos += widthLeft;
        for (widthMid = this.getBox().getWidth() - 10.0f; widthMid > 8.0f; widthMid -= 8.0f) {
            ctx.renderTexture(this.texture, this.textureLeft + 6.0f, this.textureTop, ctx.getZ(), this.getBox().getLeft() + currPos, top, 8.0f, height);
            currPos += 8.0f;
        }
        ctx.renderTexture(this.texture, this.textureLeft + 6.0f, this.textureTop, ctx.getZ(), this.getBox().getLeft() + currPos, top, widthMid, height);
        float widthRight = 5.0f;
        ctx.renderTexture(this.texture, this.textureLeft + 14.0f, this.textureTop, ctx.getZ(), this.getBox().getLeft() + (currPos += widthMid), top, widthRight + 1.0f, height);
    }

    protected void renderProgressBar(ScreenRenderingContext ctx, float percent) {
        float widthMid;
        if (percent <= 0.0f) {
            return;
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        float top = this.getBox().getTop() - 1.0f;
        float width = percent * this.getBox().getWidth();
        float height = this.getBox().getHeight() + 2.0f;
        float currPos = 0.0f;
        float widthLeft = Math.min(width, 5.0f);
        float textureLeft = this.textureLeft + 20.0f;
        ctx.renderTexture(this.texture, textureLeft, this.textureTop, ctx.getZ(), this.getBox().getLeft() - 1.0f, top, widthLeft + 1.0f, height);
        if ((currPos += widthLeft) == width) {
            return;
        }
        for (widthMid = Math.min(width - 5.0f, this.getBox().getWidth() - 10.0f); widthMid > 8.0f; widthMid -= 8.0f) {
            ctx.renderTexture(this.texture, textureLeft + 6.0f, this.textureTop, ctx.getZ(), this.getBox().getLeft() + currPos, top, 8.0f, height);
            currPos += 8.0f;
        }
        ctx.renderTexture(this.texture, textureLeft + 6.0f, this.textureTop, ctx.getZ(), this.getBox().getLeft() + currPos, top, widthMid, height);
        if ((currPos += widthMid) == width) {
            return;
        }
        float widthRight = width - (this.getBox().getWidth() - 5.0f);
        ctx.renderTexture(this.texture, textureLeft + 14.0f, this.textureTop, ctx.getZ(), this.getBox().getLeft() + currPos, top, widthRight + (float)((int)percent), height);
    }

    protected void renderInnerText(ScreenRenderingContext ctx, class_2561 text) {
        this.renderInnerText(ctx, text, -1140850689);
    }

    protected void renderInnerText(ScreenRenderingContext ctx, class_2561 text, int color) {
        ctx.renderText(text, color, 0.5f, ctx.getZ(), this.getBox().getLeft() + 3.0f, this.getBox().getTop() + 2.25f);
    }
}

