/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.screen;

import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.client.KeyMappingManager;
import io.github.xienaoban.biologydictionary.common.gui.screen.ElementScreen;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElement;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElementBox;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.core.EntityManager;
import io.github.xienaoban.biologydictionary.core.widget.TurnPageTriggerWidget;
import io.github.xienaoban.biologydictionary.gui.component.CenteredMessage;
import io.github.xienaoban.biologydictionary.gui.component.Page;
import io.github.xienaoban.biologydictionary.gui.component.Widget;
import io.github.xienaoban.biologydictionary.gui.screen.BdAboutScreen;
import io.github.xienaoban.biologydictionary.gui.screen.BdConfigScreen;
import io.github.xienaoban.biologydictionary.gui.screen.BdHomeScreen;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractBiologyDictionaryScreen
extends ElementScreen {
    public static final int BOOK_TEXTURE_LEFT = 96;
    public static final int BOOK_TEXTURE_TOP = 0;
    public static final int BOOK_TEXTURE_RIGHT = 416;
    public static final int BOOK_TEXTURE_BOTTOM = 224;
    public static final int BOOK_TEXTURE_WIDTH = 320;
    public static final int BOOK_TEXTURE_HEIGHT = 224;
    public static final int BOOK_WIDTH = 320;
    public static final int BOOK_HEIGHT = 192;
    private static final int PAGE_MID_MARGIN = 12;
    private static final int PAGE_TOP_MARGIN = 28;
    protected final class_310 client = Objects.requireNonNull(ClientUtils.getClient());
    protected final class_746 player;
    private final Bookmark[] bookmarks;
    private final List<Page> pages;
    private int currPageIndex;
    private Page currLeftPage;
    private Page currRightPage;
    private final PageNum leftPageNum;
    private final PageNum rightPageNum;
    private final PageTurnButton turnLeft;
    private final PageTurnButton turnRight;
    private final CenteredMessage centeredMessage;

    public static AbstractBiologyDictionaryScreen current() {
        return (AbstractBiologyDictionaryScreen)((Object)ClientUtils.getCurrentScreen());
    }

    public static AbstractBiologyDictionaryScreen current(class_310 client) {
        return (AbstractBiologyDictionaryScreen)((Object)ClientUtils.getCurrentScreen(client));
    }

    public AbstractBiologyDictionaryScreen(class_2561 title) {
        super(title);
        this.player = Objects.requireNonNull(this.client.field_1724);
        this.bookmarks = new Bookmark[10];
        this.pages = new ArrayList<Page>();
        this.currPageIndex = 0;
        this.currLeftPage = null;
        this.currRightPage = null;
        this.leftPageNum = new PageNum(false);
        this.rightPageNum = new PageNum(true);
        this.turnLeft = new PageTurnButton(-2);
        this.turnRight = new PageTurnButton(2);
        this.centeredMessage = new CenteredMessage();
        this.check();
        this.leftPageNum.setParent(this.getRootScreenElement());
        this.rightPageNum.setParent(this.getRootScreenElement());
        this.turnLeft.setParent(this.getRootScreenElement());
        this.turnRight.setParent(this.getRootScreenElement());
        this.centeredMessage.setParent(this.getRootScreenElement());
    }

    private void check() {
        if (EntityManager.getInstance() == null) {
            ClientUtils.sendTextBoxMessage((class_2561)class_2561.method_43470((String)"Failed to init EntityManager??").method_27692(class_124.field_1061));
            throw new RuntimeException("Failed to init EntityManager??");
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.client != this.field_22787) {
            throw new AssertionError((Object)"this.minecraft != super.minecraft");
        }
    }

    @Override
    protected void render(ScreenRenderingContext ctx) {
        this.renderTransparentBackground(ctx);
        ctx.renderTexture(Textures.BOOK, 96.0f, 0.0f, 416.0f, 224.0f, this.getZ(), (float)(this.field_22789 - 320) / 2.0f, (float)(this.field_22790 - 224) / 2.0f, (float)(this.field_22789 + 320) / 2.0f, (float)(this.field_22790 + 224) / 2.0f);
        this.renderTitle(ctx, this.field_22785);
        if (ctx.isDebug()) {
            this.renderDebug(ctx);
        }
        super.render(ctx);
    }

    private void renderTitle(ScreenRenderingContext ctx, class_2561 title) {
        float left = (float)this.field_22789 / 2.0f - 12.0f - (float)Page.PAGE_WIDTH + 2.0f;
        float top = (float)(this.field_22790 - 192) / 2.0f + 28.0f - 12.0f;
        ctx.renderText(title, 0x66000000, ctx.getZ(), left + 0.6f, top + 0.6f);
        ctx.renderText(title, -16250872, ctx.getZ(), left, top);
    }

    private void renderDebug(ScreenRenderingContext ctx) {
        ctx.renderText((class_2561)class_2561.method_43470((String)((Object)((Object)this)).getClass().getSimpleName()), -1, ctx.getZ(), 2.0f, 2.0f);
    }

    @Override
    protected void resizeBox(int width, int height) {
        for (int i = 0; i < this.bookmarks.length; ++i) {
            Bookmark bookmark = this.bookmarks[i];
            if (bookmark == null) continue;
            ScreenElementBox box = bookmark.getBox();
            box.setPosition((float)width / 2.0f - 12.0f - (float)Page.PAGE_WIDTH - box.getWidth() - 18.0f + (float)(i % 3), (float)(height - 192) / 2.0f + 28.0f + (float)i * (box.getHeight() + 4.0f));
        }
        if (this.currLeftPage != null) {
            this.currLeftPage.getBox().setPosition((float)width / 2.0f - 12.0f - (float)Page.PAGE_WIDTH, (float)(height - 192) / 2.0f + 28.0f);
        }
        if (this.currRightPage != null) {
            this.currRightPage.getBox().setPosition((float)width / 2.0f + 12.0f, (float)(height - 192) / 2.0f + 28.0f);
        }
        this.leftPageNum.getBox().setPosition((float)(width - Page.PAGE_WIDTH - 40) / 2.0f - 12.0f, (float)(height - 192) / 2.0f + 28.0f + (float)Page.PAGE_HEIGHT + 2.0f);
        this.rightPageNum.getBox().setPosition((float)(width + Page.PAGE_WIDTH - 40) / 2.0f + 12.0f, (float)(height - 192) / 2.0f + 28.0f + (float)Page.PAGE_HEIGHT + 2.0f);
        this.turnLeft.getBox().setPosition((float)(width - 16) / 2.0f - (float)(Page.PAGE_WIDTH + 4), (float)(height - 192) / 2.0f + 28.0f + (float)Page.PAGE_HEIGHT + 2.0f);
        this.turnRight.getBox().setPosition((float)(width - 16) / 2.0f + (float)(Page.PAGE_WIDTH + 4), (float)(height - 192) / 2.0f + 28.0f + (float)Page.PAGE_HEIGHT + 2.0f);
        this.centeredMessage.getBox().set((float)width / 2.0f - (float)Page.PAGE_WIDTH, (float)(height + 192) / 2.0f, (float)width / 2.0f + (float)Page.PAGE_WIDTH, (float)(height + 192) / 2.0f + 20.0f);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (KeyMappingManager.OPEN_BIOLOGY_DICTIONARY_SCREEN.method_1417(keyEvent) || this.client.field_1690.field_1822.method_1417(keyEvent)) {
            this.method_25419();
            return true;
        }
        if (KeyMappingManager.TOGGLE_DEBUG.method_1417(keyEvent)) {
            this.screenRenderingContext.setDebug(!this.screenRenderingContext.isDebug());
            this.sendScreenMessage((class_2561)class_2561.method_43470((String)("Debug mode " + (this.screenRenderingContext.isDebug() ? "on" : "off"))));
            return true;
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_73150() {
        return true;
    }

    public Bookmark getBookmark(int idx) {
        return this.bookmarks[idx];
    }

    public Bookmark setBookmark(int idx, Bookmark bookmark) {
        Bookmark old = this.bookmarks[idx];
        this.bookmarks[idx] = bookmark;
        bookmark.setIdx(idx);
        bookmark.setParent(this.getRootScreenElement());
        if (old != null) {
            old.setParent(null);
        }
        return old;
    }

    public void addBookmark(Bookmark bookmark) {
        for (int i = 0; i < this.bookmarks.length; ++i) {
            if (this.bookmarks[i] != null) continue;
            this.bookmarks[i] = bookmark;
            bookmark.setIdx(i);
            bookmark.setParent(this.getRootScreenElement());
            return;
        }
        BiologyDictionary.LOGGER.error("Bookmarks are full. Failed to add {} from first!", bookmark.getClass());
    }

    public void addBookmarkFromLast(Bookmark bookmark) {
        for (int i = this.bookmarks.length - 1; i >= 0; --i) {
            if (this.bookmarks[i] != null) continue;
            this.bookmarks[i] = bookmark;
            bookmark.setIdx(i);
            bookmark.setParent(this.getRootScreenElement());
            return;
        }
        BiologyDictionary.LOGGER.error("Bookmarks are full. Failed to add {} from last!", bookmark.getClass());
    }

    public Page getCurrLeftPage() {
        return this.currLeftPage;
    }

    public Page getCurrRightPage() {
        return this.currRightPage;
    }

    public Page getPage(int pageIndex) {
        return this.pages.get(pageIndex);
    }

    public Page getPageOrNull(int pageIndex) {
        if (pageIndex < this.pages.size()) {
            return this.pages.get(pageIndex);
        }
        return null;
    }

    public int getPageSize() {
        return this.pages.size();
    }

    public void setCurrPage(int pageIndex) {
        this.clearHoveredElement();
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            return;
        }
        this.currPageIndex = pageIndex;
        this.updateCurrPages();
    }

    public Page addPage() {
        Page newPage = new Page();
        this.pages.add(newPage);
        this.updateCurrPages();
        return newPage;
    }

    public Page getOrAddPage(int pageIndex) {
        while (pageIndex >= this.pages.size()) {
            this.pages.add(new Page());
        }
        this.updateCurrPages();
        return this.pages.get(pageIndex);
    }

    public void clearAllPages() {
        this.pages.clear();
        this.updateCurrPages();
    }

    private void updateCurrPages() {
        this.currLeftPage = this.updatePage(this.currLeftPage, this.getPageOrNull(this.currPageIndex));
        this.currRightPage = this.updatePage(this.currRightPage, this.getPageOrNull(this.currPageIndex + 1));
        this.updateBoxSizes();
    }

    private Page updatePage(Page oldPage, Page newPage) {
        if (oldPage != newPage) {
            if (oldPage != null) {
                oldPage.setParent(null);
            }
            if (newPage != null) {
                newPage.setParent(this.getRootScreenElement());
            }
        }
        return newPage;
    }

    protected void resetAndAndWidgetsOneByOne(List<? extends Widget> widgets) {
        this.clearAllPages();
        this.addAllWidgetsOneByOne(widgets);
        this.setCurrPage(0);
    }

    protected void addAllWidgetsOneByOne(List<? extends Widget> widgets) {
        boolean add = true;
        Page page = null;
        for (Widget widget : widgets) {
            if (widget instanceof TurnPageTriggerWidget) {
                add = true;
                continue;
            }
            if (add) {
                page = this.addPage();
                add = false;
            }
            if (page.addWidget(widget)) continue;
            page = this.addPage();
            page.addWidget(widget);
        }
    }

    public final void sendScreenMessage(class_2561 text) {
        this.centeredMessage.setText(text);
    }

    public final void sendScreenMessage(class_2561 text, int color) {
        this.centeredMessage.setText(text, color);
    }

    public abstract class Bookmark
    extends ScreenElement {
        private static final int L = 1;
        private static final int T = 24;
        private static final int W = 3;
        private static final int H = 1;
        private static final int CNT = 5;
        private final class_2561 text;
        private int idx;

        public Bookmark(class_2561 text) {
            this.text = text;
            this.getBox().setSize(30.0f, 10.0f);
        }

        public void setIdx(int idx) {
            this.idx = idx;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            ScreenElementBox box = this.getBox();
            float offsetL = AbstractBiologyDictionaryScreen.this.getHoveredElement() == this ? 3 : 0;
            float offsetT = this.idx % 5 * 1;
            ctx.renderTexture(Textures.ICONS, (1.0f + offsetL) * 10.0f, (24.0f - offsetT) * 10.0f, ctx.getZ(), box.getLeft(), box.getTop(), box.getWidth(), box.getHeight());
            ctx.renderCenteredText(this.text, -1140850689, 0.5f, ctx.getZ(), (box.getLeft() + box.getRight()) / 2.0f, box.getTop() + 3.0f);
        }
    }

    private final class PageNum
    extends ScreenElement {
        private static final int WIDTH = 40;
        private static final int HEIGHT = 8;
        private final int leftOrRight;
        private int lastIndex;
        private int lastSize;
        private class_2561 cache;

        public PageNum(boolean leftOrRight) {
            super(false);
            this.lastIndex = -1;
            this.lastSize = -1;
            this.cache = class_2561.method_43473();
            this.leftOrRight = leftOrRight ? 2 : 1;
            this.getBox().setSize(40.0f, 8.0f);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            int index = AbstractBiologyDictionaryScreen.this.currPageIndex;
            int size = AbstractBiologyDictionaryScreen.this.getPageSize();
            if (this.lastIndex != index || this.lastSize != size) {
                this.lastIndex = index;
                this.lastSize = size;
                int real = index + this.leftOrRight;
                this.cache = real <= size ? class_2561.method_43470((String)(real + "/" + size)) : class_2561.method_43473();
            }
            ctx.renderCenteredText(this.cache, -5279457, ctx.getZ(), (this.getBox().getLeft() + this.getBox().getRight()) / 2.0f, this.getBox().getTop());
        }
    }

    private final class PageTurnButton
    extends ScreenElement {
        public static final int SIZE = 16;
        private final int pagesToTurn;

        public PageTurnButton(int pagesToTurn) {
            this.pagesToTurn = pagesToTurn;
            this.getBox().setSize(16.0f, 16.0f);
        }

        public void turn() {
            AbstractBiologyDictionaryScreen.this.setCurrPage(AbstractBiologyDictionaryScreen.this.currPageIndex + this.pagesToTurn);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (PageTurnButton.isMouseLeft(code)) {
                ClientUtils.playScreenSound(AbstractBiologyDictionaryScreen.this.client, class_3417.field_17481, 1.0f, 0.8f);
                this.turn();
                return true;
            }
            return super.onMouseDown(x, y, code);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            int h = AbstractBiologyDictionaryScreen.this.getHoveredElement() == this ? 1 : 0;
            int lr = this.pagesToTurn < 0 ? 9 - h : 22 + h;
            ScreenElementBox box = this.getBox();
            ctx.renderTexture(Textures.BOOK, lr * 16, 224.0f, ctx.getZ(), box.getLeft(), box.getTop(), box.getWidth(), box.getHeight());
        }
    }

    public static final class DescriptionWidget
    extends Widget {
        private final class_2561 text;

        public DescriptionWidget(int rows, int columns, class_2561 text) {
            super(rows, columns);
            this.text = text;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            ScreenElementBox box = this.getBox();
            ctx.renderText(this.text, -1157627904, 0.5f, ctx.getZ(), box.getLeft() + 2.0f, box.getTop() + 3.0f);
        }
    }

    public static final class PlaceHolderWidget
    extends Widget {
        public PlaceHolderWidget(int rows, int columns) {
            super(rows, columns);
            this.setHoverable(false);
            this.setSelectable(false);
        }
    }

    public abstract class Catalog
    extends Widget {
        protected final int depth;
        protected final class_2561 text;

        public Catalog(int depth, class_2561 text) {
            super(1, 8);
            this.depth = depth;
            this.text = text;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            int lineColor;
            int textColor;
            boolean hovered;
            super.onRender(ctx);
            ScreenElementBox box = this.getBox();
            int d = this.depth * 8;
            ctx.renderTexture(Textures.ICONS, 70.0f, 240.0f, ctx.getZ(), box.getLeft() + (float)d, box.getTop(), 40.0f, 10.0f);
            boolean bl = hovered = AbstractBiologyDictionaryScreen.this.getHoveredElement() == this;
            if (hovered) {
                textColor = -16777216;
                lineColor = 1152348447;
            } else {
                textColor = -2013265920;
                lineColor = 581923103;
            }
            if (this.depth != 0) {
                ctx.renderHorizontalLine(lineColor, 1.0f, ctx.getZ(), (box.getTop() + box.getBottom()) / 2.0f, box.getLeft() + 1.0f, box.getLeft() + (float)d - 1.0f);
            }
            ctx.renderText(this.text, textColor, 0.5f, ctx.getZ(), box.getLeft() + (float)d + 12.0f, box.getTop() + 3.0f);
        }
    }

    public final class OpenBdAboutScreenBookmark
    extends Bookmark {
        public OpenBdAboutScreenBookmark() {
            super((class_2561)class_2561.method_43471((String)"bookmark.biologydictionary.about"));
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (OpenBdAboutScreenBookmark.isMouseLeft(code)) {
                ClientUtils.playScreenSound(AbstractBiologyDictionaryScreen.this.client, class_3417.field_14699, 1.0f, 0.8f);
                ClientUtils.setScreen(AbstractBiologyDictionaryScreen.this.client, new BdAboutScreen());
                return true;
            }
            return super.onMouseDown(x, y, code);
        }
    }

    public final class OpenBdConfigScreenBookmark
    extends Bookmark {
        public OpenBdConfigScreenBookmark() {
            super((class_2561)class_2561.method_43471((String)"bookmark.biologydictionary.config"));
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (OpenBdConfigScreenBookmark.isMouseLeft(code)) {
                ClientUtils.playScreenSound(AbstractBiologyDictionaryScreen.this.client, class_3417.field_14699, 1.0f, 0.8f);
                ClientUtils.setScreen(AbstractBiologyDictionaryScreen.this.client, new BdConfigScreen());
                return true;
            }
            return super.onMouseDown(x, y, code);
        }
    }

    public final class OpenBdHomeScreenBookmark
    extends Bookmark {
        public OpenBdHomeScreenBookmark() {
            super((class_2561)class_2561.method_43471((String)"bookmark.biologydictionary.back_to_home"));
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (OpenBdHomeScreenBookmark.isMouseLeft(code)) {
                ClientUtils.playScreenSound(AbstractBiologyDictionaryScreen.this.client, class_3417.field_14699, 1.0f, 0.8f);
                ClientUtils.setScreen(AbstractBiologyDictionaryScreen.this.client, new BdHomeScreen());
                return true;
            }
            return super.onMouseDown(x, y, code);
        }
    }
}

