/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.screen;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElementBox;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.config.ClothConfigScreenProvider;
import io.github.xienaoban.biologydictionary.config.Configs;
import io.github.xienaoban.biologydictionary.config.ConfigsManager;
import io.github.xienaoban.biologydictionary.gui.component.Widget;
import io.github.xienaoban.biologydictionary.gui.screen.AbstractBiologyDictionaryScreen;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class BdConfigScreen
extends AbstractBiologyDictionaryScreen {
    public BdConfigScreen() {
        super((class_2561)class_2561.method_43471((String)"bookmark.biologydictionary.config"));
        this.initBookmarks();
        this.initWidgets();
    }

    private void initBookmarks() {
        this.addBookmark(new AbstractBiologyDictionaryScreen.OpenBdHomeScreenBookmark());
    }

    private void initWidgets() {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add(new AbstractBiologyDictionaryScreen.DescriptionWidget(1, 8, (class_2561)class_2561.method_43471((String)"text.biologydictionary.local_configs_desc")));
        widgets.add(new OpenLocalConfigsScreenWidget());
        widgets.add(new AbstractBiologyDictionaryScreen.PlaceHolderWidget(1, 8));
        widgets.add(new AbstractBiologyDictionaryScreen.DescriptionWidget(1, 8, (class_2561)class_2561.method_43471((String)"text.biologydictionary.server_configs_desc")));
        Configs.ServerConfigs serverConfigs = ConfigsManager.getServer();
        Configs.forEachConfigEntryInCategory(serverConfigs, entryInfo -> widgets.add(new ConfigWidget((Configs.ConfigEntryInfo)entryInfo)));
        this.addAllWidgetsOneByOne(widgets);
    }

    public static class OpenLocalConfigsScreenWidget
    extends Widget {
        public OpenLocalConfigsScreenWidget() {
            super(1, 8);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            ScreenElementBox box = this.getBox();
            boolean hovered = ctx.getElementScreen().getHoveredElement() == this;
            int tt = hovered ? 22 : 23;
            int ww = 10;
            int wh = 10;
            ctx.renderTexture(Textures.ICONS, 8 * ww, tt * wh, ctx.getZ(), box.getLeft(), box.getTop(), 3 * ww, wh);
            int tw = 3 * ww;
            int th = 1 * wh;
            ctx.renderTexture(Textures.ICONS, 8 * ww, tt * ww, 8 * ww + tw, tt * ww + th, ctx.getZ(), box.getRight(), box.getBottom(), box.getRight() - (float)tw, box.getBottom() - (float)th);
            int color = hovered ? -16777216 : -1157627904;
            ctx.renderCenteredText((class_2561)class_2561.method_43471((String)"text.biologydictionary.open_local_configs_screen"), color, 0.5f, ctx.getZ(), (box.getLeft() + box.getRight()) / 2.0f, box.getTop() + 3.0f);
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (OpenLocalConfigsScreenWidget.isMouseLeft(code)) {
                ClientUtils.playScreenSound(ClientUtils.getClient(), class_3417.field_14699, 1.0f, 0.8f);
                ClientUtils.setScreen(ClientUtils.getClient(), ClothConfigScreenProvider.provideScreen(ClientUtils.getCurrentScreen()));
                return true;
            }
            return super.onMouseDown(x, y, code);
        }
    }

    public static class ConfigWidget
    extends Widget {
        private final Configs.ConfigEntryInfo entryInfo;
        private final class_5250 configText;
        private final class_5250 configTooltipText;

        public ConfigWidget(Configs.ConfigEntryInfo entryInfo) {
            super(1, 8);
            this.entryInfo = entryInfo;
            this.configText = class_2561.method_43471((String)Configs.getConfigNameTranslationKey(entryInfo.getName()));
            this.configTooltipText = class_2561.method_43471((String)(Configs.getConfigNameTranslationKey(entryInfo.getName()) + ".tooltip"));
            this.setSelectable(false);
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            ScreenElementBox box = this.getBox();
            int ww = 10;
            int wh = 10;
            ctx.renderTexture(Textures.ICONS, 7 * ww, 21 * wh, ctx.getZ(), box.getLeft(), box.getTop(), 4 * ww, wh);
            int tw = 3 * ww;
            int th = 1 * wh;
            ctx.renderTexture(Textures.ICONS, 8 * ww, 21 * ww, 8 * ww + tw, 21 * ww + th, ctx.getZ(), box.getRight(), box.getBottom(), box.getRight() - (float)tw, box.getBottom() - (float)th);
            ctx.renderText((class_2561)this.configText, -1157627904, 0.5f, ctx.getZ(), box.getLeft() + 12.0f, box.getTop() + 3.0f);
            class_2561 valueText = ConfigWidget.formatValue(this.entryInfo.getValue(ConfigsManager.getServer()));
            ctx.renderRightAlignedText(valueText, -16777216, 0.5f, ctx.getZ(), box.getRight() - 2.0f, box.getTop() + 3.0f);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            List<class_2561> list = Arrays.asList(this.configText.method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}), this.configTooltipText.method_27692(class_124.field_1080));
            ctx.renderComponentTooltip(list, 0.5f, this.getBox().getLeft(), this.getBox().getBottom() + 1.0f);
            return true;
        }

        private static class_2561 formatValue(Object value) {
            Object object = value;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Enum.class, Collection.class}, (Object)object, n)) {
                case -1 -> class_2561.method_43471((String)"text.biologydictionary.none_with_brackets");
                case 0 -> {
                    Boolean b = (Boolean)object;
                    yield class_2561.method_43471((String)(b != false ? "gui.yes" : "gui.no"));
                }
                case 1 -> {
                    Enum e = (Enum)object;
                    yield class_2561.method_43471((String)Configs.getEnumValueTranslationKey(e));
                }
                case 2 -> {
                    Collection s = (Collection)object;
                    yield class_2561.method_43470((String)String.valueOf(s.size()));
                }
                default -> class_2561.method_43470((String)String.valueOf(value));
            };
        }
    }
}

