/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.screen;

import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenElementBox;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.core.EntityManager;
import io.github.xienaoban.biologydictionary.core.skill.general.GetSpawnEggSkill;
import io.github.xienaoban.biologydictionary.core.skill.general.HighlightEntitiesSkill;
import io.github.xienaoban.biologydictionary.gui.component.Widget;
import io.github.xienaoban.biologydictionary.gui.screen.AbstractBiologyDictionaryScreen;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_3417;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class BdHomeScreen
extends AbstractBiologyDictionaryScreen {
    private long currTime = 0L;
    private float entityRotateX;
    private float entityRotateY;

    public BdHomeScreen() {
        super((class_2561)class_2561.method_43471((String)"title.biologydictionary"));
        this.initBookmarks();
        this.initEntityWidgets();
    }

    private void initBookmarks() {
        this.addBookmarkFromLast(new AbstractBiologyDictionaryScreen.OpenBdAboutScreenBookmark());
        this.addBookmarkFromLast(new AbstractBiologyDictionaryScreen.OpenBdConfigScreenBookmark());
        this.addBookmark(new AllEntitiesBookmark());
        for (EntityManager.TagGroup group : EntityManager.getInstance().getTagGroups()) {
            this.addBookmark(new TagGroupBookmark(group));
        }
    }

    private void initEntityWidgets() {
        List<Widget> list = this.getEntityWidgets(EntityManager.getInstance().getEntityClassInfos());
        this.addAllWidgetsOneByOne(list);
    }

    private List<Widget> getEntityWidgets(List<EntityManager.EntityClassInfo> infos) {
        class_638 level = ClientUtils.getClientLevel(this.client);
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (EntityManager.EntityClassInfo eci : infos) {
            class_1299<?> type = eci.getType();
            Object entity = EntityUtils.create(type, (class_1937)level);
            if (entity instanceof class_1480) {
                EntityUtils.setInWater(entity, true);
            }
            widgets.add(new EntityWidget((class_1297)entity));
        }
        return widgets;
    }

    @Override
    protected void render(ScreenRenderingContext ctx) {
        this.currTime = System.currentTimeMillis();
        int t = (int)(this.currTime % 8000L);
        t = t > 4000 ? 6000 - t : t - 2000;
        this.entityRotateX = (float)Math.atan((float)t / 400.0f);
        this.entityRotateY = (float)Math.atan(1.125);
        super.render(ctx);
    }

    private final class AllEntitiesBookmark
    extends AbstractBiologyDictionaryScreen.Bookmark {
        public AllEntitiesBookmark() {
            super((class_2561)class_2561.method_43471((String)"bookmark.biologydictionary.all"));
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (AllEntitiesBookmark.isMouseLeft(code)) {
                ClientUtils.playScreenSound(BdHomeScreen.this.client, class_3417.field_14699, 1.0f, 0.8f);
                List<Widget> list = BdHomeScreen.this.getEntityWidgets(EntityManager.getInstance().getEntityClassInfos());
                BdHomeScreen.this.resetAndAndWidgetsOneByOne(list);
                return true;
            }
            return super.onMouseDown(x, y, code);
        }
    }

    private final class TagGroupBookmark
    extends AbstractBiologyDictionaryScreen.Bookmark {
        private final EntityManager.TagGroup group;

        public TagGroupBookmark(EntityManager.TagGroup group) {
            super(group.getName());
            this.group = group;
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (TagGroupBookmark.isMouseLeft(code)) {
                ClientUtils.playScreenSound(BdHomeScreen.this.client, class_3417.field_14699, 1.0f, 0.8f);
                ArrayList<AbstractBiologyDictionaryScreen.DescriptionWidget> tags = new ArrayList<AbstractBiologyDictionaryScreen.DescriptionWidget>();
                this.group.dfsTags((nbt, depth) -> {
                    tags.add((AbstractBiologyDictionaryScreen.DescriptionWidget)((Object)new TagCatalog(depth, (EntityManager.Tag)nbt)));
                    return true;
                });
                tags.addFirst(new AbstractBiologyDictionaryScreen.DescriptionWidget(1, 8, this.group.getDescription()));
                BdHomeScreen.this.resetAndAndWidgetsOneByOne(tags);
                return true;
            }
            return super.onMouseDown(x, y, code);
        }
    }

    private final class EntityWidget
    extends Widget {
        private static final int BUTTONS_CUT = 17;
        private final class_1297 entity;
        private final class_2561 name;
        private final class_1799 spawnEgg;
        private final ScreenRenderingContext.EntityRenderingCache entityRenderingCache;

        public EntityWidget(class_1297 entity) {
            super(2, 2);
            this.entityRenderingCache = new ScreenRenderingContext.EntityRenderingCache();
            this.entity = entity;
            class_1299<class_1297> type = EntityUtils.getEntityType(entity);
            this.name = type.method_5897();
            class_1826 item = class_1826.method_8019(type);
            this.spawnEgg = item == null ? null : new class_1799((class_1935)item);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            int distance;
            ScreenElementBox box = this.getBox();
            float mouseY = BdHomeScreen.this.screenRenderingContext.getMouseY() - box.getTop();
            if (mouseY < 17.0f) {
                if (EntityWidget.isMouseLeft(code)) {
                    distance = 20;
                } else {
                    if (!EntityWidget.isMouseRight(code)) return true;
                    distance = 100;
                }
            } else {
                if (!EntityWidget.isMouseLeft(code)) return true;
                if (!PlayerUtils.isCreative((class_1657)BdHomeScreen.this.player)) {
                    BdHomeScreen.this.sendScreenMessage((class_2561)class_2561.method_43471((String)"text.biologydictionary.only_in_creative_mode"));
                    return true;
                } else {
                    GetSpawnEggSkill.activate(EntityUtils.getEntityType(this.entity));
                }
                return true;
            }
            HighlightEntitiesSkill.activate(EntityUtils.getEntityType(this.entity), distance);
            ClientUtils.playScreenSound(BdHomeScreen.this.client, class_3417.field_15105, 1.0f, 0.8f);
            BdHomeScreen.this.method_25419();
            return true;
        }

        @Override
        protected void onRender(ScreenRenderingContext ctx) {
            super.onRender(ctx);
            ScreenElementBox box = this.getBox();
            ctx.renderEntityCentered(this.entity, this.entityRenderingCache, box.getLeft(), box.getTop(), box.getRight(), box.getBottom() - 6.0f, BdHomeScreen.this.entityRotateX, BdHomeScreen.this.entityRotateY);
            ctx.renderCenteredText(this.name, -16777216, 0.5f, BdHomeScreen.this.getZ(), (box.getLeft() + box.getRight()) / 2.0f, box.getBottom() - 5.0f);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            int colorEgg;
            int colorHighlight;
            ScreenElementBox box = this.getBox();
            ctx.renderRectangle(2004436224, ctx.getZ(), box.getLeft(), box.getTop(), box.getRight(), box.getBottom());
            float midX = (box.getLeft() + box.getRight()) / 2.0f;
            float mouseY = ctx.getMouseY() - box.getTop();
            if (mouseY < 17.0f) {
                colorHighlight = -721420289;
                colorEgg = -1426063361;
            } else {
                colorHighlight = -1426063361;
                colorEgg = -721420289;
            }
            ctx.renderRectangle(colorHighlight, ctx.getZ(), box.getLeft() + 1.0f, box.getTop() + 1.0f, box.getRight() - 1.0f, box.getTop() + 17.0f);
            ctx.renderRectangle(colorEgg, ctx.getZ(), box.getLeft() + 1.0f, box.getTop() + 17.0f, box.getRight() - 1.0f, box.getBottom() - 1.0f);
            int wh = 10;
            int wink = 600;
            int cycle = 2400;
            long time = BdHomeScreen.this.currTime % 2400L;
            int u = time < 600L ? -1 : (time < 1200L ? 0 : (time < 1800L ? 1 : 0));
            ctx.renderTexture(Textures.ICONS, (23 + u) * 10, 240.0f, ctx.getZ(), midX - 5.0f, box.getTop() + 3.5f, 10.0f, 10.0f);
            if (this.spawnEgg != null) {
                ctx.renderItem(this.spawnEgg, 0.5f, midX - 4.0f, box.getTop() + 17.0f);
            }
            List<class_2561> tooltips = mouseY < 17.0f ? Arrays.asList(EntityWidget.tooltipTitle("widget.biologydictionary.highlight"), class_2561.method_43469((String)"widget.biologydictionary.highlight.left.desc", (Object[])new Object[]{20, 1}).method_27692(class_124.field_1080), class_2561.method_43469((String)"widget.biologydictionary.highlight.right.desc", (Object[])new Object[]{100, 16}).method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43470((String)EntityUtils.getEntityTypeIdString(this.entity)).method_27692(class_124.field_1080)) : Arrays.asList(EntityWidget.tooltipTitle("widget.biologydictionary.offer_spawn_egg"), EntityWidget.tooltipDescription("widget.biologydictionary.offer_spawn_egg.desc"), class_2561.method_43473(), class_2561.method_43470((String)EntityUtils.getEntityTypeIdString(this.entity)).method_27692(class_124.field_1080));
            ctx.renderComponentTooltipCentered(tooltips, 0.5f, midX, box.getBottom() + 1.0f);
            return true;
        }
    }

    private final class TagCatalog
    extends AbstractBiologyDictionaryScreen.Catalog {
        private final EntityManager.Tag tag;

        public TagCatalog(int depth, EntityManager.Tag tag) {
            super(depth, class_2564.method_37112(Arrays.asList(tag.getText(), class_2561.method_43470((String)("(" + tag.getEntities().size() + ")"))), (class_2561)class_2561.method_43470((String)" ")));
            this.tag = tag;
        }

        @Override
        protected boolean onMouseDown(float x, float y, int code) {
            if (TagCatalog.isMouseLeft(code)) {
                ClientUtils.playScreenSound(BdHomeScreen.this.client, class_3417.field_15105, 1.0f, 1.5f);
                BdHomeScreen.this.clearAllPages();
                List<Widget> list = BdHomeScreen.this.getEntityWidgets(this.tag.getEntities());
                BdHomeScreen.this.resetAndAndWidgetsOneByOne(list);
                return true;
            }
            return super.onMouseDown(x, y, code);
        }

        @Override
        protected boolean onRenderHovered(ScreenRenderingContext ctx) {
            if (this.tag.getDescription() == null) {
                return true;
            }
            int d = this.depth * 8;
            ScreenElementBox box = this.getBox();
            ArrayList<class_2561> texts = new ArrayList<class_2561>();
            texts.add(this.tag.getDescription());
            ctx.renderComponentTooltip(texts, 0.5f, box.getLeft() + (float)d + 10.0f, box.getBottom());
            return true;
        }
    }
}

