/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.screen.misc;

import io.github.xienaoban.biologydictionary.client.KeyMappingManager;
import io.github.xienaoban.biologydictionary.common.gui.screen.ElementScreen;
import io.github.xienaoban.biologydictionary.common.gui.screen.util.ScreenRenderingContext;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.EntityUtils;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import io.github.xienaoban.biologydictionary.net.ClientNetManager;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4466;
import net.minecraft.class_4481;
import net.minecraft.class_4482;

public class BeehiveScreen
extends ElementScreen {
    private static final int[][] LATTICES = new int[][]{{0, 0}, {32, 0}, {0, 50}, {32, 50}, {16, 25}, {-16, 25}, {48, 25}};
    private static final int MAX_HONEY_CNT = 5;
    private static final int MAX_BEE_CNT = 3;
    protected final class_310 client = ClientUtils.getClient();
    private final class_2338 pos;
    private final class_1937 level;
    private final class_4482 entity;
    private final BeeInfo[] bees;
    protected int blockBeeCnt;
    protected int blockHoneyCnt;
    private final BeeAction[] actions;
    private int lastBeeCnt;
    private long mills;
    private int passedClientTickCount = 0;

    public BeehiveScreen(class_2338 pos) {
        super((class_2561)ClientUtils.getClientLevel().method_8320(pos).method_26204().method_9518());
        this.pos = pos;
        this.level = ClientUtils.getClientLevel();
        this.entity = (class_4482)this.level.method_8321(pos);
        Objects.requireNonNull(this.entity);
        this.bees = (BeeInfo[])IntStream.range(0, 3).mapToObj(v -> new BeeInfo(this.level)).toArray(BeeInfo[]::new);
        this.blockBeeCnt = 0;
        this.blockHoneyCnt = class_4482.method_23902((class_2680)this.entity.method_11010());
        this.actions = (BeeAction[])IntStream.range(0, 3).mapToObj(v -> new BeeAction()).toArray(BeeAction[]::new);
        this.lastBeeCnt = 0;
        this.mills = System.currentTimeMillis();
    }

    @Override
    protected void resizeBox(int width, int height) {
    }

    @Override
    protected void render(ScreenRenderingContext ctx) {
        super.render(ctx);
        long lastMills = this.mills;
        this.mills = System.currentTimeMillis();
        int diff = (int)(this.mills - lastMills);
        this.renderTransparentBackground(ctx);
        ctx.getGuiGraphics().method_51448().pushMatrix();
        int w = this.field_22789 - 128 >> 1;
        int h = this.field_22790 - 128 >> 1;
        int beeCnt = this.blockBeeCnt;
        int honeyCnt = this.blockHoneyCnt;
        if (this.lastBeeCnt > beeCnt) {
            this.lastBeeCnt = beeCnt;
            BeeAction tmp = this.actions[0];
            for (int i = 1; i < 3; ++i) {
                this.actions[i - 1] = this.actions[i];
            }
            this.actions[2] = tmp;
        } else {
            this.lastBeeCnt = beeCnt;
        }
        int lw = w + 32;
        int lh = h + 23;
        for (int i = 0; i < 5; ++i) {
            this.drawLattice(ctx, LATTICES[i][0] + lw, LATTICES[i][1] + lh, i < honeyCnt ? 2 : 0);
        }
        this.drawLattice(ctx, LATTICES[5][0] + lw, LATTICES[5][1] + lh, 1);
        this.drawLattice(ctx, LATTICES[6][0] + lw, LATTICES[6][1] + lh, 1);
        ctx.renderTexture(Textures.BEEHIVE, 0.0f, 0.0f, 0.0f, w, h, 128.0f, 128.0f);
        int color = -1124073473;
        for (int i = 0; i < beeCnt; ++i) {
            int y;
            int x;
            BeeAction action = this.actions[i];
            action.run(diff);
            if (honeyCnt + i < 5) {
                x = LATTICES[honeyCnt + i][0] + lw + 16;
                y = LATTICES[honeyCnt + i][1] + lh + 29;
            } else {
                int p = i + honeyCnt - 5 + 1;
                x = w + p * 32;
                y = h + 24 + ((p & 1) == 0 ? 0 : 8);
            }
            BeeInfo bee = this.bees[i];
            float beeScale = bee.entity.method_6109() ? 0.6f : 1.0f;
            float t = 14.0f * (float)Math.min(bee.ticksInHive, bee.minTicksInHive) / (float)bee.minTicksInHive;
            ctx.renderHorizontalLine(-12307712, 2.2f, ctx.getZ(), y - 1, (float)x - 7.5f, (float)x + 7.5f);
            ctx.renderHorizontalLine(bee.entity.method_21784() ? -17664 : 1694481152, 1.2f, ctx.getZ(), y - 1, x - 7, (float)(x - 7) + t);
            ctx.renderEntityCentered((class_1297)bee.entity, bee.entityRenderingCache, (float)x - 14.0f, (float)y - 26.0f, (float)x + 14.0f, y, (float)Math.atan(action.mouseX / 80.0f), (float)Math.atan(action.mouseY / 80.0f), beeScale);
            class_2561 customName = bee.entity.method_5797();
            int beeTop = y - (bee.entity.method_6109() ? 20 : 25);
            if (customName != null) {
                int wHalf = (ctx.calcTextWidth(customName) >> 2) + 1;
                ctx.renderHorizontalLine(0x55777777, 6.0f, ctx.getZ(), beeTop, x - wHalf, x + wHalf);
                ctx.renderCenteredText(bee.entity.method_5797(), color, 0.5f, ctx.getZ(), x, beeTop - 2);
            }
            if (!(ctx.getMouseX() > (float)(x - 10)) || !(ctx.getMouseX() < (float)(x + 10)) || !(ctx.getMouseY() > (float)beeTop) || !(ctx.getMouseY() < (float)y)) continue;
            List<class_2561> texts = Arrays.asList(bee.entity.method_5477(), class_2561.method_43469((String)"text.biologydictionary.bee_state_in_beehive", (Object[])new Object[]{class_2561.method_43471((String)(bee.entity.method_21784() ? "text.biologydictionary.bee_producing_nectar" : "text.biologydictionary.bee_resting"))}).method_27692(class_124.field_1080), class_2561.method_43469((String)"text.biologydictionary.time_in_beehive", (Object[])new Object[]{bee.ticksInHive / 20 + "s/" + bee.minTicksInHive / 20 + "s"}).method_27692(class_124.field_1080));
            ctx.renderComponentTooltipCenteredForNextFrameVanilla(texts, x, (float)y + 18.0f);
        }
        ctx.renderText((class_2561)class_2561.method_43470((String)(honeyCnt + "/5")), color, ctx.getZ(), (float)(LATTICES[5][0] + lw + 16) - 8.5f, LATTICES[5][1] + lh + 8);
        ctx.renderText((class_2561)class_2561.method_43470((String)(beeCnt + "/3")), color, ctx.getZ(), (float)(LATTICES[6][0] + lw + 16) - 8.5f, LATTICES[6][1] + lh + 8);
        ctx.renderCenteredText((class_2561)class_2561.method_43471((String)"text.biologydictionary.honey"), color, ctx.getZ(), (float)(LATTICES[5][0] + lw) + 16.5f, LATTICES[5][1] + lh + 16);
        ctx.renderCenteredText(class_1299.field_20346.method_5897(), color, ctx.getZ(), (float)(LATTICES[6][0] + lw) + 16.5f, LATTICES[6][1] + lh + 16);
        ctx.getGuiGraphics().method_51448().popMatrix();
    }

    private void drawLattice(ScreenRenderingContext ctx, int w, int h, int type) {
        ctx.renderTexture(Textures.BEEHIVE, 16 + type * 32, 140.0f, 0.0f, w, h, 32.0f, 32.0f);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (KeyMappingManager.OPEN_BIOLOGY_DICTIONARY_SCREEN.method_1417(keyEvent) || this.client.field_1690.field_1822.method_1417(keyEvent)) {
            this.method_25419();
            return true;
        }
        if (KeyMappingManager.TOGGLE_DEBUG.method_1417(keyEvent)) {
            this.screenRenderingContext.setDebug(!this.screenRenderingContext.isDebug());
            return true;
        }
        return super.method_25404(keyEvent);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        ++this.passedClientTickCount;
        if (this.passedClientTickCount % 5 == 0) {
            if (!(this.level.method_8320(this.pos).method_26204() instanceof class_4481)) {
                this.method_25419();
                return;
            }
            if (this.passedClientTickCount % 10 == 5) {
                ClientNetManager.requestBeehiveInfo(this.pos);
            }
        }
    }

    public void updateBeeInfo(List<class_4482.class_9309> occupants) {
        for (int i = 0; i < occupants.size(); ++i) {
            class_4482.class_9309 occupant = occupants.get(i);
            BeeInfo beeInfo = this.bees[i];
            beeInfo.entity.method_5665(null);
            class_2487 newTag = EntityUtils.getNbt((class_1297)beeInfo.entity);
            EntityUtils.setNbt((class_1297)beeInfo.entity, newTag.method_10543(occupant.comp_2431().method_72540()));
            beeInfo.ticksInHive = occupant.comp_2432();
            beeInfo.minTicksInHive = occupant.comp_2433();
        }
        this.blockBeeCnt = occupants.size();
        this.blockHoneyCnt = class_4482.method_23902((class_2680)this.entity.method_11010());
    }

    private static class BeeInfo {
        public final class_4466 entity;
        public int ticksInHive;
        public int minTicksInHive;
        private final ScreenRenderingContext.EntityRenderingCache entityRenderingCache = new ScreenRenderingContext.EntityRenderingCache();

        public BeeInfo(class_1937 level) {
            this.entity = (class_4466)EntityUtils.create(class_1299.field_20346, level);
            this.ticksInHive = -1;
            this.minTicksInHive = -1;
        }
    }

    private static class BeeAction {
        public float mouseX;
        public float mouseY;
        private float speedMouseX;
        private float speedMouseY;
        private int mouseMoveTime;
        private int mouseCooldownTime;
        private final Random random = new Random();

        public BeeAction() {
            this.mouseX = this.random.nextFloat(-50.0f, 50.0f);
            this.mouseY = this.random.nextFloat(-1.0f, 20.0f);
            this.mouseCooldownTime = this.random.nextInt(3000);
        }

        public void run(int mills) {
            if (this.mouseMoveTime > 0) {
                this.mouseMoveTime -= mills;
                this.mouseX += this.speedMouseX * (float)mills;
                this.mouseY += this.speedMouseY * (float)mills;
                if (Math.abs(this.mouseX) > 50.0f) {
                    this.speedMouseX = -0.2f * this.speedMouseX;
                }
                if (this.mouseY > 20.0f || this.mouseY < 2.0f) {
                    this.speedMouseY = -0.2f * this.speedMouseY;
                }
            } else {
                this.mouseCooldownTime -= mills;
                if (this.mouseCooldownTime < 0) {
                    this.mouseCooldownTime = this.random.nextInt(5000);
                    this.mouseMoveTime = this.random.nextInt(1000);
                    this.speedMouseX = this.random.nextFloat(-0.3f, 0.3f);
                    this.speedMouseY = this.random.nextFloat(-0.1f, 0.1f);
                }
            }
        }
    }
}

