/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.screen.misc;

import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.core.property.bundle.EntityInventoryPropertyBundle;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_11565;
import net.minecraft.class_12117;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1501;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_8181;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jspecify.annotations.Nullable;

public class InventoryStealingMenu
extends class_1703 {
    public static final int EQUIPMENT_SLOTS = class_1304.values().length;
    public static final int MAX_SLOTS = 36;
    private static final class_2960 EMPTY_ARMOR_SLOT_SWORD = class_2960.method_60656((String)"container/slot/sword");
    private static final class_2960 EMPTY_ARMOR_SLOT_SHIELD = class_2960.method_60656((String)"container/slot/shield");
    private static final class_2960 EMPTY_ARMOR_SLOT_HELMET = class_2960.method_60656((String)"container/slot/helmet");
    private static final class_2960 EMPTY_ARMOR_SLOT_CHESTPLATE = class_2960.method_60656((String)"container/slot/chestplate");
    private static final class_2960 EMPTY_ARMOR_SLOT_LEGGINGS = class_2960.method_60656((String)"container/slot/leggings");
    private static final class_2960 EMPTY_ARMOR_SLOT_BOOTS = class_2960.method_60656((String)"container/slot/boots");
    private static final class_2960 EMPTY_ARMOR_SLOT_SADDLE = class_2960.method_60656((String)"container/slot/saddle");
    private static final class_2960 EMPTY_ARMOR_SLOT_HORSE_ARMOR = class_2960.method_60656((String)"container/slot/horse_armor");
    private static final class_2960 EMPTY_ARMOR_SLOT_LLAMA_ARMOR = class_2960.method_60656((String)"container/slot/llama_armor");
    private static final class_2960 EMPTY_ARMOR_SLOT_NAUTILUS_ARMOR = class_2960.method_60656((String)"container/slot/nautilus_armor_inventory");
    final class_1661 inventory;
    final class_1309 entity;
    final class_1263 container;
    final EntityInventoryPropertyBundle.InventoryHandler<class_1309> handler;

    static int calculateMod(int size) {
        int mod;
        if (size > 36) {
            return 9;
        }
        if (size % 4 == 0) {
            mod = 4;
        } else if (size % 3 == 0) {
            mod = 3;
        } else if (size % 2 == 0) {
            mod = 2;
        } else {
            return 9;
        }
        return size / mod;
    }

    public InventoryStealingMenu(int containerId, class_1661 inventory, class_1309 entity, class_1263 container) {
        super(null, containerId);
        this.inventory = inventory;
        this.entity = entity;
        this.container = container;
        this.handler = EntityInventoryPropertyBundle.getHandler(entity);
        container.method_5435((class_11565)inventory.field_7546);
        class_1309 class_13092 = entity;
        Objects.requireNonNull(class_13092);
        class_1309 class_13093 = class_13092;
        int n = 0;
        class_2960 emptyBodySlot = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_12117.class, class_1501.class}, (Object)class_13093, n)) {
            case 0 -> {
                class_12117 ignored = (class_12117)class_13093;
                yield EMPTY_ARMOR_SLOT_NAUTILUS_ARMOR;
            }
            case 1 -> {
                class_1501 ignored = (class_1501)class_13093;
                yield EMPTY_ARMOR_SLOT_LLAMA_ARMOR;
            }
            default -> EMPTY_ARMOR_SLOT_HORSE_ARMOR;
        };
        int left = 8;
        int top = 94;
        int wh = 18;
        this.method_7621(new EntityEquipmentSlot(class_1304.field_6169, left, top, EMPTY_ARMOR_SLOT_HELMET));
        this.method_7621(new EntityEquipmentSlot(class_1304.field_6174, left + 18, top, EMPTY_ARMOR_SLOT_CHESTPLATE));
        this.method_7621(new EntityEquipmentSlot(class_1304.field_6172, left, top += 18, EMPTY_ARMOR_SLOT_LEGGINGS));
        this.method_7621(new EntityEquipmentSlot(class_1304.field_6166, left + 18, top, EMPTY_ARMOR_SLOT_BOOTS));
        this.method_7621(new EntityEquipmentSlot(class_1304.field_55946, left, top += 18, EMPTY_ARMOR_SLOT_SADDLE));
        this.method_7621(new EntityEquipmentSlot(class_1304.field_48824, left + 18, top, emptyBodySlot));
        this.method_7621(new EntityEquipmentSlot(class_1304.field_6173, left, top += 22, EMPTY_ARMOR_SLOT_SWORD));
        this.method_7621(new EntityEquipmentSlot(class_1304.field_6171, left + 18, top, EMPTY_ARMOR_SLOT_SHIELD));
        int size = Math.min(container.method_5439(), 36);
        int mod = InventoryStealingMenu.calculateMod(size);
        for (int i = 0; i < size; ++i) {
            this.method_7621(new class_1735(container, i, 66 + i % mod * 18, 18 + i / mod * 18));
        }
        this.method_61624((class_1263)inventory, 66, 112);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            int containerEnd = EQUIPMENT_SLOTS + Math.min(this.container.method_5439(), 36);
            if (index < containerEnd) {
                return class_1799.field_8037;
            }
            int k = containerEnd + 27;
            int m = k + 9;
            if (index >= k && index < m ? !this.method_7616(itemStack2, containerEnd, k, false) : (index < k ? !this.method_7616(itemStack2, k, m, false) : !this.method_7616(itemStack2, k, k, false))) {
                return class_1799.field_8037;
            }
            return class_1799.field_8037;
        }
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return (this.handler == null || this.handler.getContainer(this.entity) == this.container) && this.container.method_5443(player) && this.entity.method_5805() && player.method_56094((class_1297)this.entity, 4.0);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.container.method_5432((class_11565)player);
    }

    public class_1657 getPlayer() {
        return this.inventory.field_7546;
    }

    class EntityEquipmentSlot
    extends class_1735 {
        private final class_1304 equipmentSlot;
        private final @Nullable class_2960 emptyIcon;

        EntityEquipmentSlot(class_1304 equipmentSlot, int x, @Nullable int y, class_2960 emptyIcon) {
            super((class_1263)new EntityEquipmentContainer(equipmentSlot), 0, x, y);
            this.equipmentSlot = equipmentSlot;
            this.emptyIcon = emptyIcon;
        }

        public void method_48931(class_1799 newStack, class_1799 oldStack) {
            InventoryStealingMenu.this.entity.method_6116(this.equipmentSlot, oldStack, newStack);
            super.method_48931(newStack, oldStack);
        }

        public int method_7675() {
            return 1;
        }

        public boolean method_7680(class_1799 itemStack) {
            if (!PlayerUtils.isCreative(InventoryStealingMenu.this.getPlayer())) {
                return false;
            }
            return InventoryStealingMenu.this.entity.method_63623(itemStack, this.equipmentSlot);
        }

        public boolean method_7674(class_1657 player) {
            if (!PlayerUtils.isCreative(player)) {
                return false;
            }
            class_1799 itemStack = this.method_7677();
            if (!itemStack.method_7960() && class_1890.method_60142((class_1799)itemStack, (class_9331)class_9701.field_51656)) {
                return false;
            }
            return super.method_7674(player);
        }

        public boolean method_7682() {
            return true;
        }

        public @Nullable class_2960 method_7679() {
            return this.emptyIcon;
        }
    }

    class EntityEquipmentContainer
    implements class_8181 {
        private final class_1304 equipmentSlot;

        EntityEquipmentContainer(class_1304 equipmentSlot) {
            this.equipmentSlot = equipmentSlot;
        }

        public class_1799 method_54079() {
            return InventoryStealingMenu.this.entity.method_6118(this.equipmentSlot);
        }

        public void method_54077(class_1799 itemStack) {
            class_1309 class_13092;
            InventoryStealingMenu.this.entity.method_5673(this.equipmentSlot, itemStack);
            if (!itemStack.method_7960() && (class_13092 = InventoryStealingMenu.this.entity) instanceof class_1308) {
                class_1308 mob = (class_1308)class_13092;
                mob.method_25939(this.equipmentSlot);
                mob.method_5971();
            }
        }

        public int method_5444() {
            return 1;
        }

        public void method_5431() {
        }

        public boolean method_5443(class_1657 player) {
            return InventoryStealingMenu.this.entity.method_5805() && player.method_56094((class_1297)InventoryStealingMenu.this.entity, 4.0);
        }
    }
}

