/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.gui.screen.misc;

import io.github.xienaoban.biologydictionary.BiologyDictionaryClient;
import io.github.xienaoban.biologydictionary.common.util.ClientUtils;
import io.github.xienaoban.biologydictionary.common.util.PlayerUtils;
import io.github.xienaoban.biologydictionary.gui.screen.misc.InventoryStealingMenu;
import io.github.xienaoban.biologydictionary.gui.util.Textures;
import io.github.xienaoban.biologydictionary.net.ClientNetManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_490;

@Environment(value=EnvType.CLIENT)
public class InventoryStealingScreen
extends class_465<InventoryStealingMenu> {
    private final class_1309 entity;
    private final int containerSize;
    private float xMouse;
    private float yMouse;
    private int tickCounter;
    private boolean hasDetected;

    public InventoryStealingScreen(InventoryStealingMenu menu, class_1661 inventory, class_1309 entity) {
        super((class_1703)menu, inventory, (class_2561)class_2561.method_43471((String)"screen.biologydictionary.stealing"));
        this.field_2792 = 234;
        this.field_2779 = 194;
        this.entity = entity;
        this.containerSize = Math.min(menu.container.method_5439(), 36);
        this.tickCounter = 0;
        this.hasDetected = false;
    }

    protected void method_2389(class_332 guiGraphics, float delta, int mouseX, int mouseY) {
        int left = (this.field_22789 - this.field_2792) / 2;
        int top = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_25290(class_10799.field_56883, Textures.STEALING_INVENTORY.location(), left, top, 0.0f, 0.0f, this.field_2792, this.field_2779, (int)Textures.STEALING_INVENTORY.width(), (int)Textures.STEALING_INVENTORY.height());
        int wh = 18;
        int mod = InventoryStealingMenu.calculateMod(this.containerSize);
        for (int i = 0; i < this.containerSize; ++i) {
            guiGraphics.method_25290(class_10799.field_56883, Textures.STEALING_INVENTORY.location(), left + 65 + i % mod * 18, top + 17 + i / mod * 18, (float)((int)Textures.STEALING_INVENTORY.width() - 18), (float)((int)Textures.STEALING_INVENTORY.height() - 18), 18, 18, (int)Textures.STEALING_INVENTORY.width(), (int)Textures.STEALING_INVENTORY.height());
        }
        class_490.method_2486((class_332)guiGraphics, (int)(left + 8), (int)(top + 18), (int)(left + 60), (int)(top + 88), (int)17, (float)0.25f, (float)this.xMouse, (float)this.yMouse, (class_1309)this.entity);
    }

    protected void method_2388(class_332 guiGraphics, int i, int j) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, -1996488705, false);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        this.xMouse = i;
        this.yMouse = j;
        super.method_25394(guiGraphics, i, j, f);
        this.method_2380(guiGraphics, i, j);
    }

    protected void method_37432() {
        if (this.hasDetected) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 10 == 0 && InventoryStealingScreen.isPlayerCaughtByEntity(this.entity, ((InventoryStealingMenu)this.method_17577()).getPlayer())) {
            this.hasDetected = true;
            ClientUtils.getClientPlayer().method_7346();
            BiologyDictionaryClient.sendCenteredWarning(class_2561.method_43471((String)"text.biologydictionary.stealing_detected"));
            ClientNetManager.sendStealingDetected((class_1297)this.entity);
        }
    }

    public static boolean isEntityDetectedBy(class_1309 entity, class_1657 player) {
        class_243 toPlayerHorizontal;
        if (!entity.method_6057((class_1297)player)) {
            return false;
        }
        class_243 entityEyePos = entity.method_5836(1.0f);
        class_243 playerEyePos = player.method_5836(1.0f);
        float partialTick = ClientUtils.getPartialTick();
        class_243 entityLookDir = entity.method_5828(partialTick).method_1029();
        class_243 toPlayer = playerEyePos.method_1020(entityEyePos).method_1029();
        class_243 entityLookHorizontal = new class_243(entityLookDir.field_1352, 0.0, entityLookDir.field_1350).method_1029();
        double dotProduct = entityLookHorizontal.method_1026(toPlayerHorizontal = new class_243(toPlayer.field_1352, 0.0, toPlayer.field_1350).method_1029());
        double angle = Math.acos(class_3532.method_15350((double)dotProduct, (double)-1.0, (double)1.0));
        double angleDegrees = Math.toDegrees(angle);
        return angleDegrees < 66.0;
    }

    public static boolean isPlayerCaughtByEntity(class_1309 entity, class_1657 player) {
        if (PlayerUtils.isCreative(player)) {
            return false;
        }
        return InventoryStealingScreen.isEntityDetectedBy(entity, player);
    }
}

