/*
 * Decompiled with CFR 0.152.
 */
package io.github.xienaoban.biologydictionary.net.payload;

import io.github.xienaoban.biologydictionary.BiologyDictionary;
import io.github.xienaoban.biologydictionary.common.net.Packet;
import io.github.xienaoban.biologydictionary.common.net.ServerNetApi;
import io.github.xienaoban.biologydictionary.common.util.Misc;
import io.github.xienaoban.biologydictionary.core.skill.EntityTargetedSkill;
import io.github.xienaoban.biologydictionary.core.skill.NoPermissionException;
import io.github.xienaoban.biologydictionary.core.skill.Permissions;
import io.github.xienaoban.biologydictionary.core.skill.PlayerSkills;
import net.minecraft.class_1297;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public record RequestEntityTargetedSkillPacket(String skillKey, int entityId, class_2520 args) implements Packet
{
    public static final Packet.Factory<RequestEntityTargetedSkillPacket> FACTORY = RequestEntityTargetedSkillPacket::new;

    private RequestEntityTargetedSkillPacket(class_2540 buf) {
        this(buf.method_19772(), buf.readInt(), buf.method_30616(class_2505.method_53898()));
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10814(this.skillKey);
        buf.method_53002(this.entityId);
        buf.method_10794(this.args);
    }

    @Override
    public void serverReceive(ServerNetApi.Context ctx) {
        class_1297 entity = ctx.player().method_51469().method_8469(this.entityId);
        if (entity == null) {
            BiologyDictionary.LOGGER.warn("Entity ID not found: {}", (Object)this.entityId);
            BiologyDictionary.sendCenteredWarning(ctx.player(), class_2561.method_43471((String)"text.biologydictionary.unknown_entity_id"));
            return;
        }
        try {
            Permissions.checkSkillNotBanned(this.skillKey);
            EntityTargetedSkill<? extends class_1297> skill = PlayerSkills.getEntityTargetedSkill(this.skillKey);
            skill.serverReceive(ctx.server(), ctx.player(), (class_1297)((class_1297)Misc.cast(entity)), this.args);
        }
        catch (NoPermissionException e) {
            BiologyDictionary.LOGGER.warn(Misc.getStackToString(e));
            BiologyDictionary.sendCenteredWarning(ctx.player(), e.getGameMessage());
        }
        catch (Exception e) {
            BiologyDictionary.LOGGER.warn(Misc.getStackToString(e));
        }
    }
}

