/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.mounts_of_mayhem_plus.common.entity.babyRavager;

import com.belgie.mounts_of_mayhem_plus.common.variants.BrutuskVariant;
import com.belgie.mounts_of_mayhem_plus.core.EntityRegistry;
import com.belgie.mounts_of_mayhem_plus.core.SoundRegistry;
import com.belgie.mounts_of_mayhem_plus.core.VariantsRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.monster.illager.Pillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class BabyRavagerEntity
extends AbstractHorse {
    private static final EntityDimensions BABY_DIMENSIONS;
    private static final EntityDataAccessor<Float> STAMINA;
    private static final float MAX_STAMINA = 100.0f;
    private static final Predicate<Entity> ROAR_TARGET_WITH_GRIEFING;
    private static final Predicate<Entity> ROAR_TARGET_WITHOUT_GRIEFING;
    private static final EntityDataAccessor<Holder<BrutuskVariant>> DATA_VARIANT_ID;

    public Holder<BrutuskVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    private void setVariant(Holder<BrutuskVariant> variant) {
        this.entityData.set(DATA_VARIANT_ID, variant);
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> component) {
        return (T)(component == VariantsRegistry.BRUTUSK_VARIANT_COM.get() ? BabyRavagerEntity.castComponentValue(component, (Object)new EitherHolder(this.getVariant())) : super.get(component));
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        this.applyImplicitComponentIfPresent(componentGetter, VariantsRegistry.BRUTUSK_VARIANT_COM.get());
        super.applyImplicitComponents(componentGetter);
    }

    protected <T> boolean applyImplicitComponent(DataComponentType<T> component, T value) {
        if (component == VariantsRegistry.BRUTUSK_VARIANT_COM.get()) {
            this.setVariant((Holder<BrutuskVariant>)((Holder)BabyRavagerEntity.castComponentValue(VariantsRegistry.BRUTUSK_VARIANT_COM.get(), value)));
            return true;
        }
        return super.applyImplicitComponent(component, value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT_ID, (Object)VariantUtils.getDefaultOrAny((RegistryAccess)this.registryAccess(), (ResourceKey)ResourceKey.create(VariantsRegistry.BRUTUSK_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"mounts_of_mayhem_plus", (String)"default"))));
        builder.define(STAMINA, (Object)Float.valueOf(100.0f));
    }

    protected void playGallopSound(SoundType p_480127_) {
        this.playSound(SoundRegistry.BRUTUSK_STEP.get(), p_480127_.getVolume() * 0.15f, p_480127_.getPitch());
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        VariantUtils.writeVariant((ValueOutput)output, this.getVariant());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        VariantUtils.readVariant((ValueInput)input, VariantsRegistry.BRUTUSK_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        Pillager zombieEntity;
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        VariantUtils.selectVariantToSpawn((SpawnContext)SpawnContext.create((ServerLevelAccessor)level, (BlockPos)this.blockPosition()), VariantsRegistry.BRUTUSK_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        if (spawnReason == EntitySpawnReason.PATROL && (zombieEntity = (Pillager)EntityType.PILLAGER.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
            zombieEntity.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            zombieEntity.finalizeSpawn(level, difficulty, spawnReason, (SpawnGroupData)null);
            zombieEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.CROSSBOW));
            zombieEntity.startRiding((Entity)this, false, false);
            this.setTamed(true);
            this.setAge(0);
        }
        return spawnGroupData;
    }

    public BabyRavagerEntity(EntityType<? extends BabyRavagerEntity> p_30894_, Level p_30895_) {
        super(p_30894_, p_30895_);
        this.setPathfindingMalus(PathType.DANGER_OTHER, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return BabyRavagerEntity.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.CAMERA_DISTANCE, 2.0);
    }

    public InteractionResult interact(Player p_478395_, InteractionHand p_479428_) {
        this.setPersistenceRequired();
        return super.interact(p_478395_, p_479428_);
    }

    public float getVoicePitch() {
        return 2.0f;
    }

    public boolean removeWhenFarAway(double p_479978_) {
        return true;
    }

    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof Mob;
    }

    public boolean canFallInLove() {
        return false;
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    public InteractionResult mobInteract(Player p_478329_, InteractionHand p_479271_) {
        boolean flag;
        boolean bl = flag = !this.isBaby() && this.isTamed() && p_478329_.isSecondaryUseActive();
        if (!this.isVehicle() && !flag) {
            ItemStack itemstack = p_478329_.getItemInHand(p_479271_);
            if (!itemstack.isEmpty()) {
                if (this.isFood(itemstack)) {
                    return this.fedFood(p_478329_, itemstack);
                }
                if (!this.isTamed()) {
                    this.makeMad();
                    return InteractionResult.SUCCESS;
                }
            }
            return super.mobInteract(p_478329_, p_479271_);
        }
        return super.mobInteract(p_478329_, p_479271_);
    }

    public boolean canUseSlot(EquipmentSlot p_481976_) {
        return true;
    }

    public boolean canBeLeashed() {
        return this.isTamed() || !this.isMobControlled();
    }

    public boolean isFood(ItemStack p_480617_) {
        return p_480617_.is(ItemTags.ZOMBIE_HORSE_FOOD);
    }

    public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets((Entity)this, (double)-0.4, (double)0.38, (double)0.38, (double)0.9);
    }

    public EntityDimensions getDefaultDimensions(Pose p_479251_) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(p_479251_);
    }

    public float chargeSpeedModifier() {
        return 1.4f;
    }

    public float getStamina() {
        return ((Float)this.entityData.get(STAMINA)).floatValue();
    }

    public void setStamina(float value) {
        this.entityData.set(STAMINA, (Object)Float.valueOf(Mth.clamp((float)value, (float)0.0f, (float)100.0f)));
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide()) {
            this.updateStaminaJumpBarClient();
        }
    }

    private void updateStaminaJumpBarClient() {
        if (!this.isVehicle()) {
            return;
        }
        LivingEntity rider = this.getControllingPassenger();
        if (!(rider instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)rider;
        player.jumpRidingScale = this.getStamina() / 100.0f;
    }

    public void tick() {
        LivingEntity rider;
        super.tick();
        if (!this.level().isClientSide() && this.isVehicle() && (rider = this.getControllingPassenger()) instanceof Player) {
            Player player = (Player)rider;
            float stamina = this.getStamina();
            if (player.isSprinting() && stamina > 0.0f) {
                this.setStamina(stamina - 0.5f);
                this.roar();
            } else {
                this.setStamina(stamina + 0.25f);
            }
            if (stamina <= 0.0f) {
                player.setSprinting(false);
            }
        }
    }

    public boolean canSprint() {
        return true;
    }

    protected boolean canPerformRearing() {
        return false;
    }

    public static boolean checkBabyRavagerSpawnRules(EntityType<BabyRavagerEntity> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource randomSource) {
        return level.getBrightness(LightLayer.BLOCK, pos) > 8 ? false : BabyRavagerEntity.checkAnyLightMonsterSpawnRules(entityType, level, spawnReason, pos, randomSource);
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<BabyRavagerEntity> entityType, LevelAccessor level, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        return level.getDifficulty() != Difficulty.PEACEFUL && BabyRavagerEntity.checkMobSpawnRules(entityType, (LevelAccessor)level, (EntitySpawnReason)spawnReason, (BlockPos)pos, (RandomSource)random);
    }

    protected SoundEvent getAmbientSound() {
        return SoundRegistry.BRUTUSK_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return SoundRegistry.BRUTUSK_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundRegistry.BRUTUSK_HURT.get();
    }

    protected void playSwimSound(float volume) {
        if (this.onGround()) {
            super.playSwimSound(0.3f);
        } else {
            super.playSwimSound(Math.min(0.1f, volume * 25.0f));
        }
    }

    public void onPlayerJump(int jumpPower) {
        if (this.getStamina() < 0.0f) {
            return;
        }
    }

    public boolean canJump() {
        return true;
    }

    public void handleStartJump(int power) {
    }

    public void handleStopJump() {
    }

    private void strongKnockback(Entity entity) {
        double d0 = entity.getX() - this.getX();
        double d1 = entity.getZ() - this.getZ();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.push(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    private void roar() {
        Level var2;
        if (this.isAlive() && (var2 = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var2;
            Predicate<Entity> predicate = EventHooks.canEntityGrief((ServerLevel)serverlevel, (Entity)this) ? ROAR_TARGET_WITH_GRIEFING : ROAR_TARGET_WITHOUT_GRIEFING;
            for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0), predicate)) {
                if (livingentity instanceof Player) continue;
                this.strongKnockback((Entity)livingentity);
            }
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            serverlevel.broadcastEntityEvent((Entity)this, (byte)69);
        }
    }

    protected void playJumpSound() {
        super.playJumpSound();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_149553_, AgeableMob p_149554_) {
        return (AgeableMob)EntityRegistry.BRUTUSK.get().create((Level)p_149553_, EntitySpawnReason.BREEDING);
    }

    static {
        STAMINA = SynchedEntityData.defineId(BabyRavagerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
        ROAR_TARGET_WITH_GRIEFING = p_375882_ -> !(p_375882_ instanceof BabyRavagerEntity) && p_375882_.isAlive();
        ROAR_TARGET_WITHOUT_GRIEFING = p_375881_ -> ROAR_TARGET_WITH_GRIEFING.test((Entity)p_375881_) && !p_375881_.getType().equals(EntityType.ARMOR_STAND);
        DATA_VARIANT_ID = SynchedEntityData.defineId(BabyRavagerEntity.class, VariantsRegistry.BRUTUSK_VARIANT.get());
        BABY_DIMENSIONS = EntityRegistry.BRUTUSK.get().getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityRegistry.BRUTUSK.get().getHeight() - 0.03125f, 0.0f)).scale(0.5f);
    }
}

